/*
 * Decompiled with CFR 0.152.
 */
package jscicalc.graph;

import java.awt.Graphics2D;
import java.awt.font.TextLayout;
import java.awt.geom.Line2D;
import jscicalc.graph.Axis;
import jscicalc.graph.Model;
import jscicalc.graph.View;

public class HAxis
extends Axis {
    protected double y;

    public HAxis() {
        this.setY(0.0);
    }

    public void setY(double d) {
        this.y = d;
    }

    public void draw(Model model, View view, Graphics2D graphics2D) {
        double d;
        double d2 = view.getTransformation().toModelX(0.0);
        double d3 = view.getTransformation().toModelX(view.getWidth());
        double d4 = view.getTransformation().toViewY(this.y);
        Line2D.Double double_ = new Line2D.Double(0.0, d4, view.getWidth(), d4);
        graphics2D.draw(double_);
        if (this.getShowMajorUnit()) {
            d = view.getTransformation().getXMajorUnit();
            double d5 = view.getTransformation().getOriginY();
            for (int i = (int)Math.ceil(d2 / d) - 1; i < (int)Math.floor(d3 / d) + 2; ++i) {
                double d6 = view.getTransformation().toViewX((double)i * d);
                double_ = new Line2D.Double(d6, d4, d6, d4 + (double)this.getMajorUnitTickLength());
                graphics2D.draw(double_);
                String string = this.convertDouble((double)i * d);
                graphics2D.setFont(view.getFont());
                TextLayout textLayout = new TextLayout(string, graphics2D.getFont(), graphics2D.getFontRenderContext());
                float f = textLayout.getVisibleAdvance();
                float f2 = textLayout.getAscent() + textLayout.getLeading();
                if ((double)i * d != d5) {
                    graphics2D.drawString(string, (float)d6 - 0.5f * f, (float)d4 + (float)this.getMajorUnitTickLength() + f2);
                    continue;
                }
                graphics2D.drawString(string, (float)d6 - f - (float)this.getMajorUnitTickLength() - 2.0f, (float)d4 + (float)this.getMajorUnitTickLength() + f2);
            }
        }
        if (this.getShowMinorUnit()) {
            d = view.getTransformation().getXMinorUnit();
            for (int i = (int)Math.ceil(d2 / d) - 1; i < (int)Math.floor(d3 / d) + 2; ++i) {
                double d7 = view.getTransformation().toViewX((double)i * d);
                double_ = new Line2D.Double(d7, d4, d7, d4 + (double)this.getMinorUnitTickLength());
                graphics2D.draw(double_);
            }
        }
    }
}

