/*
 * Decompiled with CFR 0.152.
 */
package jscicalc.graph;

import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.Path2D;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.Vector;
import java.util.concurrent.atomic.AtomicBoolean;
import jscicalc.OObject;
import jscicalc.Substitution;
import jscicalc.complex.Complex;
import jscicalc.graph.Element;
import jscicalc.graph.Model;
import jscicalc.graph.Point;
import jscicalc.graph.PointList;
import jscicalc.graph.Transformation;
import jscicalc.graph.View;
import jscicalc.pobject.Variable;

public class Locus
extends Element
implements Runnable {
    protected static final jscicalc.expression.Variable variable = new jscicalc.expression.Variable(new Variable('x'));
    protected Substitution substitution;
    protected static final double epsilon = 1.0E-32;
    protected static final double delta = 1.0E-8;
    private double incrementValue = 10.0;
    private double distance = 16.0;
    private final OObject oobject;
    private Path2D.Double path;
    private View view;
    private Thread thread;
    private Object lock;
    AtomicBoolean restart;

    public Locus(OObject oObject, View view) {
        System.out.print("*********** OObject is a ");
        System.out.println(oObject.toString());
        this.lock = new Object();
        this.oobject = oObject;
        this.path = new Path2D.Double();
        this.incrementValue = 2.0;
        this.substitution = new Substitution();
        this.setup(view);
    }

    public void setup(View view) {
        System.out.println("Locus.setup()");
        this.view = view;
        this.restart = new AtomicBoolean(false);
        this.thread = new Thread(this);
        this.thread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        System.out.print("Starting thread ");
        Thread thread = Thread.currentThread();
        System.out.println(thread.getName());
        while (this.thread == thread) {
            double d;
            System.out.println("Starting loop");
            this.restart.set(false);
            double d2 = -this.view.distance();
            LinkedList<Point> linkedList = new LinkedList<Point>();
            Transformation transformation = this.view.getTransformation();
            for (double d3 = -this.view.distance(); d3 < (double)this.view.getWidth() + this.view.distance(); d3 += this.increment()) {
                linkedList.add(new Point(d3, this.function(d3, transformation)));
                if (!this.restart.get()) continue;
                System.out.println("restart 1");
                break;
            }
            System.out.println("restart 2");
            if (this.restart.get()) continue;
            ListIterator<Point> listIterator = linkedList.listIterator();
            while (listIterator.hasNext() && !this.restart.get()) {
                Point point = (Point)listIterator.next();
                if (!listIterator.hasNext()) break;
                Point point2 = (Point)listIterator.next();
                listIterator.previous();
                double d4 = point.getX();
                double d5 = point2.getX();
                double d6 = d5 - d4;
                System.out.print("Locus.run(): x = ");
                System.out.print(d4);
                System.out.print(", d = ");
                System.out.println(d6);
                double d7 = point.getY();
                d = point2.getY();
                System.out.print("yp = ");
                System.out.print(d7);
                System.out.print(", yq = ");
                System.out.println(d);
                if (d7 < (double)this.view.getHeight() && d7 > 0.0 && (Double.isInfinite(d) || Double.isNaN(d))) {
                    if (!(d6 > 1.0E-8)) continue;
                    listIterator.add(new Point(d4 + d6 / 2.0, this.function(d4 + d6 / 2.0, transformation)));
                    listIterator.previous();
                    if (!listIterator.hasPrevious()) continue;
                    listIterator.previous();
                    continue;
                }
                if (d < (double)this.view.getHeight() && d > 0.0 && (Double.isInfinite(d7) || Double.isNaN(d7))) {
                    if (!(d6 > 1.0E-8)) continue;
                    listIterator.add(new Point(d4 + d6 / 2.0, this.function(d4 + d6 / 2.0, transformation)));
                    listIterator.previous();
                    if (!listIterator.hasPrevious()) continue;
                    listIterator.previous();
                    continue;
                }
                if (Double.isInfinite(d7) || Double.isNaN(d7) || Double.isInfinite(d) || Double.isNaN(d) || !(d7 < (double)this.view.getHeight() && d7 > 0.0) && (!(d < (double)this.view.getHeight()) || !(d > 0.0)) || !(point.distance(point2) > this.distance) || !(d6 > 1.0E-8)) continue;
                listIterator.add(new Point(d4 + d6 / 2.0, this.function(d4 + d6 / 2.0, transformation)));
                listIterator.previous();
                if (!listIterator.hasPrevious()) continue;
                listIterator.previous();
            }
            System.out.println("restart 3");
            if (this.restart.get()) continue;
            double d8 = 0.0;
            double d9 = this.view.getHeight();
            System.out.print("lb = ");
            System.out.println(d8);
            Vector<PointList> vector = new Vector<PointList>();
            PointList pointList = new PointList();
            Object object = linkedList.listIterator();
            while (object.hasNext() && !this.restart.get()) {
                Point point = (Point)object.next();
                double d10 = point.getY();
                if (Double.isInfinite(d10) || Double.isNaN(d10)) continue;
                if (d10 > d8 && d10 < d9) {
                    pointList.add(point);
                    continue;
                }
                if (pointList.isEmpty()) {
                    if (!object.hasNext()) continue;
                    Point point3 = (Point)object.next();
                    d = point3.getY();
                    object.previous();
                    if (Double.isInfinite(d) || Double.isNaN(d) || !(d > d8) || !(d < d9)) continue;
                    pointList.add(point);
                    continue;
                }
                pointList.add(point);
                vector.add(pointList);
                pointList = new PointList();
            }
            System.out.println("restart 4");
            if (this.restart.get()) continue;
            if (!pointList.isEmpty()) {
                vector.add(pointList);
            }
            object = new Path2D.Double();
            Object object2 = vector.listIterator();
            while (object2.hasNext()) {
                PointList pointList2 = (PointList)object2.next();
                pointList2.addToPath((Path2D.Double)object, this.restart);
            }
            object2 = this.path;
            synchronized (object2) {
                this.path = object;
            }
            this.view.setCursor(null);
            this.view.repaint();
            object2 = this.lock;
            synchronized (object2) {
                if (this.restart.get()) {
                    continue;
                }
                try {
                    System.out.println("Waiting");
                    this.lock.wait();
                    System.out.println("finished waiting");
                }
                catch (InterruptedException interruptedException) {
                    System.out.println("interrupted");
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updatePath() {
        if (this.thread == null) {
            return;
        }
        this.restart.set(true);
        Object object = this.lock;
        synchronized (object) {
            System.out.println("updatePath()");
            this.lock.notifyAll();
        }
    }

    public void stop() {
        this.thread = null;
    }

    protected OObject substitute(double d) {
        this.substitution.add(variable, new Complex(d));
        OObject oObject = this.oobject.substitute(this.substitution).auto_simplify();
        return oObject;
    }

    protected double function(double d, Transformation transformation) {
        Complex complex;
        System.out.print("[function( ");
        System.out.print(transformation.toModelX(d));
        System.out.print(" ) = ");
        OObject oObject = this.substitute(transformation.toModelX(d));
        if (oObject instanceof Complex && Math.abs((complex = (Complex)oObject).imaginary()) < 1.0E-32) {
            double d2 = complex.real();
            System.out.print(d2);
            System.out.print("]");
            return transformation.toViewY(complex.real());
        }
        return Double.NaN;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void draw(Model model, View view, Graphics2D graphics2D) {
        Path2D.Double double_ = this.path;
        synchronized (double_) {
            Rectangle rectangle = this.path.getBounds();
            System.out.print("path x =  ");
            System.out.println(rectangle.x);
            System.out.print("path y =  ");
            System.out.println(rectangle.y);
            System.out.print("path width =  ");
            System.out.println(rectangle.width);
            System.out.print("path height =  ");
            System.out.println(rectangle.height);
            Rectangle rectangle2 = view.getBounds();
            System.out.print("view x =  ");
            System.out.println(rectangle2.x);
            System.out.print("view y =  ");
            System.out.println(rectangle2.y);
            System.out.print("view width =  ");
            System.out.println(rectangle2.width);
            System.out.print("view height =  ");
            System.out.println(rectangle2.height);
            System.out.println("drawing object");
            graphics2D.draw(this.path);
        }
    }

    double increment() {
        return this.incrementValue;
    }

    protected class FindResult {
        public Point point;
        public boolean interiorPoint;
        public boolean success;

        FindResult(Point point, boolean bl, boolean bl2) {
            this.point = point;
            this.interiorPoint = bl;
            this.success = bl2;
        }
    }
}

