/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.gui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.util.StringTokenizer;
import javax.swing.JComponent;
import javax.swing.SwingConstants;

public class JMultiLineLabel
extends JComponent
implements SwingConstants {
    private String text;
    private int hAlignment = 2;
    private int vAlignment = 1;
    private int numLines;
    private String[] lines;
    private int[] lineWidths;
    private int maxWidth;
    private int lineHeight;
    private int lineAscent;
    private boolean measured = false;

    public JMultiLineLabel() {
        this("");
    }

    public JMultiLineLabel(String text) {
        this(text, 2);
    }

    public JMultiLineLabel(String text, int hAlignment) {
        this.text = text;
        this.hAlignment = hAlignment;
        this.findLinebreaks();
    }

    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (!this.measured) {
            this.measure();
        }
        Dimension size = this.getSize();
        Insets ins = this.getInsets();
        int y = this.vAlignment == 0 ? (size.height - this.numLines * this.lineHeight) / 2 : (this.vAlignment == 3 ? size.height - ins.bottom - (this.numLines - 1) * this.lineHeight : ins.top + this.lineAscent);
        int i = 0;
        while (i < this.numLines) {
            int x = this.hAlignment == 0 ? (size.width - this.lineWidths[i]) / 2 : (this.hAlignment == 4 ? size.width - ins.right - this.lineWidths[i] : ins.left);
            g.drawString(this.lines[i], x, y);
            ++i;
            y += this.lineHeight;
        }
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
        this.findLinebreaks();
        this.measured = false;
        this.repaint();
    }

    public void setFont(Font f) {
        super.setFont(f);
        this.measured = false;
        this.repaint();
    }

    public void setForeground(Color c) {
        super.setForeground(c);
        this.repaint();
    }

    public int getHorizontalAlignment() {
        return this.hAlignment;
    }

    public void setHorizontalAlignment(int hAlignment) {
        this.hAlignment = hAlignment;
        this.repaint();
    }

    public int getVerticalAlignment() {
        return this.vAlignment;
    }

    public void setVerticalAlignment(int vAlignment) {
        this.vAlignment = vAlignment;
        this.repaint();
    }

    public Dimension getPreferredSize() {
        if (!this.measured) {
            this.measure();
        }
        Insets ins = this.getInsets();
        return new Dimension(this.maxWidth + ins.left + ins.right, this.numLines * this.lineHeight + ins.top + ins.right);
    }

    private synchronized void findLinebreaks() {
        StringTokenizer t = new StringTokenizer(this.text, "\n");
        this.numLines = t.countTokens();
        this.lines = new String[this.numLines];
        this.lineWidths = new int[this.numLines];
        int i = 0;
        while (i < this.numLines) {
            this.lines[i] = t.nextToken();
            ++i;
        }
    }

    private synchronized void measure() {
        FontMetrics fm = this.getToolkit().getFontMetrics(this.getFont());
        this.lineHeight = fm.getHeight();
        this.lineAscent = fm.getAscent();
        this.maxWidth = 0;
        int i = 0;
        while (i < this.numLines) {
            this.lineWidths[i] = fm.stringWidth(this.lines[i]);
            if (this.lineWidths[i] > this.maxWidth) {
                this.maxWidth = this.lineWidths[i];
            }
            ++i;
        }
        this.measured = true;
    }
}

