/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.img;

import gov.nasa.giss.img.BitUtils;
import java.io.IOException;
import java.io.OutputStream;

class ImageDescriptor {
    public byte separator_;
    public short leftPosition_;
    public short topPosition_;
    public short width_;
    public short height_;
    private byte byte_;

    public ImageDescriptor(short width, short height, char separator) {
        this.separator_ = (byte)separator;
        this.leftPosition_ = 0;
        this.topPosition_ = 0;
        this.width_ = width;
        this.height_ = height;
        this.setLocalColorTableSize((byte)0);
        this.setReserved((byte)0);
        this.setSortFlag((byte)0);
        this.setInterlaceFlag((byte)0);
        this.setLocalColorTableFlag((byte)0);
    }

    public void write(OutputStream output) throws IOException {
        output.write(this.separator_);
        BitUtils.writeWord(output, this.leftPosition_);
        BitUtils.writeWord(output, this.topPosition_);
        BitUtils.writeWord(output, this.width_);
        BitUtils.writeWord(output, this.height_);
        output.write(this.byte_);
    }

    public void setLocalColorTableSize(byte num) {
        this.byte_ = (byte)(this.byte_ | num & 7);
    }

    public void setReserved(byte num) {
        this.byte_ = (byte)(this.byte_ | (num & 3) << 3);
    }

    public void setSortFlag(byte num) {
        this.byte_ = (byte)(this.byte_ | (num & 1) << 5);
    }

    public void setInterlaceFlag(byte num) {
        this.byte_ = (byte)(this.byte_ | (num & 1) << 6);
    }

    public void setLocalColorTableFlag(byte num) {
        this.byte_ = (byte)(this.byte_ | (num & 1) << 7);
    }
}

