/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.mapping.proj;

import gov.nasa.giss.mapping.proj.AbstractProjection;
import java.awt.Point;

public class FlatPolarSinusoidal
extends AbstractProjection {
    private static final String PROJECTION_NAME = "M.T. Flat-Polar Sinusoidal";
    private static final boolean IS_AZIMUTHAL = false;
    private static final double TERM1 = Math.sqrt(1.1902654422649654);
    private static final double ONE_OVER_TERM1 = 1.0 / TERM1;
    private static final double TERM2 = 0.5600991535115574;
    private static final double ONE_OVER_TERM2 = 1.7853981633974483;
    private static final double FIT_WIDTH = ONE_OVER_TERM1 * Math.PI;
    private static final double FIT_HEIGHT = 0.5 * ONE_OVER_TERM1 * Math.PI;
    private double scaleFactor = 1.0;
    public static final double ASPECT_RATIO = FIT_WIDTH / FIT_HEIGHT;
    private double radius;
    private double rS;
    private double oneOverR;
    private double oneOverRS;
    private double twoOverRS;

    public FlatPolarSinusoidal(int dw, int dh) {
        this(dw, dh, 0, 0, 0.0);
    }

    public FlatPolarSinusoidal(Integer dw, Integer dh, Integer xm, Integer ym, Double longitude) {
        this((int)dw, (int)dh, (int)xm, (int)ym, (double)longitude);
    }

    public FlatPolarSinusoidal(int dw, int dh, int xm, int ym, double longitude) {
        this.init(dw, dh, xm, ym, longitude, 0.0);
        this.radius = Math.min(0.5 * (double)this.useHeight / FIT_HEIGHT, 0.5 * (double)this.useWidth / FIT_WIDTH);
        this.oneOverR = 1.0 / this.radius;
        this.rS = this.radius * this.scaleFactor;
        this.oneOverRS = 1.0 / this.rS;
        this.twoOverRS = 2.0 * this.oneOverRS;
    }

    public static String getProjectionName() {
        return PROJECTION_NAME;
    }

    public static boolean isAzimuthal() {
        return false;
    }

    public static double getAspectRatio() {
        return ASPECT_RATIO;
    }

    protected void calculateInverseArray() {
        this.clearInverseArray();
        int y = 0;
        while ((double)y < 0.5 * (double)this.useHeight) {
            int row = this.yCenter - y;
            int rowF = this.yCenter + y;
            double thetaRad = (double)y * this.oneOverRS * TERM1;
            double sinTheta = Math.sin(thetaRad);
            double phi = AbstractProjection.toDegrees(Math.asin((0.5 * thetaRad + sinTheta) * 0.5600991535115574));
            if (phi > 90.0 || phi < -90.0) break;
            int yMap = (int)(this.srcYPixPerDeg * (90.0 - phi));
            int yMapF = (int)(this.srcYPixPerDeg * (90.0 + phi));
            double xFactor = 1.5 * this.oneOverRS * TERM1 / (0.5 + Math.cos(thetaRad));
            int x = 0;
            while (x < this.xCenter) {
                double dlambda = -AbstractProjection.toDegrees((double)x * xFactor);
                if (dlambda > 180.0 || dlambda < -180.0) break;
                int col = this.xCenter + x;
                int colF = this.xCenter - x;
                int xMap = (int)(this.srcXPixPerDeg * (180.0 - this.copLon - dlambda));
                int xMapF = (int)(this.srcXPixPerDeg * (180.0 - this.copLon + dlambda));
                while (xMap >= this.srcWidth) {
                    xMap -= this.srcWidth;
                }
                while (xMapF >= this.srcWidth) {
                    xMapF -= this.srcWidth;
                }
                while (xMap < 0) {
                    xMap += this.srcWidth;
                }
                while (xMapF < 0) {
                    xMapF += this.srcWidth;
                }
                this.invArray[row * this.dstWidth + col] = yMap * this.srcWidth + xMap;
                this.invArray[row * this.dstWidth + colF] = yMap * this.srcWidth + xMapF;
                this.invArray[rowF * this.dstWidth + col] = yMapF * this.srcWidth + xMap;
                this.invArray[rowF * this.dstWidth + colF] = yMapF * this.srcWidth + xMapF;
                ++x;
            }
            ++y;
        }
        this.needsUpdate = false;
    }

    public Point transformLL2XY(double longitude, double latitude) {
        double phiTerm = 1.7853981633974483 * Math.sin(AbstractProjection.toRadians(latitude));
        double thetaRad = AbstractProjection.toRadians(latitude);
        int i = 0;
        while (i < 25) {
            double sinTheta = Math.sin(thetaRad);
            double cosTheta = Math.cos(thetaRad);
            double dthetaRad = -(0.5 * thetaRad + sinTheta - phiTerm) / (0.5 + cosTheta);
            thetaRad += dthetaRad;
            if (Math.abs(dthetaRad) < 1.0E-5) break;
            ++i;
        }
        double dlambda = longitude - this.copLon;
        while (dlambda > 180.0) {
            dlambda -= 360.0;
        }
        while (dlambda < -180.0) {
            dlambda += 360.0;
        }
        double x = -this.rS * AbstractProjection.toRadians(dlambda) * ONE_OVER_TERM1 * (0.5 + Math.cos(thetaRad)) / 1.5;
        double y = this.rS * thetaRad * ONE_OVER_TERM1;
        return new Point(this.xCenter + (int)x, this.yCenter - (int)y);
    }
}

