/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.mapping.proj;

import gov.nasa.giss.mapping.proj.AbstractProjection;
import java.awt.Point;

public class Wagner5
extends AbstractProjection {
    private static final String PROJECTION_NAME = "Wagner V";
    private static final boolean IS_AZIMUTHAL = false;
    private static final double CSUBP = 3.00896;
    private static final double CSUBX = 0.90977;
    private static final double CSUBY = 1.65014;
    private static final double ONE_OVER_CSUBP = 0.332340742316282;
    private static final double ONE_OVER_CSUBX = 1.0991789133517262;
    private static final double ONE_OVER_CSUBY = 0.6060091870992764;
    private static final double FIT_WIDTH = 2.858126748456386;
    private static final double FIT_HEIGHT = 1.4710338044;
    private double scaleFactor = 1.0;
    public static final double ASPECT_RATIO = 1.9429375041603132;
    private double radius;
    private double rS;
    private double oneOverR;
    private double oneOverRS;

    public Wagner5(int dw, int dh) {
        this(dw, dh, 0, 0, 0.0);
    }

    public Wagner5(Integer dw, Integer dh, Integer xm, Integer ym, Double longitude) {
        this((int)dw, (int)dh, (int)xm, (int)ym, (double)longitude);
    }

    public Wagner5(int dw, int dh, int xm, int ym, double longitude) {
        this.init(dw, dh, xm, ym, longitude, 0.0);
        this.radius = Math.min(0.5 * (double)this.useHeight / 1.4710338044, 0.5 * (double)this.useWidth / 2.858126748456386);
        this.oneOverR = 1.0 / this.radius;
        this.rS = this.radius * this.scaleFactor;
        this.oneOverRS = 1.0 / this.rS;
    }

    public static String getProjectionName() {
        return PROJECTION_NAME;
    }

    public static boolean isAzimuthal() {
        return false;
    }

    public static double getAspectRatio() {
        return 1.9429375041603132;
    }

    protected void calculateInverseArray() {
        this.clearInverseArray();
        int y = 0;
        while ((double)y < 0.5 * (double)this.useHeight) {
            int row = this.yCenter - y;
            int rowF = this.yCenter + y;
            double halfThetaRad = Math.asin((double)y * this.oneOverRS * 0.6060091870992764);
            double thetaRad = 2.0 * halfThetaRad;
            double phiRad = Math.asin((thetaRad + Math.sin(thetaRad)) * 0.332340742316282);
            double phi = AbstractProjection.toDegrees(phiRad);
            if (phi > 90.0 || phi < -90.0) break;
            int yMap = (int)(this.srcYPixPerDeg * (90.0 - phi));
            int yMapF = (int)(this.srcYPixPerDeg * (90.0 + phi));
            double xFactor = this.oneOverRS * 1.0991789133517262 / Math.cos(halfThetaRad);
            int x = 0;
            while (x < this.xCenter) {
                double dlambda = -AbstractProjection.toDegrees((double)x * xFactor);
                if (dlambda > 180.0 || dlambda < -180.0) break;
                int col = this.xCenter + x;
                int colF = this.xCenter - x;
                int xMap = (int)(this.srcXPixPerDeg * (180.0 - this.copLon - dlambda));
                int xMapF = (int)(this.srcXPixPerDeg * (180.0 - this.copLon + dlambda));
                while (xMap >= this.srcWidth) {
                    xMap -= this.srcWidth;
                }
                while (xMapF >= this.srcWidth) {
                    xMapF -= this.srcWidth;
                }
                while (xMap < 0) {
                    xMap += this.srcWidth;
                }
                while (xMapF < 0) {
                    xMapF += this.srcWidth;
                }
                this.invArray[row * this.dstWidth + col] = yMap * this.srcWidth + xMap;
                this.invArray[row * this.dstWidth + colF] = yMap * this.srcWidth + xMapF;
                this.invArray[rowF * this.dstWidth + col] = yMapF * this.srcWidth + xMap;
                this.invArray[rowF * this.dstWidth + colF] = yMapF * this.srcWidth + xMapF;
                ++x;
            }
            ++y;
        }
        this.needsUpdate = false;
    }

    public Point transformLL2XY(double longitude, double latitude) {
        double phiFactor = 3.00896 * Math.sin(AbstractProjection.toRadians(latitude));
        double thetaRad = AbstractProjection.toRadians(latitude);
        int i = 0;
        while (i < 25) {
            double dthetaRad = (thetaRad + Math.sin(thetaRad) - phiFactor) / (1.0 + Math.cos(thetaRad));
            thetaRad -= dthetaRad;
            if (Math.abs(dthetaRad) < 1.0E-5) break;
            ++i;
        }
        double dlambda = longitude - this.copLon;
        while (dlambda > 180.0) {
            dlambda -= 360.0;
        }
        while (dlambda < -180.0) {
            dlambda += 360.0;
        }
        double x = -0.90977 * this.rS * AbstractProjection.toRadians(dlambda) * Math.cos(0.5 * thetaRad);
        double y = 1.65014 * this.rS * Math.sin(0.5 * thetaRad);
        return new Point(this.xCenter + (int)x, this.yCenter - (int)y);
    }
}

