/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.mars24.application;

import gov.nasa.giss.gui.JMultiLineLabel;
import gov.nasa.giss.mars24.application.M24Globals;
import gov.nasa.giss.mars24.application.M24Menubar;
import gov.nasa.giss.mars24.application.M24WindowMenu;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Rectangle;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

class M24AboutFrame
extends JFrame {
    private static final int SHOW_DURATION = 6000000;
    private static final Font BOLD14 = new Font("SansSerif", 1, 14);
    private static final Font PLAIN10 = new Font("SansSerif", 0, 10);
    private static final Font PLAIN8 = new Font("SansSerif", 0, 8);
    private static M24AboutFrame aboutFrame;
    private static Thread splashThread;

    public static void reveal() {
        if (aboutFrame == null) {
            aboutFrame = new M24AboutFrame();
        }
        if (aboutFrame.isShowing()) {
            aboutFrame.toFront();
            return;
        }
        final Runnable closerRunner = new Runnable(){

            public void run() {
                aboutFrame.setVisible(false);
            }
        };
        Runnable waitRunner = new Runnable(){

            public void run() {
                try {
                    Thread.sleep(6000000L);
                    SwingUtilities.invokeAndWait(closerRunner);
                }
                catch (Exception exc) {
                    exc.printStackTrace();
                }
            }
        };
        if (aboutFrame == null) {
            return;
        }
        aboutFrame.setVisible(true);
        splashThread = new Thread(waitRunner, "SplashThread");
        splashThread.start();
    }

    private M24AboutFrame() {
        this.setJMenuBar(new M24Menubar(this));
        this.setResizable(false);
        this.setTitle("About Mars24");
        JPanel contentPanel = new JPanel();
        contentPanel.setBorder(BorderFactory.createEmptyBorder(12, 12, 12, 12));
        contentPanel.setLayout(new BoxLayout(contentPanel, 1));
        try {
            JLabel iconLabel = new JLabel(new ImageIcon(this.getClass().getResource("mars24.png")));
            iconLabel.setAlignmentX(0.5f);
            contentPanel.add(iconLabel);
            contentPanel.add(Box.createVerticalStrut(8));
        }
        catch (Exception exc) {
            // empty catch block
        }
        JLabel titleLabel = new JLabel("Mars24", 0);
        titleLabel.setFont(BOLD14);
        titleLabel.setAlignmentX(0.5f);
        JLabel versionLabel = new JLabel("Version 5.1", 0);
        versionLabel.setFont(PLAIN10);
        versionLabel.setAlignmentX(0.5f);
        JLabel buildLabel = new JLabel("(Build 3A30)", 0);
        buildLabel.setFont(PLAIN8);
        buildLabel.setAlignmentX(0.5f);
        contentPanel.add(titleLabel);
        contentPanel.add(Box.createVerticalStrut(8));
        contentPanel.add(versionLabel);
        contentPanel.add(buildLabel);
        contentPanel.add(Box.createVerticalStrut(8));
        JMultiLineLabel authorText = new JMultiLineLabel("By Robert B. Schmunk\n<rschmunk@giss.nasa.gov>\n \nBased on work by Michael D. Allison\n<mallison@giss.nasa.gov>.\n \nNASA Goddard Institute for Space Studies\n2880 Broadway, New York, NY 10025 USA", 0);
        authorText.setFont(PLAIN10);
        authorText.setAlignmentX(0.5f);
        contentPanel.add(authorText);
        contentPanel.add(Box.createVerticalStrut(8));
        JMultiLineLabel moreText = new JMultiLineLabel("For more information, see:\nhttp://www.giss.nasa.gov/tools/mars24/\n\n", 0);
        moreText.setFont(PLAIN10);
        contentPanel.add(moreText);
        contentPanel.add(Box.createVerticalStrut(8));
        JLabel gissLabel = new JLabel("NASA GISS", 0);
        gissLabel.setFont(BOLD14);
        gissLabel.setAlignmentX(0.5f);
        contentPanel.add(gissLabel);
        contentPanel.add(Box.createVerticalStrut(4));
        this.getContentPane().add(contentPanel);
        this.addWindowListener(new WindowAdapter(){

            public void windowActivated(WindowEvent e) {
                ((M24WindowMenu)((M24Menubar)M24AboutFrame.this.getJMenuBar()).getMenu("Window")).update();
            }
        });
        this.pack();
        Rectangle rr = M24Globals.getMainScreenBounds();
        if (rr == null) {
            this.setLocation(25, 25);
        } else {
            Dimension psize = this.getContentPane().getPreferredSize();
            int x = (rr.width - psize.width) / 2;
            int y = (rr.height - psize.height) / 2;
            this.setLocation(rr.x + x, rr.y + y);
        }
    }
}

