/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.mars24.application;

import gov.nasa.giss.gui.CommonShortcuts;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;

abstract class M24AbstractMenu
extends JMenu {
    protected static final boolean IS_MACINTOSH = System.getProperty("mrj.version") != null;
    protected static final int SHORTCUT_MASK = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
    protected static final String RADIO_ICON_KEY = "RadioButtonMenuItem.checkIcon";
    protected static final String CHECK_ICON_KEY = "CheckBoxMenuItem.checkIcon";

    M24AbstractMenu() {
    }

    M24AbstractMenu(Action a) {
        super(a);
    }

    M24AbstractMenu(String s) {
        super(s);
        this.setName(s);
    }

    M24AbstractMenu(String s, boolean b) {
        super(s, b);
        this.setName(s);
    }

    protected void passKeystrokeToFocusedComponent(String name, ActionEvent e) {
        KeyStroke ks = CommonShortcuts.get(name);
        if (ks == null) {
            return;
        }
        JFrame f = (JFrame)this.getTopLevelAncestor();
        if (f == null) {
            return;
        }
        ((JComponent)f.getFocusOwner()).getActionForKeyStroke(ks).actionPerformed(e);
    }

    protected JMenuItem makeFocusedComponentMenuItem(String name) {
        return this.makeFocusedComponentMenuItem(name, true);
    }

    protected JMenuItem makeFocusedComponentMenuItem(final String name, boolean enabled) {
        JMenuItem mi = new JMenuItem(name);
        mi.setName(name.toLowerCase());
        KeyStroke shortcut = CommonShortcuts.get(name);
        if (shortcut != null) {
            mi.setAccelerator(shortcut);
        }
        mi.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                try {
                    M24AbstractMenu.this.passKeystrokeToFocusedComponent(name, e);
                }
                catch (Exception exc) {}
            }
        });
        return mi;
    }

    protected JMenuItem makeSimpleMenuItem(String name) {
        JMenuItem mi = new JMenuItem(name);
        mi.setName(name.toLowerCase());
        KeyStroke shortcut = CommonShortcuts.get(name);
        if (shortcut != null) {
            mi.setAccelerator(shortcut);
        }
        return mi;
    }

    public void setItemAction(String name, Action action) {
        int isize = this.getItemCount();
        int i = 0;
        while (i < isize) {
            if (this.getItem(i) != null && this.getItem(i).getName() != null && this.getItem(i).getName().toLowerCase().equals(name.toLowerCase())) {
                this.getItem(i).setAction(action);
                return;
            }
            ++i;
        }
    }

    public JMenuItem getItem(String name) {
        int isize = this.getItemCount();
        int i = 0;
        while (i < isize) {
            if (this.getItem(i) != null && this.getItem(i).getName() != null && this.getItem(i).getName().toLowerCase().equals(name.toLowerCase())) {
                return this.getItem(i);
            }
            ++i;
        }
        return null;
    }

    public Action getItemAction(String name) {
        int isize = this.getItemCount();
        int i = 0;
        while (i < isize) {
            if (this.getItem(i) != null && this.getItem(i).getName() != null && this.getItem(i).getName().toLowerCase().equals(name.toLowerCase())) {
                return this.getItem(i).getAction();
            }
            ++i;
        }
        return null;
    }

    public void update() {
    }
}

