/**
 * @(#)ReadingDuration.java
 *
 * This class is created to allow users to learn 
 * for how long they have been reading. The class 
 * consists of a method named showTime, which by
 * itself creates a Dialog to show the time in the 
 * current language.
 *
 * @author Mehmet Mithat Cinar
 * @version 1.00 21.12.2009
 */

package bin;
 
import java.util.Calendar;
import javax.swing.JOptionPane;
import java.awt.Frame;

public class ReadingDuration {
	
	/**
     * <code>startTime</code><br>
     * The time that the class was created. 
     * Stored as a long variable.
     */
    private static int startTime;
    
	/**
     * <code>initialize</code><br>
     * Stores the start time to later use.
     */
    public static void initialize() {
    	// Initialize the starting time
    	startTime = now();
    }
	
	/**
     * <code>now</code><br>
     * Returns the current date as minutes.
     * @return The current date as minutes.
     */
    private static int now() {
    	// Create a Calendar object
		Calendar c = Calendar.getInstance();
		// Return the long that represents time by dividing it 60000
		return (int)(c.getTimeInMillis()/60000);
	}
    
    /**
     * <code>format</code><br>
     * Formats the int-type time information as
     * "x hours y minutes" in the current language.
     * @return The String representation of time.
     */
    private static String format (int i) {
    	// Return the String representation of time, don't show "hours" if hours is zero
    	return ((i<60)?"":(""+ (i/60) + " " + Language.getText(25) + " ")) + i%60 + " " + Language.getText(26);
    }
	
    /**
     * <code>getTime</code><br>
     * Returns the formatted version of the time passed
     * since the program was opened.
     * @return The String representation of time.
     */
    public static String getTime() {
    	// Return the difference between now and then in a formatted way
		return format(now() - startTime);
    }
    
    /**
     * <code>showTime</code><br>
     * Creates a dialog window which shows the time passed 
     * since the program was opened.
     */
    public static void showTime() {
    	// Create the message dialog in the current language
    	JOptionPane.showMessageDialog((Frame)null,getTime(),Language.getText(24),JOptionPane.INFORMATION_MESSAGE);
    }
}