/*
 * Decompiled with CFR 0.152.
 */
package de.beagtex.control;

import de.beagtex.gui.Editor;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.undo.CannotRedoException;

public class RedoAction
extends AbstractAction {
    private static final long serialVersionUID = 1L;
    Editor editor;

    public RedoAction(Editor editor) {
        this.editor = editor;
        this.setEnabled(false);
    }

    public void actionPerformed(ActionEvent e) {
        this.actionPerformedEditor();
    }

    public void update() {
        this.updateEditor();
    }

    private void actionPerformedEditor() {
        try {
            this.editor.getUndoMan().redo();
        }
        catch (CannotRedoException ex) {
            System.err.println("Kein weiterer Redo m\u00f6glich!");
        }
        this.update();
        this.editor.redoAction.update();
    }

    private void updateEditor() {
        if (this.editor.getUndoMan().canRedo()) {
            this.setEnabled(true);
            this.putValue("Name", this.editor.getUndoMan().getRedoPresentationName());
            this.editor.getBFrame().getBlButtons().getSaveB().setEnabled(true);
        } else {
            this.setEnabled(false);
            this.putValue("Name", "Undo");
        }
    }
}

