package de.beagtex.listener.format;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.JComboBox;

import de.beagtex.gui.Editor;

/**
 * Listener for the format-choice in LaTex-Code; analyzes the Format-ComboBox
 * and creats the LaTex-Command
 * 
 * @author Benjamin Haag
 * 
 */
public class FormatListener implements ActionListener {

	Editor editor;
	JComboBox form;

	final int part = 0;
	final int partX = 1;
	final int chapter = 2;
	final int chapterX = 3;
	final int section = 4;
	final int sectionX = 5;
	final int subsection = 6;
	final int subsectionX = 7;
	final int subsubsection = 8;
	final int subsubsectionX = 9;

	/**
	 * Constructor
	 * 
	 * @param editor:
	 *            the calling editor
	 */
	public FormatListener(Editor editor) {
		this.editor = editor;
	}

	public void actionPerformed(ActionEvent arg0) {

		form = editor.getBFrame().getFormate().getCbFormats();
		switch (form.getSelectedIndex()) {

		case part:
			if (editor.getSelectedText() == null) {
				editor.insert("\\part{}", editor.getCaretPosition());
				editor.requestFocus();
				editor.setCaretPosition(editor.getCaretPosition() - 1);
			} else {
				editor.insert("\\part{", editor.getSelectionStart());
				editor.insert("}", editor.getSelectionEnd());
				editor.requestFocus();
				editor.setCaretPosition(editor.getSelectionEnd());
			}
			break;

		case partX:
			if (editor.getSelectedText() == null) {
				editor.insert("\\part*{}", editor.getCaretPosition());
				editor.requestFocus();
				editor.setCaretPosition(editor.getCaretPosition() - 1);
			} else {
				editor.insert("\\part*{", editor.getSelectionStart());
				editor.insert("}", editor.getSelectionEnd());
				editor.requestFocus();
				editor.setCaretPosition(editor.getSelectionEnd());
			}
			break;

		case chapter:
			if (editor.getSelectedText() == null) {
				editor.insert("\\chapter{}", editor.getCaretPosition());
				editor.requestFocus();
				editor.setCaretPosition(editor.getCaretPosition() - 1);
			} else {
				editor.insert("\\chapter{", editor.getSelectionStart());
				editor.insert("}", editor.getSelectionEnd());
				editor.requestFocus();
				editor.setCaretPosition(editor.getSelectionEnd());
			}
			break;
		case chapterX:
			if (editor.getSelectedText() == null) {
				editor.insert("\\chapter*{}", editor.getCaretPosition());
				editor.requestFocus();
				editor.setCaretPosition(editor.getCaretPosition() - 1);
			} else {
				editor.insert("\\chapter*{", editor.getSelectionStart());
				editor.insert("}", editor.getSelectionEnd());
				editor.requestFocus();
				editor.setCaretPosition(editor.getSelectionEnd());
			}
			break;

		case section:
			if (editor.getSelectedText() == null) {
				editor.insert("\\section{}", editor.getCaretPosition());
				editor.requestFocus();
				editor.setCaretPosition(editor.getCaretPosition() - 1);
			} else {
				editor.insert("\\section{", editor.getSelectionStart());
				editor.insert("}", editor.getSelectionEnd());
				editor.requestFocus();
				editor.setCaretPosition(editor.getSelectionEnd());
			}
			break;

		case sectionX:
			if (editor.getSelectedText() == null) {
				editor.insert("\\section*{}", editor.getCaretPosition());
				editor.requestFocus();
				editor.setCaretPosition(editor.getCaretPosition() - 1);
			} else {
				editor.insert("\\section*{", editor.getSelectionStart());
				editor.insert("}", editor.getSelectionEnd());
				editor.requestFocus();
				editor.setCaretPosition(editor.getSelectionEnd());
			}
			break;

		case subsection:
			if (editor.getSelectedText() == null) {
				editor.insert("\\subsection{}", editor.getCaretPosition());
				editor.requestFocus();
				editor.setCaretPosition(editor.getCaretPosition() - 1);
			} else {
				editor.insert("\\subsection{", editor.getSelectionStart());
				editor.insert("}", editor.getSelectionEnd());
				editor.requestFocus();
				editor.setCaretPosition(editor.getSelectionEnd());
			}
			break;

		case subsectionX:
			if (editor.getSelectedText() == null) {
				editor.insert("\\subsection*{}", editor.getCaretPosition());
				editor.requestFocus();
				editor.setCaretPosition(editor.getCaretPosition() - 1);
			} else {
				editor.insert("\\subsection*{", editor.getSelectionStart());
				editor.insert("}", editor.getSelectionEnd());
				editor.requestFocus();
				editor.setCaretPosition(editor.getSelectionEnd());
			}
			break;

		case subsubsection:
			if (editor.getSelectedText() == null) {
				editor.insert("\\subsubsection{}", editor.getCaretPosition());
				editor.requestFocus();
				editor.setCaretPosition(editor.getCaretPosition() - 1);
			} else {
				editor.insert("\\subsubsection{", editor.getSelectionStart());
				editor.insert("}", editor.getSelectionEnd());
				editor.requestFocus();
				editor.setCaretPosition(editor.getSelectionEnd());
			}
			break;

		case subsubsectionX:
			if (editor.getSelectedText() == null) {
				editor.insert("\\subsubsection*{}", editor.getCaretPosition());
				editor.requestFocus();
				editor.setCaretPosition(editor.getCaretPosition() - 1);
			} else {
				editor.insert("\\subsubsection*{", editor.getSelectionStart());
				editor.insert("}", editor.getSelectionEnd());
				editor.requestFocus();
				editor.setCaretPosition(editor.getSelectionEnd());
			}
			break;
		}
	}

}
