package de.beagtex.listener.format;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import de.beagtex.gui.Editor;

/**
 * Listener right-alignment in LaTex-Code
 * 
 * @author Benjamin Haag
 */
public class RightListener implements ActionListener {

	Editor editor;

	/**
	 * Constructor
	 * 
	 * @param editor:the
	 *            calling editor
	 */
	public RightListener(Editor editor) {

		this.editor = editor;
	}

	public void actionPerformed(ActionEvent arg0) {

		if (editor.getSelectedText() == null) {
			editor.insert("\\begin{flushright}" + "\r\n" + "\r\n"
					+ "\\end{flushright}", editor.getCaretPosition());
			editor.requestFocus();
			editor.setCaretPosition(editor.getCaretPosition() - 16);
		} else {
			editor.insert("\\begin{flushright}" + "\r\n", editor
					.getSelectionStart());
			editor.insert("\r\n" + "\\end{flushright}" + "\r\n", editor
					.getSelectionEnd());
			editor.requestFocus();
			editor.setCaretPosition(editor.getSelectionEnd());
		}
	}

}
