package de.beagtex.listener.insert;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import de.beagtex.gui.Editor;

/**
 * Listener for inserting the LaTex-command for a caption beneath the graphics
 * 
 * @author Benjamin Haag
 */
public class CaptionListener implements ActionListener {

	private Editor editor;

	/**
	 * Constructor
	 * 
	 * @param editor:
	 *            the calling editor
	 */
	public CaptionListener(Editor editor) {
		this.editor = editor;
	}

	public void actionPerformed(ActionEvent arg0) {

		editor.insert("\\caption{}", editor.getCaretPosition());
		editor.requestFocus();
		editor.setCaretPosition(editor.getCaretPosition() - 1);
	}

}
