package de.beagtex.listener.insert;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import de.beagtex.gui.Editor;

/**
 * Listener for inserting margin notes
 * 
 * @author Benjamin Haag
 * 
 */
public class MarginNoteListener implements ActionListener {

	Editor editor;

	/**
	 * Constructor
	 * 
	 * @param pEditor :
	 *            the calling editor
	 */
	public MarginNoteListener(Editor pEditor) {
	
		this.editor = pEditor;
	}

	public void actionPerformed(ActionEvent pE) {
		
		if (editor.getSelectedText() == null) {
			editor.insert("\\marginpar{}", editor.getCaretPosition());
			editor.requestFocus();
			editor.setCaretPosition(editor.getCaretPosition() - 1);
		} else {
			editor.insert("\\marginpar{", editor.getSelectionStart());
			editor.insert("}", editor.getSelectionEnd());
			editor.requestFocus();
			editor.setCaretPosition(editor.getSelectionEnd());
		}
	}

}
