/*
 * Decompiled with CFR 0.152.
 */
package com.sonoransoft.codequill;

import com.sonoransoft.codequill.Options;
import com.sonoransoft.codequill.PrintService;
import java.awt.Font;
import java.awt.Frame;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.Enumeration;

class CqPrint
extends PrintService {
    private boolean printLineNumbers;

    public CqPrint() {
    }

    public CqPrint(Options options) {
        this.setTopMargin(options.getPrintTopMargin());
        this.setBottomMargin(options.getPrintBottomMargin());
        this.setLeftMargin(options.getPrintLeftMargin());
        this.setRightMargin(options.getPrintRightMargin());
        this.enablePageNumbers(options.isPrintPageNumbers());
        this.printLineNumbers = options.isPrintLineNumbers();
        this.enableJobName(options.isPrintFileName());
        if (options.isPrintFontBold()) {
            this.setFont(new Font(options.getFontName(), 1, options.getPrintFontPoint()));
        } else {
            this.setFont(new Font(options.getFontName(), 0, options.getPrintFontPoint()));
        }
    }

    private int print(String string, int n, int n2) {
        if (this.printLineNumbers) {
            string = this.appendLineNumber(string, n2);
        }
        if (string.length() > 0) {
            int n3 = 0;
            int n4 = this.getPrintableAreaWidth();
            if (this.getStringWidth(string) < n4) {
                this.drawLine(string, n);
                return string.length();
            }
            n3 = 1;
            while (this.getStringWidth(string.substring(0, n3)) < n4) {
                ++n3;
            }
            this.drawLine(string.substring(0, --n3), n);
            if (this.printLineNumbers) {
                n3 -= 6;
            }
            return n3;
        }
        return 0;
    }

    private int print(String string, int n) {
        int n2 = 0;
        if (this.printLineNumbers) {
            n2 = this.getStringWidth("0000  ");
        }
        if (string.length() > 0) {
            int n3 = 0;
            int n4 = this.getPrintableAreaWidth();
            if (this.getStringWidth(string) < n4 - n2) {
                this.drawLine(string, n, n2);
                return string.length();
            }
            n3 = 1;
            while (this.getStringWidth(string.substring(0, n3)) < n4 - n2) {
                ++n3;
            }
            this.drawLine(string.substring(0, --n3), n, n2);
            if (this.printLineNumbers) {
                n3 -= 6;
            }
            return n3;
        }
        return 0;
    }

    public void print(Frame frame, String string, int n, String string2) {
        int n2 = 0;
        int n3 = n;
        int n4 = 0;
        try {
            StringReader stringReader = new StringReader(string);
            BufferedReader bufferedReader = new BufferedReader(stringReader);
            String string3 = bufferedReader.readLine();
            if (string3 != null) {
                if (!this.startPrintJob(frame, string2)) {
                    return;
                }
                int n5 = this.getNumberOfLines();
                while (true) {
                    n4 = this.print(string3, n2, n3++);
                    while (n4 < string3.length()) {
                        if (++n2 >= this.getNumberOfLines()) {
                            this.formFeed();
                            n2 = 0;
                        }
                        string3 = string3.substring(n4);
                        n4 = this.print(string3, n2);
                    }
                    string3 = bufferedReader.readLine();
                    if (string3 == null) {
                        bufferedReader.close();
                        this.endPrintJob();
                        return;
                    }
                    if (++n2 < this.getNumberOfLines()) continue;
                    this.formFeed();
                    n2 = 0;
                }
            }
            bufferedReader.close();
        }
        catch (IOException iOException) {
            return;
        }
    }

    public void print(Frame frame, Enumeration enumeration, String string) {
        int n = 0;
        int n2 = 0;
        if (enumeration.hasMoreElements()) {
            if (!this.startPrintJob(frame, string)) {
                return;
            }
            while (true) {
                this.print((String)enumeration.nextElement(), n, n2++);
                if (!enumeration.hasMoreElements()) {
                    this.endPrintJob();
                    break;
                }
                this.formFeed();
            }
        }
    }

    private String appendLineNumber(String string, int n) {
        StringBuffer stringBuffer = new StringBuffer();
        if (++n < 10) {
            stringBuffer.append("000");
        } else if (n < 100) {
            stringBuffer.append("00");
        } else if (n < 1000) {
            stringBuffer.append("0");
        }
        stringBuffer.append(Integer.toString(n));
        stringBuffer.append("  ");
        stringBuffer.append(string);
        return stringBuffer.toString();
    }
}

