/*
 * Decompiled with CFR 0.152.
 */
package game.rally;

import game.rally.AnimationFrame;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;

public abstract class AnimationComponent
extends Container
implements Runnable {
    private boolean mTrucking = true;
    private long[] mPreviousTimes = new long[128];
    private int mPreviousIndex;
    private boolean mPreviousFilled;
    private double mFrameRate;
    private Image mImage;
    private transient AnimationFrame mRateListener;

    public AnimationComponent() {
        this.mPreviousTimes[0] = System.currentTimeMillis();
        this.mPreviousIndex = 1;
        this.mPreviousFilled = false;
    }

    public void terminate() {
        this.mTrucking = false;
    }

    public abstract void timeStep();

    @Override
    public void run() {
        while (this.mTrucking) {
            this.render();
            this.timeStep();
            this.calculateFrameRate();
        }
    }

    protected void render() {
        Graphics graphics = this.getGraphics();
        if (graphics != null) {
            Dimension dimension = this.getSize();
            if (this.checkImage(dimension)) {
                Graphics graphics2 = this.mImage.getGraphics();
                graphics2.setColor(this.getBackground());
                graphics2.fillRect(0, 0, dimension.width, dimension.height);
                graphics2.setColor(this.getForeground());
                this.paint(graphics2);
                graphics.drawImage(this.mImage, 0, 0, null);
                graphics2.dispose();
            }
            graphics.dispose();
        }
    }

    protected boolean checkImage(Dimension dimension) {
        if (dimension.width == 0 || dimension.height == 0) {
            return false;
        }
        if (this.mImage == null || this.mImage.getWidth(null) != dimension.width || this.mImage.getHeight(null) != dimension.height) {
            this.mImage = this.createImage(dimension.width, dimension.height);
        }
        return true;
    }

    protected void calculateFrameRate() {
        long l = System.currentTimeMillis();
        int n = this.mPreviousTimes.length;
        double d = this.mPreviousFilled ? (double)n / (double)(l - this.mPreviousTimes[this.mPreviousIndex]) * 1000.0 : 1000.0 / (double)(l - this.mPreviousTimes[n - 1]);
        this.firePropertyChange("frameRate", this.mFrameRate, d);
        this.mFrameRate = d;
        this.mPreviousTimes[this.mPreviousIndex] = l;
        ++this.mPreviousIndex;
        if (this.mPreviousIndex >= n) {
            this.mPreviousIndex = 0;
            this.mPreviousFilled = true;
        }
    }

    public double getFrameRate() {
        return this.mFrameRate;
    }

    public void setRateListener(AnimationFrame animationFrame) {
        this.mRateListener = animationFrame;
    }

    @Override
    public void firePropertyChange(String string, double d, double d2) {
        this.mRateListener.rateChanged(d2);
    }
}

