/*
 * Decompiled with CFR 0.152.
 */
package commands;

import commands.CommandType;
import commands.ICommandGateway;
import gui.Application;
import javax.swing.text.JTextComponent;
import neutrino.dialogs.ComplexOperationChooser;
import neutrino.text.IPlainTextComponent;
import neutrino.text.ITextComponent;

class CommandCommandGateway
implements ICommandGateway {
    private Application application = null;

    public CommandCommandGateway(Application application) {
        this.application = application;
    }

    @Override
    public void performCommand(CommandType commandType) {
        switch (commandType) {
            case MAKE_UPPER_CASE: {
                this.makeUpperCase();
                break;
            }
            case MAKE_LOWER_CASE: {
                this.makeLowerCase();
                break;
            }
            case MAKE_TITLE_CASE: {
                this.makeTitleCase();
                break;
            }
            case CAPITALIZE_WORDS: {
                this.capitalize();
                break;
            }
            case INVERT_CASE_LETTERS: {
                this.invertCase();
                break;
            }
            case INVERT_CAPITALIZATION: {
                this.invertCapitalization();
                break;
            }
            case TABIFY_SELECTED_LINES: {
                this.tabifySelectedLines();
                break;
            }
            case UNTABIFY_SELECTED_LINES: {
                this.untabifySelectedLines();
                break;
            }
            case TRIM_SELECTED_LINES: {
                this.trimSelectedLines();
                break;
            }
            case JOIN_SELECTED_LINES: {
                this.joinSelectedLines();
                break;
            }
            case SPLIT_INTO_LINES: {
                this.splitIntoLines();
                break;
            }
            case DUPLICATE_SELECTED_LINES: {
                this.duplicateSelectedLines();
                break;
            }
            case REMOVE_EMPTY_LIENS: {
                this.removeEmptyLines();
                break;
            }
            case SORT_LINES_ASCENDANT: {
                this.sortLinesAscendant();
                break;
            }
            case SORT_LINES_DESCENDANT: {
                this.sortLinesDescendant();
                break;
            }
            case DELETE_HORIZONTAL_WHITE_SPACE: {
                this.deleteHorizontalWhiteSpace();
                break;
            }
            case REMOVE_TRAILING_WHITESPACES: {
                this.removeTrailingWhitespaces();
                break;
            }
            case INCREASE_LINE_INDENT: {
                this.shiftInRight();
                break;
            }
            case DECREASE_LINE_INDENT: {
                this.shiftInLeft();
                break;
            }
            case MOVE_LINES_UP: {
                this.moveLinesUp();
                break;
            }
            case MOVE_LINES_DOWN: {
                this.moveLinesDown();
                break;
            }
            case ALIGN_TEXT_LEFT: {
                this.alignTextLeft();
                break;
            }
            case ALIGN_TEXT_RIGHT: {
                this.alignTextRight();
                break;
            }
            case CENTER_TEXT: {
                this.centerText();
                break;
            }
            case JUSTIFY_TEXT: {
                this.justifyText();
                break;
            }
            case MAKE_LATIN_PARAGRAPH: {
                this.makeLatinParagraph();
                break;
            }
            case MAKE_CYRILLIC_PARAGRAPH: {
                this.makeCyrillicParagraph();
                break;
            }
            case PERFORM_COMPLEX_OPERATION: {
                this.performComplexOperation();
            }
        }
    }

    @Override
    public boolean containsCommand(CommandType commandType) {
        switch (commandType) {
            case MAKE_UPPER_CASE: 
            case MAKE_LOWER_CASE: 
            case MAKE_TITLE_CASE: 
            case CAPITALIZE_WORDS: 
            case INVERT_CASE_LETTERS: 
            case INVERT_CAPITALIZATION: 
            case TABIFY_SELECTED_LINES: 
            case UNTABIFY_SELECTED_LINES: 
            case TRIM_SELECTED_LINES: 
            case JOIN_SELECTED_LINES: 
            case SPLIT_INTO_LINES: 
            case DUPLICATE_SELECTED_LINES: 
            case REMOVE_EMPTY_LIENS: 
            case SORT_LINES_ASCENDANT: 
            case SORT_LINES_DESCENDANT: 
            case DELETE_HORIZONTAL_WHITE_SPACE: 
            case REMOVE_TRAILING_WHITESPACES: 
            case INCREASE_LINE_INDENT: 
            case DECREASE_LINE_INDENT: 
            case MOVE_LINES_UP: 
            case MOVE_LINES_DOWN: 
            case ALIGN_TEXT_LEFT: 
            case ALIGN_TEXT_RIGHT: 
            case CENTER_TEXT: 
            case JUSTIFY_TEXT: 
            case MAKE_LATIN_PARAGRAPH: 
            case MAKE_CYRILLIC_PARAGRAPH: 
            case PERFORM_COMPLEX_OPERATION: {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean canPerformCommand(CommandType commandType) {
        switch (commandType) {
            case MAKE_UPPER_CASE: {
                return this.canMakeUpperCase();
            }
            case MAKE_LOWER_CASE: {
                return this.canMakeLowerCase();
            }
            case MAKE_TITLE_CASE: {
                return this.canMakeTitleCase();
            }
            case CAPITALIZE_WORDS: {
                return this.canCapitalize();
            }
            case INVERT_CASE_LETTERS: {
                return this.canInvertCase();
            }
            case INVERT_CAPITALIZATION: {
                return this.canInvertCapitalization();
            }
            case TABIFY_SELECTED_LINES: {
                return this.canTabifySelectedLines();
            }
            case UNTABIFY_SELECTED_LINES: {
                return this.canUntabifySelectedLines();
            }
            case TRIM_SELECTED_LINES: {
                return this.canTrimSelectedLines();
            }
            case JOIN_SELECTED_LINES: {
                return this.canJoinSelectedLines();
            }
            case SPLIT_INTO_LINES: {
                return this.canSplitIntoLines();
            }
            case DUPLICATE_SELECTED_LINES: {
                return this.canDuplicateSelectedLines();
            }
            case REMOVE_EMPTY_LIENS: {
                return this.canRemoveEmptyLines();
            }
            case SORT_LINES_ASCENDANT: {
                return this.canSortLinesAscendant();
            }
            case SORT_LINES_DESCENDANT: {
                return this.canSortLinesDescendant();
            }
            case DELETE_HORIZONTAL_WHITE_SPACE: {
                return this.canDeleteHorizontalWhiteSpace();
            }
            case REMOVE_TRAILING_WHITESPACES: {
                return this.canRemoveTrailingWhitespaces();
            }
            case INCREASE_LINE_INDENT: {
                return this.canIncreaseLineIndent();
            }
            case DECREASE_LINE_INDENT: {
                return this.canDecreaseLineIndent();
            }
            case MOVE_LINES_UP: {
                return this.canMoveLinesUp();
            }
            case MOVE_LINES_DOWN: {
                return this.canMoveLinesDown();
            }
            case ALIGN_TEXT_LEFT: {
                return this.canAlignTextLeft();
            }
            case ALIGN_TEXT_RIGHT: {
                return this.canAlignTextRight();
            }
            case CENTER_TEXT: {
                return this.canCenterText();
            }
            case JUSTIFY_TEXT: {
                return this.canJustifyText();
            }
            case MAKE_LATIN_PARAGRAPH: {
                return this.canMakeLatinParagraph();
            }
            case MAKE_CYRILLIC_PARAGRAPH: {
                return this.canMakeCyrillicParagraph();
            }
            case PERFORM_COMPLEX_OPERATION: {
                return this.canPerformComplexOperation();
            }
        }
        return true;
    }

    private boolean canMakeUpperCase() {
        JTextComponent jTextComponent = this.application.getTextEditor().getTextComponent();
        if (jTextComponent instanceof IPlainTextComponent) {
            return ((IPlainTextComponent)((Object)jTextComponent)).canMakeUpperCase();
        }
        return false;
    }

    private void makeUpperCase() {
        JTextComponent jTextComponent = this.application.getTextEditor().getTextComponent();
        if (jTextComponent instanceof IPlainTextComponent) {
            ((IPlainTextComponent)((Object)jTextComponent)).makeUpperCase();
        }
    }

    private boolean canMakeLowerCase() {
        JTextComponent jTextComponent = this.application.getTextEditor().getTextComponent();
        if (jTextComponent instanceof IPlainTextComponent) {
            return ((IPlainTextComponent)((Object)jTextComponent)).canMakeLowerCase();
        }
        return false;
    }

    private void makeLowerCase() {
        JTextComponent jTextComponent = this.application.getTextEditor().getTextComponent();
        if (jTextComponent instanceof IPlainTextComponent) {
            ((IPlainTextComponent)((Object)jTextComponent)).makeLowerCase();
        }
    }

    private boolean canMakeTitleCase() {
        JTextComponent jTextComponent = this.application.getTextEditor().getTextComponent();
        if (jTextComponent instanceof IPlainTextComponent) {
            return ((IPlainTextComponent)((Object)jTextComponent)).canMakeTitleCase();
        }
        return false;
    }

    private void makeTitleCase() {
        JTextComponent jTextComponent = this.application.getTextEditor().getTextComponent();
        if (jTextComponent instanceof IPlainTextComponent) {
            ((IPlainTextComponent)((Object)jTextComponent)).makeTitleCase();
        }
    }

    private boolean canCapitalize() {
        JTextComponent jTextComponent = this.application.getTextEditor().getTextComponent();
        if (jTextComponent instanceof IPlainTextComponent) {
            return ((IPlainTextComponent)((Object)jTextComponent)).canCapitalize();
        }
        return false;
    }

    private void capitalize() {
        JTextComponent jTextComponent = this.application.getTextEditor().getTextComponent();
        if (jTextComponent instanceof IPlainTextComponent) {
            ((IPlainTextComponent)((Object)jTextComponent)).capitalize();
        }
    }

    private boolean canInvertCase() {
        JTextComponent jTextComponent = this.application.getTextEditor().getTextComponent();
        if (jTextComponent instanceof IPlainTextComponent) {
            return ((IPlainTextComponent)((Object)jTextComponent)).canInvertCase();
        }
        return false;
    }

    private void invertCase() {
        JTextComponent jTextComponent = this.application.getTextEditor().getTextComponent();
        if (jTextComponent instanceof IPlainTextComponent) {
            ((IPlainTextComponent)((Object)jTextComponent)).invertCase();
        }
    }

    private boolean canInvertCapitalization() {
        JTextComponent jTextComponent = this.application.getTextEditor().getTextComponent();
        if (jTextComponent instanceof IPlainTextComponent) {
            return ((IPlainTextComponent)((Object)jTextComponent)).canInvertCapitalization();
        }
        return false;
    }

    private void invertCapitalization() {
        JTextComponent jTextComponent = this.application.getTextEditor().getTextComponent();
        if (jTextComponent instanceof IPlainTextComponent) {
            ((IPlainTextComponent)((Object)jTextComponent)).invertCapitalization();
        }
    }

    private boolean canTabifySelectedLines() {
        JTextComponent jTextComponent = this.application.getTextEditor().getTextComponent();
        if (jTextComponent instanceof ITextComponent) {
            return ((IPlainTextComponent)((Object)jTextComponent)).canTabifySelectedLines();
        }
        return false;
    }

    private void tabifySelectedLines() {
        JTextComponent jTextComponent = this.application.getTextEditor().getTextComponent();
        if (jTextComponent instanceof IPlainTextComponent) {
            ((IPlainTextComponent)((Object)jTextComponent)).tabifySelectedLines();
        }
    }

    private boolean canUntabifySelectedLines() {
        JTextComponent jTextComponent = this.application.getTextEditor().getTextComponent();
        if (jTextComponent instanceof ITextComponent) {
            return ((IPlainTextComponent)((Object)jTextComponent)).canUntabifySelectedLines();
        }
        return false;
    }

    private void untabifySelectedLines() {
        JTextComponent jTextComponent = this.application.getTextEditor().getTextComponent();
        if (jTextComponent instanceof IPlainTextComponent) {
            ((IPlainTextComponent)((Object)jTextComponent)).untabifySelectedLines();
        }
    }

    private boolean canTrimSelectedLines() {
        JTextComponent jTextComponent = this.application.getTextEditor().getTextComponent();
        if (jTextComponent instanceof ITextComponent) {
            return ((IPlainTextComponent)((Object)jTextComponent)).canTrimSelectedLines();
        }
        return false;
    }

    private void trimSelectedLines() {
        JTextComponent jTextComponent = this.application.getTextEditor().getTextComponent();
        if (jTextComponent instanceof IPlainTextComponent) {
            ((IPlainTextComponent)((Object)jTextComponent)).trimSelectedLines();
        }
    }

    private boolean canJoinSelectedLines() {
        JTextComponent jTextComponent = this.application.getTextEditor().getTextComponent();
        if (jTextComponent instanceof ITextComponent) {
            return ((IPlainTextComponent)((Object)jTextComponent)).canJoinSelectedLines();
        }
        return false;
    }

    private void joinSelectedLines() {
        JTextComponent jTextComponent = this.application.getTextEditor().getTextComponent();
        if (jTextComponent instanceof IPlainTextComponent) {
            ((IPlainTextComponent)((Object)jTextComponent)).joinSelectedLines();
        }
    }

    private boolean canSplitIntoLines() {
        JTextComponent jTextComponent = this.application.getTextEditor().getTextComponent();
        if (jTextComponent instanceof IPlainTextComponent) {
            return ((IPlainTextComponent)((Object)jTextComponent)).canSplitIntoLines();
        }
        return false;
    }

    private void splitIntoLines() {
        JTextComponent jTextComponent = this.application.getTextEditor().getTextComponent();
        if (jTextComponent instanceof IPlainTextComponent) {
            ((IPlainTextComponent)((Object)jTextComponent)).splitIntoLines();
        }
    }

    private boolean canDuplicateSelectedLines() {
        JTextComponent jTextComponent = this.application.getTextEditor().getTextComponent();
        if (jTextComponent instanceof IPlainTextComponent) {
            return ((IPlainTextComponent)((Object)jTextComponent)).canDuplicateSelectedLines();
        }
        return false;
    }

    private void duplicateSelectedLines() {
        JTextComponent jTextComponent = this.application.getTextEditor().getTextComponent();
        if (jTextComponent instanceof IPlainTextComponent) {
            ((IPlainTextComponent)((Object)jTextComponent)).duplicateSelectedLines();
        }
    }

    private boolean canRemoveEmptyLines() {
        JTextComponent jTextComponent = this.application.getTextEditor().getTextComponent();
        if (jTextComponent instanceof IPlainTextComponent) {
            return ((IPlainTextComponent)((Object)jTextComponent)).canRemoveEmptyLines();
        }
        return false;
    }

    private void removeEmptyLines() {
        JTextComponent jTextComponent = this.application.getTextEditor().getTextComponent();
        if (jTextComponent instanceof IPlainTextComponent) {
            ((IPlainTextComponent)((Object)jTextComponent)).removeEmptyLines();
        }
    }

    private boolean canSortLinesAscendant() {
        JTextComponent jTextComponent = this.application.getTextEditor().getTextComponent();
        if (jTextComponent instanceof IPlainTextComponent) {
            return ((IPlainTextComponent)((Object)jTextComponent)).canSortLinesAscendant();
        }
        return false;
    }

    private void sortLinesAscendant() {
        JTextComponent jTextComponent = this.application.getTextEditor().getTextComponent();
        if (jTextComponent instanceof IPlainTextComponent) {
            ((IPlainTextComponent)((Object)jTextComponent)).sortLinesAscendant();
        }
    }

    private boolean canSortLinesDescendant() {
        JTextComponent jTextComponent = this.application.getTextEditor().getTextComponent();
        if (jTextComponent instanceof IPlainTextComponent) {
            return ((IPlainTextComponent)((Object)jTextComponent)).canSortLinesDescendant();
        }
        return false;
    }

    private void sortLinesDescendant() {
        JTextComponent jTextComponent = this.application.getTextEditor().getTextComponent();
        if (jTextComponent instanceof IPlainTextComponent) {
            ((IPlainTextComponent)((Object)jTextComponent)).sortLinesDescendant();
        }
    }

    private boolean canDeleteHorizontalWhiteSpace() {
        JTextComponent jTextComponent = this.application.getTextEditor().getTextComponent();
        if (jTextComponent instanceof ITextComponent) {
            return ((IPlainTextComponent)((Object)jTextComponent)).canDeleteHorizontalWhiteSpace();
        }
        return false;
    }

    private void deleteHorizontalWhiteSpace() {
        JTextComponent jTextComponent = this.application.getTextEditor().getTextComponent();
        if (jTextComponent instanceof IPlainTextComponent) {
            ((IPlainTextComponent)((Object)jTextComponent)).deleteHorizontalWhiteSpace();
        }
    }

    private boolean canRemoveTrailingWhitespaces() {
        JTextComponent jTextComponent = this.application.getTextEditor().getTextComponent();
        if (jTextComponent instanceof ITextComponent) {
            return ((IPlainTextComponent)((Object)jTextComponent)).canRemoveTrailingWhitespaces();
        }
        return false;
    }

    private void removeTrailingWhitespaces() {
        JTextComponent jTextComponent = this.application.getTextEditor().getTextComponent();
        if (jTextComponent instanceof IPlainTextComponent) {
            ((IPlainTextComponent)((Object)jTextComponent)).removeTrailingWhitespaces();
        }
    }

    private boolean canDecreaseLineIndent() {
        JTextComponent jTextComponent = this.application.getTextEditor().getTextComponent();
        if (jTextComponent instanceof ITextComponent) {
            return ((IPlainTextComponent)((Object)jTextComponent)).canShiftInLeft();
        }
        return false;
    }

    private void shiftInLeft() {
        JTextComponent jTextComponent = this.application.getTextEditor().getTextComponent();
        if (jTextComponent instanceof IPlainTextComponent) {
            ((IPlainTextComponent)((Object)jTextComponent)).shiftInLeft();
        }
    }

    private boolean canIncreaseLineIndent() {
        JTextComponent jTextComponent = this.application.getTextEditor().getTextComponent();
        if (jTextComponent instanceof ITextComponent) {
            return ((IPlainTextComponent)((Object)jTextComponent)).canShiftInRight();
        }
        return false;
    }

    private void shiftInRight() {
        JTextComponent jTextComponent = this.application.getTextEditor().getTextComponent();
        if (jTextComponent instanceof IPlainTextComponent) {
            ((IPlainTextComponent)((Object)jTextComponent)).shiftInRight();
        }
    }

    private boolean canMoveLinesUp() {
        JTextComponent jTextComponent = this.application.getTextEditor().getTextComponent();
        if (jTextComponent instanceof IPlainTextComponent) {
            return ((IPlainTextComponent)((Object)jTextComponent)).canMoveLinesUp();
        }
        return false;
    }

    private void moveLinesUp() {
        JTextComponent jTextComponent = this.application.getTextEditor().getTextComponent();
        if (jTextComponent instanceof IPlainTextComponent) {
            ((IPlainTextComponent)((Object)jTextComponent)).moveLinesUp();
        }
    }

    private boolean canMoveLinesDown() {
        JTextComponent jTextComponent = this.application.getTextEditor().getTextComponent();
        if (jTextComponent instanceof IPlainTextComponent) {
            return ((IPlainTextComponent)((Object)jTextComponent)).canMoveLinesDown();
        }
        return false;
    }

    private void moveLinesDown() {
        JTextComponent jTextComponent = this.application.getTextEditor().getTextComponent();
        if (jTextComponent instanceof IPlainTextComponent) {
            ((IPlainTextComponent)((Object)jTextComponent)).moveLinesDown();
        }
    }

    private boolean canAlignTextLeft() {
        JTextComponent jTextComponent = this.application.getTextEditor().getTextComponent();
        if (jTextComponent instanceof IPlainTextComponent) {
            return ((IPlainTextComponent)((Object)jTextComponent)).canAlignTextLeft();
        }
        return false;
    }

    private void alignTextLeft() {
        JTextComponent jTextComponent = this.application.getTextEditor().getTextComponent();
        if (jTextComponent instanceof IPlainTextComponent) {
            ((IPlainTextComponent)((Object)jTextComponent)).alignTextLeft();
        }
    }

    private boolean canAlignTextRight() {
        JTextComponent jTextComponent = this.application.getTextEditor().getTextComponent();
        if (jTextComponent instanceof IPlainTextComponent) {
            return ((IPlainTextComponent)((Object)jTextComponent)).canAlignTextRight();
        }
        return false;
    }

    private void alignTextRight() {
        JTextComponent jTextComponent = this.application.getTextEditor().getTextComponent();
        if (jTextComponent instanceof IPlainTextComponent) {
            ((IPlainTextComponent)((Object)jTextComponent)).alignTextRight();
        }
    }

    private boolean canCenterText() {
        JTextComponent jTextComponent = this.application.getTextEditor().getTextComponent();
        if (jTextComponent instanceof IPlainTextComponent) {
            return ((IPlainTextComponent)((Object)jTextComponent)).canCenterText();
        }
        return false;
    }

    private void centerText() {
        JTextComponent jTextComponent = this.application.getTextEditor().getTextComponent();
        if (jTextComponent instanceof IPlainTextComponent) {
            ((IPlainTextComponent)((Object)jTextComponent)).centerText();
        }
    }

    private boolean canJustifyText() {
        JTextComponent jTextComponent = this.application.getTextEditor().getTextComponent();
        if (jTextComponent instanceof IPlainTextComponent) {
            return ((IPlainTextComponent)((Object)jTextComponent)).canJustifyText();
        }
        return false;
    }

    private void justifyText() {
        JTextComponent jTextComponent = this.application.getTextEditor().getTextComponent();
        if (jTextComponent instanceof IPlainTextComponent) {
            ((IPlainTextComponent)((Object)jTextComponent)).justifyText();
        }
    }

    private boolean canMakeLatinParagraph() {
        JTextComponent jTextComponent = this.application.getTextEditor().getTextComponent();
        if (jTextComponent instanceof IPlainTextComponent) {
            return ((IPlainTextComponent)((Object)jTextComponent)).canMakeLatinParagraph();
        }
        return false;
    }

    private void makeLatinParagraph() {
        JTextComponent jTextComponent = this.application.getTextEditor().getTextComponent();
        if (jTextComponent instanceof IPlainTextComponent) {
            ((IPlainTextComponent)((Object)jTextComponent)).makeLatinParagraph();
        }
    }

    private boolean canMakeCyrillicParagraph() {
        JTextComponent jTextComponent = this.application.getTextEditor().getTextComponent();
        if (jTextComponent instanceof IPlainTextComponent) {
            return ((IPlainTextComponent)((Object)jTextComponent)).canMakeCyrillicParagraph();
        }
        return false;
    }

    private void makeCyrillicParagraph() {
        JTextComponent jTextComponent = this.application.getTextEditor().getTextComponent();
        if (jTextComponent instanceof IPlainTextComponent) {
            ((IPlainTextComponent)((Object)jTextComponent)).makeCyrillicParagraph();
        }
    }

    private boolean canPerformComplexOperation() {
        JTextComponent jTextComponent = this.application.getTextEditor().getTextComponent();
        if (jTextComponent instanceof ITextComponent) {
            return !((ITextComponent)((Object)jTextComponent)).isTextEmpty();
        }
        return false;
    }

    private void performComplexOperation() {
        ComplexOperationChooser.showComplexOperationDialog(this.application, this.application.getTextEditor().getTextComponent());
    }
}

