/*
 * Decompiled with CFR 0.152.
 */
package commands;

import commands.CommandCommandGateway;
import commands.CommandType;
import commands.EditingCommandGateway;
import commands.FileCommandGateway;
import commands.HelpCommandGateway;
import commands.ICommandGateway;
import commands.SettingsCommandGateway;
import gui.Application;
import java.util.ArrayList;

public class CommandGateway {
    private ArrayList<ICommandGateway> commandGateways = new ArrayList();

    public CommandGateway(Application application) {
        this.commandGateways.add(new FileCommandGateway(application));
        this.commandGateways.add(new EditingCommandGateway(application));
        this.commandGateways.add(new CommandCommandGateway(application));
        this.commandGateways.add(new SettingsCommandGateway(application));
        this.commandGateways.add(new HelpCommandGateway(application));
    }

    public void performCommand(CommandType commandType) {
        for (ICommandGateway iCommandGateway : this.commandGateways) {
            iCommandGateway.performCommand(commandType);
        }
    }

    public boolean canPerformCommand(CommandType commandType) {
        for (ICommandGateway iCommandGateway : this.commandGateways) {
            if (!iCommandGateway.containsCommand(commandType)) continue;
            return iCommandGateway.canPerformCommand(commandType);
        }
        return true;
    }
}

