/*
 * Decompiled with CFR 0.152.
 */
package commands;

import commands.CommandType;
import commands.ICommandGateway;
import gui.Application;
import java.awt.print.PrinterException;
import java.io.File;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.text.JTextComponent;
import neutrino.dialogs.DocumentRestorer;
import neutrino.text.ITextComponent;
import neutrino.text.components.plain.PlainTextArea;

class FileCommandGateway
implements ICommandGateway {
    private Application application = null;

    public FileCommandGateway(Application application) {
        this.application = application;
    }

    @Override
    public void performCommand(CommandType commandType) {
        switch (commandType) {
            case NEW: {
                this.newText();
                break;
            }
            case OPEN: {
                this.open();
                break;
            }
            case RESTORE: {
                this.restore();
                break;
            }
            case SAVE: {
                this.save();
                break;
            }
            case SAVE_AS: {
                this.saveAs();
                break;
            }
            case RELOAD: {
                this.reload();
                break;
            }
            case PRINT: {
                this.print();
                break;
            }
            case COPY_FILE: {
                this.copy();
                break;
            }
            case MOVE: {
                this.move();
                break;
            }
            case REMOVE: {
                this.remove();
                break;
            }
            case RENAME: {
                this.rename();
                break;
            }
            case EXECUTE: {
                this.toggleExecute();
                break;
            }
            case READ_ONLY: {
                this.toggleReadOnly();
                break;
            }
            case WRITE_ONLY: {
                this.toggleWriteOnly();
                break;
            }
            case HIDDEN: {
                this.toggleHidden();
                break;
            }
            case EXIT: {
                this.exit();
            }
        }
    }

    @Override
    public boolean containsCommand(CommandType commandType) {
        switch (commandType) {
            case NEW: 
            case OPEN: 
            case RESTORE: 
            case SAVE: 
            case SAVE_AS: 
            case RELOAD: 
            case PRINT: 
            case COPY_FILE: 
            case MOVE: 
            case REMOVE: 
            case RENAME: 
            case EXECUTE: 
            case READ_ONLY: 
            case WRITE_ONLY: 
            case HIDDEN: 
            case EXIT: {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean canPerformCommand(CommandType commandType) {
        switch (commandType) {
            case NEW: {
                return this.canNewText();
            }
            case RESTORE: {
                return this.canRestore();
            }
            case SAVE: {
                return this.canSave();
            }
            case SAVE_AS: {
                return this.canSaveAs();
            }
            case RELOAD: {
                return this.canReload();
            }
            case PRINT: {
                return this.canPrint();
            }
            case COPY_FILE: {
                return this.canCopy();
            }
            case MOVE: {
                return this.canMove();
            }
            case REMOVE: {
                return this.canRemove();
            }
            case RENAME: {
                return this.canRename();
            }
            case EXECUTE: {
                return this.canToggleExecute();
            }
            case READ_ONLY: {
                return this.canToggleReadOnly();
            }
            case WRITE_ONLY: {
                return this.canToggleWriteOnly();
            }
            case HIDDEN: {
                return this.canToggleHidden();
            }
        }
        return true;
    }

    private boolean canNewText() {
        return this.application.getTextEditor().canClear();
    }

    private void newText() {
        if (!this.application.getTextEditor().isTextSaved()) {
            return;
        }
        this.application.getTextEditor().clear();
    }

    private void open() {
        if (!this.application.getTextEditor().isTextSaved()) {
            return;
        }
        this.application.getTextEditor().open();
    }

    private boolean canRestore() {
        return DocumentRestorer.hasBackup(this.application.getTextEditor());
    }

    private void restore() {
        File file = DocumentRestorer.showRestoreDialog(this.application, this.application.getTextEditor());
        this.application.getTextEditor().restore(file);
    }

    private boolean canSave() {
        return this.application.getTextEditor().canSave();
    }

    private void save() {
        this.application.getTextEditor().save();
    }

    private boolean canSaveAs() {
        return this.application.getTextEditor().canSaveAs();
    }

    private void saveAs() {
        this.application.getTextEditor().saveAs();
    }

    private boolean canReload() {
        return this.application.getTextEditor().canReload();
    }

    private void reload() {
        this.application.getTextEditor().reload();
    }

    private boolean canPrint() {
        JTextComponent jTextComponent = this.application.getTextEditor().getTextComponent();
        if (jTextComponent instanceof ITextComponent) {
            return ((ITextComponent)((Object)jTextComponent)).canPrint();
        }
        return true;
    }

    private void print() {
        try {
            PlainTextArea plainTextArea = (PlainTextArea)this.application.getTextEditor().getTextComponent();
            if (plainTextArea.isTextEmpty()) {
                JOptionPane.showMessageDialog(this.application, "Nothing to print.", "Information", 1);
            } else {
                JTextArea jTextArea = new JTextArea();
                jTextArea.setTabSize(plainTextArea.getTabSize());
                jTextArea.setText(plainTextArea.getText());
                jTextArea.setFont(plainTextArea.getFont());
                jTextArea.setLineWrap(true);
                jTextArea.setWrapStyleWord(false);
                jTextArea.print();
                jTextArea = null;
                System.gc();
            }
        }
        catch (PrinterException printerException) {
            printerException.printStackTrace();
        }
    }

    private boolean canCopy() {
        return this.application.getTextEditor().canCopy();
    }

    private void copy() {
        this.application.getTextEditor().copy();
    }

    private boolean canMove() {
        return this.application.getTextEditor().canMove();
    }

    private void move() {
        this.application.getTextEditor().move();
    }

    private boolean canRename() {
        return this.application.getTextEditor().canRename();
    }

    private void rename() {
        this.application.getTextEditor().rename();
    }

    private boolean canRemove() {
        return this.application.getTextEditor().canRemove();
    }

    private void remove() {
        this.application.getTextEditor().remove();
    }

    private boolean canToggleExecute() {
        return this.application.getTextEditor().canToggleExecute();
    }

    private void toggleExecute() {
        this.application.getTextEditor().toggleExecute();
    }

    private boolean canToggleReadOnly() {
        return this.application.getTextEditor().canToggleReadOnly();
    }

    private void toggleReadOnly() {
        this.application.getTextEditor().toggleReadOnly();
    }

    private boolean canToggleWriteOnly() {
        return this.application.getTextEditor().canToggleWriteOnly();
    }

    private void toggleWriteOnly() {
        this.application.getTextEditor().toggleWriteOnly();
    }

    private boolean canToggleHidden() {
        return this.application.getTextEditor().canToggleHidden();
    }

    private void toggleHidden() {
        this.application.getTextEditor().toggleHidden();
    }

    private void exit() {
        if (this.application.isConfirmExit()) {
            JPanel jPanel = new JPanel();
            BoxLayout boxLayout = new BoxLayout(jPanel, 1);
            jPanel.setLayout(boxLayout);
            jPanel.add(new JLabel("Do you want to exit?"));
            jPanel.add(Box.createVerticalStrut(5));
            JCheckBox jCheckBox = new JCheckBox("Always exit without prompt");
            jCheckBox.setSelected(false);
            jPanel.add(jCheckBox);
            int n = JOptionPane.showConfirmDialog(this.application, jPanel, "Confirm exit", 0);
            this.application.setConfirmingExit(!jCheckBox.isSelected());
            if (n == 1) {
                return;
            }
        }
        if (!this.application.getTextEditor().isTextSaved()) {
            return;
        }
        this.application.getPropertiesManager().saveProperties();
        this.application.getTextEditor().getBackupManager().turnOff();
        this.application.setVisible(false);
        this.application.dispose();
        System.exit(0);
    }
}

