/*
 * Decompiled with CFR 0.152.
 */
package commands;

import commands.CommandType;
import commands.ICommandGateway;
import game.rally.Game;
import gui.Application;
import gui.dialog.AboutDialog;
import java.io.File;
import javax.swing.SwingUtilities;
import neutrino.dialogs.LicenseChooser;

public class HelpCommandGateway
implements ICommandGateway {
    private Application application = null;
    private final String LICENSE_FILE_NAME = "license.txt";

    public HelpCommandGateway(Application application) {
        this.application = application;
    }

    @Override
    public void performCommand(CommandType commandType) {
        switch (commandType) {
            case GAME: {
                this.playRally();
                break;
            }
            case LICENSE: {
                this.showLicense();
                break;
            }
            case ABOUT: {
                this.about();
            }
        }
    }

    @Override
    public boolean containsCommand(CommandType commandType) {
        switch (commandType) {
            case GAME: 
            case LICENSE: 
            case ABOUT: {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean canPerformCommand(CommandType commandType) {
        switch (commandType) {
            default: 
        }
        return true;
    }

    private void playRally() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Game.main(null);
            }
        });
    }

    private void showLicense() {
        LicenseChooser.showLicenseDialog(this.application, new File("license.txt"));
    }

    private void about() {
        AboutDialog.showAboutDialog(this.application);
    }
}

