/*
 * Decompiled with CFR 0.152.
 */
package gui;

import com.inet.jortho.SpellChecker;
import commands.CommandType;
import gui.MenuBarBuilder;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import neutrino.text.components.plain.PlainTextArea;

abstract class PopupMenuBuilder
extends MenuBarBuilder {
    private JPopupMenu textComponentPopupMenu = new JPopupMenu();
    protected JMenuItem pmiUndo = new JMenuItem("Undo", this.iconUndo);
    protected JMenuItem pmiRedo = new JMenuItem("Redo", this.iconRedo);
    protected JMenuItem pmiCut = new JMenuItem("Cut", this.iconCut);
    protected JMenuItem pmiCopy = new JMenuItem("Copy", this.iconCopy);
    protected JMenuItem pmiPaste = new JMenuItem("Paste", this.iconPaste);
    protected JMenuItem pmiClear = new JMenuItem("Clear", this.iconClear);
    protected JMenu pmCheckSpelling;
    protected JMenu pmLanguages;
    protected JMenuItem pmiSelectAll = new JMenuItem("Select all", this.iconSelectAll);
    protected JMenuItem pmiDeselect = new JMenuItem("Deselect", this.iconDeselect);

    public PopupMenuBuilder() {
        ((PlainTextArea)this.getTextEditor().getTextComponent()).setPopupMenu(this.textComponentPopupMenu);
        this.textComponentPopupMenu.addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
                PopupMenuBuilder.this.updateTextComponentPopupMenuState();
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
            }

            @Override
            public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
            }
        });
        this.pmCheckSpelling = SpellChecker.createCheckerMenu();
        this.pmCheckSpelling.setIcon(this.iconSpelling);
        this.pmLanguages = SpellChecker.createLanguagesMenu();
        this.pmLanguages.setIcon(this.iconLanguages);
    }

    private void updateTextComponentPopupMenuState() {
        this.pmiUndo.setEnabled(this.getCommandGateway().canPerformCommand(CommandType.UNDO));
        this.pmiRedo.setEnabled(this.getCommandGateway().canPerformCommand(CommandType.REDO));
        this.pmiCut.setEnabled(this.getCommandGateway().canPerformCommand(CommandType.CUT));
        this.pmiCopy.setEnabled(this.getCommandGateway().canPerformCommand(CommandType.COPY));
        this.pmiPaste.setEnabled(this.getCommandGateway().canPerformCommand(CommandType.PASTE));
        this.pmiClear.setEnabled(this.getCommandGateway().canPerformCommand(CommandType.CLEAR));
        this.pmiSelectAll.setEnabled(this.getCommandGateway().canPerformCommand(CommandType.SELECT_ALL));
        this.pmiDeselect.setEnabled(this.getCommandGateway().canPerformCommand(CommandType.DESELECT));
    }

    private void buildPopupMenuForTextComponent() {
        this.textComponentPopupMenu.add(this.pmiUndo);
        this.textComponentPopupMenu.add(this.pmiRedo);
        this.textComponentPopupMenu.addSeparator();
        this.textComponentPopupMenu.add(this.pmiCut);
        this.textComponentPopupMenu.add(this.pmiCopy);
        this.textComponentPopupMenu.add(this.pmiPaste);
        this.textComponentPopupMenu.add(this.pmiClear);
        this.textComponentPopupMenu.addSeparator();
        this.textComponentPopupMenu.add(this.pmCheckSpelling);
        this.textComponentPopupMenu.add(this.pmLanguages);
        this.textComponentPopupMenu.addSeparator();
        this.textComponentPopupMenu.add(this.pmiSelectAll);
        this.textComponentPopupMenu.add(this.pmiDeselect);
    }

    private void buildMnemonics() {
        this.pmiUndo.setMnemonic(85);
        this.pmiRedo.setMnemonic(82);
        this.pmiCut.setMnemonic(67);
        this.pmiCopy.setMnemonic(79);
        this.pmiPaste.setMnemonic(80);
        this.pmiClear.setMnemonic(76);
        this.pmCheckSpelling.setMnemonic(72);
        this.pmLanguages.setMnemonic(78);
        this.pmiSelectAll.setMnemonic(83);
        this.pmiDeselect.setMnemonic(68);
    }

    private void buildAccelerators() {
        this.pmiUndo.setAccelerator(KeyStroke.getKeyStroke(90, 128));
        this.pmiRedo.setAccelerator(KeyStroke.getKeyStroke(89, 128));
        this.pmiCut.setAccelerator(KeyStroke.getKeyStroke(88, 128));
        this.pmiCopy.setAccelerator(KeyStroke.getKeyStroke(67, 128));
        this.pmiPaste.setAccelerator(KeyStroke.getKeyStroke(86, 128));
        this.pmiClear.setAccelerator(KeyStroke.getKeyStroke(127, 0));
        this.pmiSelectAll.setAccelerator(KeyStroke.getKeyStroke(65, 128));
        this.pmiDeselect.setAccelerator(KeyStroke.getKeyStroke(27, 0));
    }

    protected void buildPopupMenu() {
        this.buildPopupMenuForTextComponent();
        this.buildMnemonics();
        this.buildAccelerators();
    }
}

