/*
 * Decompiled with CFR 0.152.
 */
package gui;

import commands.CommandType;
import gui.PopupMenuBuilder;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JToolBar;
import javax.swing.Timer;

abstract class ToolBarBuilder
extends PopupMenuBuilder {
    private JToolBar toolBar = new JToolBar();
    protected JButton bNew = new JButton(this.iconNew);
    protected JButton bOpen = new JButton(this.iconOpen);
    protected JButton bReload = new JButton(this.iconReload);
    protected JButton bSave = new JButton(this.iconSave);
    protected JButton bPrint = new JButton(this.iconPrint);
    protected JButton bUndo = new JButton(this.iconUndo);
    protected JButton bRedo = new JButton(this.iconRedo);
    protected JButton bRevert = new JButton(this.iconRevert);
    protected JButton bCut = new JButton(this.iconCut);
    protected JButton bCopy = new JButton(this.iconCopy);
    protected JButton bPaste = new JButton(this.iconPaste);
    protected JButton bClear = new JButton(this.iconClear);
    protected JButton bGoTo = new JButton(this.iconGoTo);
    protected JButton bFind = new JButton(this.iconFind);
    protected JButton bReplace = new JButton(this.iconReplace);
    protected JButton bCheckSpelling = new JButton(this.iconSpelling);
    protected JButton bMakeUpperCase = new JButton(this.iconUpperCase);
    protected JButton bMakeLowerCase = new JButton(this.iconLowerCase);
    protected JButton bDeleteHorizontalWhiteSpace = new JButton(this.iconDeleteHorizontalWhiteSpace);
    protected JButton bIncreaseLineIndent = new JButton(this.iconShiftRight);
    protected JButton bDecreaseLineIndent = new JButton(this.iconShiftLeft);
    protected JButton bPerformComplexOperation = new JButton(this.iconComplexOperation);
    protected JButton bHelp = new JButton(this.iconHelp);
    protected JButton bExit = new JButton(this.iconExit);
    private Timer toolBarUpdatingTimer = new Timer(100, new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (ToolBarBuilder.this.toolBar.isVisible()) {
                try {
                    ToolBarBuilder.this.updateButtonsState();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    });

    public ToolBarBuilder() {
        this.getContentPane().add((Component)this.toolBar, "North");
    }

    protected void buildToolBar() {
        this.toolBar.add(this.bNew);
        this.toolBar.add(this.bOpen);
        this.toolBar.add(this.bReload);
        this.toolBar.add(this.bSave);
        this.toolBar.add(this.bPrint);
        this.toolBar.addSeparator();
        this.toolBar.add(this.bUndo);
        this.toolBar.add(this.bRedo);
        this.toolBar.add(this.bRevert);
        this.toolBar.addSeparator();
        this.toolBar.add(this.bCut);
        this.toolBar.add(this.bCopy);
        this.toolBar.add(this.bPaste);
        this.toolBar.add(this.bClear);
        this.toolBar.addSeparator();
        this.toolBar.add(this.bGoTo);
        this.toolBar.add(this.bFind);
        this.toolBar.add(this.bReplace);
        this.toolBar.add(this.bCheckSpelling);
        this.toolBar.addSeparator();
        this.toolBar.add(this.bMakeUpperCase);
        this.toolBar.add(this.bMakeLowerCase);
        this.toolBar.add(this.bDeleteHorizontalWhiteSpace);
        this.toolBar.add(this.bIncreaseLineIndent);
        this.toolBar.add(this.bDecreaseLineIndent);
        this.toolBar.add(this.bPerformComplexOperation);
        this.toolBar.addSeparator();
        this.toolBar.add(this.bHelp);
        this.toolBar.add(this.bExit);
        this.buildToolTips();
    }

    private void buildToolTips() {
        this.bNew.setToolTipText("New");
        this.bOpen.setToolTipText("Open");
        this.bReload.setToolTipText("Reload");
        this.bSave.setToolTipText("Save");
        this.bRevert.setToolTipText("Revert");
        this.bPrint.setToolTipText("Print");
        this.bUndo.setToolTipText("Undo");
        this.bRedo.setToolTipText("Redo");
        this.bCut.setToolTipText("Cut");
        this.bCopy.setToolTipText("Copy");
        this.bPaste.setToolTipText("Paste");
        this.bClear.setToolTipText("Clear");
        this.bGoTo.setToolTipText("Go To");
        this.bFind.setToolTipText("Find");
        this.bReplace.setToolTipText("Replace");
        this.bCheckSpelling.setToolTipText("Check Spelling");
        this.bMakeUpperCase.setToolTipText("Make Uppercase");
        this.bMakeLowerCase.setToolTipText("Make Lowercase");
        this.bDeleteHorizontalWhiteSpace.setToolTipText("Delete Horizontal White Space");
        this.bIncreaseLineIndent.setToolTipText("Increase Line Indent");
        this.bDecreaseLineIndent.setToolTipText("Decrease Line Indent");
        this.bPerformComplexOperation.setToolTipText("Perform Complex Operation");
        this.bHelp.setToolTipText("Help");
        this.bExit.setToolTipText("Exit");
    }

    private void updateButtonsState() {
        this.bNew.setEnabled(this.getCommandGateway().canPerformCommand(CommandType.NEW));
        this.bSave.setEnabled(this.getCommandGateway().canPerformCommand(CommandType.SAVE));
        this.bReload.setEnabled(this.getCommandGateway().canPerformCommand(CommandType.RELOAD));
        this.bRevert.setEnabled(this.getCommandGateway().canPerformCommand(CommandType.REVERT));
        this.bPrint.setEnabled(this.getCommandGateway().canPerformCommand(CommandType.PRINT));
        this.bUndo.setEnabled(this.getCommandGateway().canPerformCommand(CommandType.UNDO));
        this.bRedo.setEnabled(this.getCommandGateway().canPerformCommand(CommandType.REDO));
        this.bCut.setEnabled(this.getCommandGateway().canPerformCommand(CommandType.CUT));
        this.bCopy.setEnabled(this.getCommandGateway().canPerformCommand(CommandType.COPY));
        this.bPaste.setEnabled(this.getCommandGateway().canPerformCommand(CommandType.PASTE));
        this.bClear.setEnabled(this.getCommandGateway().canPerformCommand(CommandType.CLEAR));
        this.bGoTo.setEnabled(this.getCommandGateway().canPerformCommand(CommandType.GO_TO));
        this.bFind.setEnabled(this.getCommandGateway().canPerformCommand(CommandType.FIND));
        this.bReplace.setEnabled(this.getCommandGateway().canPerformCommand(CommandType.REPLACE));
        this.bCheckSpelling.setEnabled(this.getCommandGateway().canPerformCommand(CommandType.CHECK_SPELLING));
        this.bMakeUpperCase.setEnabled(this.getCommandGateway().canPerformCommand(CommandType.MAKE_UPPER_CASE));
        this.bMakeLowerCase.setEnabled(this.getCommandGateway().canPerformCommand(CommandType.MAKE_LOWER_CASE));
        this.bDeleteHorizontalWhiteSpace.setEnabled(this.getCommandGateway().canPerformCommand(CommandType.DELETE_HORIZONTAL_WHITE_SPACE));
        this.bIncreaseLineIndent.setEnabled(this.getCommandGateway().canPerformCommand(CommandType.INCREASE_LINE_INDENT));
        this.bDecreaseLineIndent.setEnabled(this.getCommandGateway().canPerformCommand(CommandType.DECREASE_LINE_INDENT));
        this.bPerformComplexOperation.setEnabled(this.getCommandGateway().canPerformCommand(CommandType.PERFORM_COMPLEX_OPERATION));
    }

    @Override
    protected void buildActions() {
        super.buildActions();
        this.toolBarUpdatingTimer.start();
    }

    @Override
    public void setToolBarVisible(boolean bl) {
        this.toolBar.setVisible(bl);
    }

    @Override
    public boolean isToolBarVisible() {
        return this.toolBar.isVisible();
    }
}

