/*
 * Decompiled with CFR 0.152.
 */
package gui.dialog;

import gui.Application;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import neutrino.text.components.plain.PlainTextArea;

public class AdvancedDialog
extends JDialog {
    private JCheckBox cbSaveCaretPosition = new JCheckBox("Save caret position");
    private JCheckBox cbConfirmReloading = new JCheckBox("Confirm reloading");
    private JCheckBox cbConfirmRemoving = new JCheckBox("Confirm removing");
    private JCheckBox cbConfirmOverwriting = new JCheckBox("Confirm overwriting");
    private JCheckBox cbPersistCurrentFile = new JCheckBox("Persist current file");
    private JCheckBox cbPersistBackup = new JCheckBox("Persist backup");
    private JButton bOk = new JButton("Ok");
    private JButton bCancel = new JButton("Cancel");
    private JButton bDefaults = new JButton("Defaults");
    private Application application = null;
    private ActionListener alOk = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            AdvancedDialog.this.establishValues();
            AdvancedDialog.this.setVisible(false);
            AdvancedDialog.this.dispose();
        }
    };
    private ActionListener alCancel = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            AdvancedDialog.this.setVisible(false);
            AdvancedDialog.this.dispose();
        }
    };
    private ActionListener alDefaults = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            AdvancedDialog.this.defaults();
        }
    };

    private Application getApplication() {
        return this.application;
    }

    private void initialize() {
        PlainTextArea plainTextArea = (PlainTextArea)this.getApplication().getTextEditor().getTextComponent();
        this.cbConfirmReloading.setSelected(this.getApplication().getTextEditor().isConfirmReloading());
        this.cbConfirmRemoving.setSelected(this.getApplication().getTextEditor().isConfirmRemoving());
        this.cbConfirmOverwriting.setSelected(this.getApplication().getTextEditor().isConfirmOverwriting());
        this.cbPersistCurrentFile.setSelected(this.getApplication().getSettings().isPersistCurrentFile());
        this.cbSaveCaretPosition.setSelected(this.getApplication().getSettings().isSaveCaretPosition());
        this.cbSaveCaretPosition.setEnabled(this.cbPersistCurrentFile.isSelected());
        this.cbPersistBackup.setSelected(this.getApplication().getTextEditor().getBackupManager().isEnabled());
        this.cbPersistCurrentFile.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                AdvancedDialog.this.cbSaveCaretPosition.setEnabled(AdvancedDialog.this.cbPersistCurrentFile.isSelected());
            }
        });
    }

    private void defaults() {
        this.cbConfirmReloading.setSelected(true);
        this.cbConfirmRemoving.setSelected(true);
        this.cbConfirmOverwriting.setSelected(true);
        this.cbPersistCurrentFile.setSelected(true);
        this.cbPersistBackup.setSelected(true);
        this.cbSaveCaretPosition.setSelected(false);
    }

    private void establishValues() {
        this.getApplication().getTextEditor().setConfirmationReloading(this.cbConfirmReloading.isSelected());
        this.getApplication().getTextEditor().setConfirmationRemoving(this.cbConfirmRemoving.isSelected());
        this.getApplication().getTextEditor().setConfirmationOverwriting(this.cbConfirmOverwriting.isSelected());
        this.getApplication().getSettings().setPersistingCurrentFile(this.cbPersistCurrentFile.isSelected());
        this.getApplication().getSettings().setSavingCaretPosition(this.cbSaveCaretPosition.isSelected());
        this.getApplication().getTextEditor().getBackupManager().setEnabled(this.cbPersistBackup.isSelected());
    }

    private AdvancedDialog(Application application) {
        this.application = application;
        this.setTitle("Advanced options");
        JPanel jPanel = new JPanel();
        jPanel.setBorder(new EmptyBorder(5, 5, 5, 5));
        jPanel.setLayout(new FlowLayout());
        jPanel.add(this.getMainPanel());
        this.getContentPane().add(jPanel);
        this.getRootPane().setDefaultButton(this.bOk);
        this.pack();
        this.initialize();
        this.setResizable(false);
        this.setModal(true);
        this.setDefaultCloseOperation(2);
    }

    public static void showAdvancedDialog(Application application) {
        AdvancedDialog advancedDialog = new AdvancedDialog(application);
        Dimension dimension = advancedDialog.getSize();
        Dimension dimension2 = application.getSize();
        int n = Math.max((dimension2.width - dimension.width) / 2, 0);
        int n2 = Math.max((dimension2.height - dimension.height) / 2, 0);
        advancedDialog.setBounds(n + application.getX(), n2 + application.getY(), dimension.width, dimension.height);
        advancedDialog.setVisible(true);
    }

    private JPanel getMainPanel() {
        JPanel jPanel = new JPanel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        jPanel.setLayout(gridBagLayout);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        jPanel.add((Component)this.getCurrentFilePanel(), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = new Insets(5, 5, 0, 0);
        jPanel.add((Component)this.getButtonsPanel(), gridBagConstraints);
        return jPanel;
    }

    private JPanel getCurrentFilePanel() {
        this.cbConfirmReloading.setMnemonic(73);
        this.cbConfirmRemoving.setMnemonic(69);
        this.cbConfirmOverwriting.setMnemonic(87);
        this.cbPersistCurrentFile.setMnemonic(80);
        this.cbSaveCaretPosition.setMnemonic(82);
        this.cbPersistBackup.setMnemonic(75);
        JPanel jPanel = new JPanel();
        BoxLayout boxLayout = new BoxLayout(jPanel, 1);
        CompoundBorder compoundBorder = new CompoundBorder(new TitledBorder("Current file"), new EmptyBorder(0, 0, 0, 5));
        jPanel.setLayout(boxLayout);
        jPanel.setBorder(compoundBorder);
        jPanel.add(this.cbConfirmReloading);
        jPanel.add(Box.createVerticalStrut(5));
        jPanel.add(this.cbConfirmRemoving);
        jPanel.add(Box.createVerticalStrut(5));
        jPanel.add(this.cbConfirmOverwriting);
        jPanel.add(Box.createVerticalStrut(5));
        jPanel.add(this.cbPersistCurrentFile);
        jPanel.add(Box.createVerticalStrut(5));
        jPanel.add(this.cbSaveCaretPosition);
        jPanel.add(Box.createVerticalStrut(5));
        jPanel.add(this.cbPersistBackup);
        return jPanel;
    }

    private JPanel getButtonsPanel() {
        this.bOk.setMnemonic(79);
        this.bCancel.setMnemonic(67);
        this.bDefaults.setMnemonic(68);
        this.bOk.addActionListener(this.alOk);
        this.bCancel.addActionListener(this.alCancel);
        this.bDefaults.addActionListener(this.alDefaults);
        this.bOk.setToolTipText("Set options");
        this.bDefaults.setToolTipText("Select defaults");
        this.bCancel.setToolTipText("Abort spelling options dialog");
        JPanel jPanel = new JPanel();
        GridLayout gridLayout = new GridLayout(3, 1, 0, 5);
        jPanel.setLayout(gridLayout);
        jPanel.add(this.bOk);
        jPanel.add(this.bCancel);
        jPanel.add(this.bDefaults);
        return jPanel;
    }
}

