/*
 * Decompiled with CFR 0.152.
 */
package properties;

import gui.Application;
import java.io.File;
import java.io.Serializable;
import neutrino.options.FileOptions;
import neutrino.options.SpellingOptions;
import neutrino.options.TextOptions;
import neutrino.options.WindowOptions;
import neutrino.text.components.plain.PlainTextArea;
import properties.Settings;

public class EditorProperties
implements Serializable {
    private File directory = null;
    private File file = null;
    private int caretPosition;
    private Settings settings = new Settings();
    private FileOptions fileOptions = new FileOptions();
    private WindowOptions windowOptions = new WindowOptions();
    private SpellingOptions spellingOptions;
    private TextOptions textOptions = new TextOptions();

    public EditorProperties() {
        this.spellingOptions = new SpellingOptions();
    }

    public void buildProperties(Application application) {
        this.settings = application.getSettings();
        PlainTextArea plainTextArea = (PlainTextArea)application.getTextEditor().getTextComponent();
        this.file = application.getTextEditor().isFileLoaded() && application.getSettings().isPersistCurrentFile() ? application.getTextEditor().getFile() : null;
        this.directory = application.getTextEditor().getCurrentDirectory();
        this.caretPosition = plainTextArea.getCaretPosition();
        this.spellingOptions.buildProperties();
        this.textOptions.buildProperties((PlainTextArea)application.getTextEditor().getTextComponent());
        this.windowOptions.buildProperties(application);
        this.fileOptions.buildProperties(application.getTextEditor());
    }

    public void establishProperties(Application application, String[] stringArray) {
        application.setSettings(this.settings);
        this.fileOptions.establishProperties(application.getTextEditor());
        this.textOptions.establishProperties((PlainTextArea)application.getTextEditor().getTextComponent());
        if (stringArray != null && stringArray.length > 0) {
            File file = new File(stringArray[0]);
            application.getTextEditor().open(file);
        } else if (this.file != null && application.getSettings().isPersistCurrentFile() && this.file.exists() && this.file.isFile()) {
            application.getTextEditor().open(this.file);
        }
        if (this.directory != null && this.directory.exists() && this.directory.isDirectory()) {
            application.getTextEditor().setCurrentDirectory(this.directory);
        }
        try {
            if (application.getSettings().isSaveCaretPosition() && application.getSettings().isPersistCurrentFile()) {
                application.getTextEditor().getTextComponent().setCaretPosition(this.caretPosition);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        this.windowOptions.establishProperties(application);
        this.spellingOptions.establishProperties(application.getTextEditor().getTextComponent(), null);
    }
}

