package commands;

import gui.Application;
import java.util.ArrayList;

/**
 * Gateway to the menu actions.
 * @author Oleh Radvanskyj
 * @version 1.0
 */
public class CommandGateway {

    private ArrayList<ICommandGateway> commandGateways = new ArrayList<ICommandGateway>();

	public CommandGateway(Application application) {
        commandGateways.add(new FileCommandGateway(application));
        commandGateways.add(new EditingCommandGateway(application));
        commandGateways.add(new CommandCommandGateway(application));
        commandGateways.add(new SettingsCommandGateway(application));
        commandGateways.add(new HelpCommandGateway(application));
	}

	/**
	 * Performs command appropriate to given type
	 * @param command - CommandType
	 */
	public void performCommand(CommandType command) {
        for (ICommandGateway commandGateway : commandGateways) {
            commandGateway.performCommand(command);
        }
	}

	/**
	 * Returns true when can perform command appropriate to given type
	 * @param command - CommandType
	 * @return boolean
	 */
	public boolean canPerformCommand(CommandType command) {
        for (ICommandGateway commandGateway : commandGateways) {
            if (commandGateway.containsCommand(command)) return commandGateway.canPerformCommand(command);
        }
		return true;
	}
	
}
