package gui;

import java.awt.event.*;
import javax.swing.JFrame;
import commands.CommandGateway;
import commands.CommandType;
import neutrino.dialogs.HelpChooser;


/**
 * Build actions
 * @author Oleh Radvanskyj
 * @version 1.0
 */
public class ActionBuilder extends ToolBarBuilder implements ActionListener {
	
	private CommandGateway commandGateway = null;
	
	public ActionBuilder() {
		super();
		commandGateway = new CommandGateway(this);
		addWindowListener(windowListener);
		setDefaultCloseOperation(JFrame.DO_NOTHING_ON_CLOSE);
        ActionListener alHelp = HelpChooser.getActionListener("extendedTextEditor.hs");
        miHelp.addActionListener(alHelp);
        bHelp.addActionListener(alHelp);
	}

	protected void buildActions() {
		super.buildActions();
		// build menu actions
		miNew.addActionListener(this);
		miOpen.addActionListener(this);
		miRestore.addActionListener(this);
		miSave.addActionListener(this);
		miSaveAs.addActionListener(this);
		miReload.addActionListener(this);
		miRevert.addActionListener(this);
		miPrint.addActionListener(this);
        miMove.addActionListener(this);
        miCopyFile.addActionListener(this);
        miRemove.addActionListener(this);
        miRename.addActionListener(this);
        miExecute.addActionListener(this);
        miReadOnly.addActionListener(this);
        miWriteOnly.addActionListener(this);
        miHidden.addActionListener(this);
		miExit.addActionListener(this);
		miUndo.addActionListener(this);
		miRedo.addActionListener(this);
		miCut.addActionListener(this);
		miCopy.addActionListener(this);
		miPaste.addActionListener(this);
        miClear.addActionListener(this);
        miReadOnlyMode.addActionListener(this);
		miGoTo.addActionListener(this);
		miFind.addActionListener(this);
		miReplace.addActionListener(this);
        miCheckSpelling.addActionListener(this);
		miSelectAll.addActionListener(this);
        miDeselect.addActionListener(this);
		miMakeUpperCase.addActionListener(this);
		miMakeLowerCase.addActionListener(this);
        miMakeTitleCase.addActionListener(this);
        miInvertCaseLetters.addActionListener(this);
        miCapitalizeWords.addActionListener(this);
        miInvertCapitalization.addActionListener(this);
		miTabifySelectedLines.addActionListener(this);
		miUntabifySelectedLines.addActionListener(this);
        miTrimSelectedLines.addActionListener(this);
        miJoinSelectedLines.addActionListener(this);
        miSplitIntoLines.addActionListener(this);
        miDuplicateSelectedLines.addActionListener(this);
        miRemoveEmptyLines.addActionListener(this);
        miSortLinesAscendant.addActionListener(this);
        miSortLinesDescendant.addActionListener(this);
		miDeleteHorizontalWhiteSpace.addActionListener(this);
		miRemoveTrailingWhitespaces.addActionListener(this);
		miShiftInLeft.addActionListener(this);
		miShiftInRight.addActionListener(this);
        miMoveLinesUp.addActionListener(this);
        miMoveLinesDown.addActionListener(this);
        miAlignTextLeft.addActionListener(this);
        miAlignTextRight.addActionListener(this);
        miCenterText.addActionListener(this);
        miJustifyText.addActionListener(this);
        miMakeLatinParagraph.addActionListener(this);
        miMakeCyrillicParagraph.addActionListener(this);
		miPerformComplexOperation.addActionListener(this);
		miForeground.addActionListener(this);
		miBackground.addActionListener(this);
		miFont.addActionListener(this);
		miEncoding.addActionListener(this);
        miSpelling.addActionListener(this);
        miText.addActionListener(this);
        miWindow.addActionListener(this);
		miAdvanced.addActionListener(this);
        miGame.addActionListener(this);
        miLicense.addActionListener(this);
		miAbout.addActionListener(this);
		// build tool bar actions
		bNew.addActionListener(this);
		bOpen.addActionListener(this);
		bReload.addActionListener(this);
		bSave.addActionListener(this);
		bRevert.addActionListener(this);
		bPrint.addActionListener(this);
		bUndo.addActionListener(this);
		bRedo.addActionListener(this);
		bCut.addActionListener(this);
		bCopy.addActionListener(this);
		bPaste.addActionListener(this);
        bClear.addActionListener(this);
        bGoTo.addActionListener(this);
		bFind.addActionListener(this);
		bReplace.addActionListener(this);
        bCheckSpelling.addActionListener(this);
		bMakeUpperCase.addActionListener(this);
		bMakeLowerCase.addActionListener(this);
		bDeleteHorizontalWhiteSpace.addActionListener(this);
		bIncreaseLineIndent.addActionListener(this);
		bDecreaseLineIndent.addActionListener(this);
		bPerformComplexOperation.addActionListener(this);
		bHelp.addActionListener(this);
		bExit.addActionListener(this);
		// build popup menu actions
		pmiUndo.addActionListener(this);
		pmiRedo.addActionListener(this);
		pmiCut.addActionListener(this);
		pmiCopy.addActionListener(this);
		pmiPaste.addActionListener(this);
        pmiClear.addActionListener(this);
		pmiSelectAll.addActionListener(this);
        pmiDeselect.addActionListener(this);
	}
	
	public CommandGateway getCommandGateway() {
		return this.commandGateway;
	}
	
	public void actionPerformed(ActionEvent e) {
		if (e.getSource() == miNew || e.getSource() == bNew) {
			getCommandGateway().performCommand(CommandType.NEW);
		} else if (e.getSource() == miOpen || e.getSource() == bOpen) {
			getCommandGateway().performCommand(CommandType.OPEN);
		}  else if (e.getSource() == miRestore) {
			getCommandGateway().performCommand(CommandType.RESTORE);
		} else if (e.getSource() == miSave || e.getSource() == bSave) {
			getCommandGateway().performCommand(CommandType.SAVE);
		} else if (e.getSource() == miSaveAs) {
			getCommandGateway().performCommand(CommandType.SAVE_AS);
		} else if (e.getSource() == miRevert || e.getSource() == bRevert) {
			getCommandGateway().performCommand(CommandType.REVERT);
		} else if (e.getSource() == miReload || e.getSource() == bReload) {
			getCommandGateway().performCommand(CommandType.RELOAD);
		} else if (e.getSource() == miPrint || e.getSource() == bPrint) {
			getCommandGateway().performCommand(CommandType.PRINT);
		} else if (e.getSource() == miMove) {
            getCommandGateway().performCommand(CommandType.MOVE);
        } else if (e.getSource() == miRemove) {
            getCommandGateway().performCommand(CommandType.REMOVE);
        } else if (e.getSource() == miRename) {
            getCommandGateway().performCommand(CommandType.RENAME);
        } else if (e.getSource() == miCopyFile) {
            getCommandGateway().performCommand(CommandType.COPY_FILE);
        } else if (e.getSource() == miExecute) {
            getCommandGateway().performCommand(CommandType.EXECUTE);
        } else if (e.getSource() == miReadOnly) {
            getCommandGateway().performCommand(CommandType.READ_ONLY);
        } else if (e.getSource() == miWriteOnly) {
            getCommandGateway().performCommand(CommandType.WRITE_ONLY);
        } else if (e.getSource() == miHidden) {
            getCommandGateway().performCommand(CommandType.HIDDEN);
        } else if (e.getSource() == miExit || e.getSource() == bExit) {
			getCommandGateway().performCommand(CommandType.EXIT);
		} else if (e.getSource() == miUndo || e.getSource() == bUndo || e.getSource() == pmiUndo) {
			getCommandGateway().performCommand(CommandType.UNDO);
		} else if (e.getSource() == miRedo || e.getSource() == bRedo || e.getSource() == pmiRedo) {
			getCommandGateway().performCommand(CommandType.REDO);
		} else if (e.getSource() == miCut || e.getSource() == bCut || e.getSource() == pmiCut) {
			getCommandGateway().performCommand(CommandType.CUT);
		} else if (e.getSource() == miCopy || e.getSource() == bCopy || e.getSource() == pmiCopy) {
			getCommandGateway().performCommand(CommandType.COPY);
		} else if (e.getSource() == miPaste || e.getSource() == bPaste || e.getSource() == pmiPaste) {
			getCommandGateway().performCommand(CommandType.PASTE);
		} else if (e.getSource() == miClear || e.getSource() == bClear || e.getSource() == pmiClear) {
            getCommandGateway().performCommand(CommandType.CLEAR);
        } else if (e.getSource() == miReadOnlyMode) {
            getCommandGateway().performCommand(CommandType.READ_ONLY_MODE);
        } else if (e.getSource() == miGoTo || e.getSource() == bGoTo) {
			getCommandGateway().performCommand(CommandType.GO_TO);
		} else if (e.getSource() == miFind || e.getSource() == bFind) {
			getCommandGateway().performCommand(CommandType.FIND);
		} else if (e.getSource() == miReplace || e.getSource() == bReplace) {
			getCommandGateway().performCommand(CommandType.REPLACE);
		} else if (e.getSource() == miCheckSpelling || e.getSource() == bCheckSpelling) {
            getCommandGateway().performCommand(CommandType.CHECK_SPELLING);
        } else if (e.getSource() == miSelectAll || e.getSource() == pmiSelectAll) {
			getCommandGateway().performCommand(CommandType.SELECT_ALL);
		} else if (e.getSource() == miDeselect || e.getSource() == pmiDeselect) {
            getCommandGateway().performCommand(CommandType.DESELECT);
        } else if (e.getSource() == miMakeUpperCase || e.getSource() == bMakeUpperCase) {
			getCommandGateway().performCommand(CommandType.MAKE_UPPER_CASE);
		} else if (e.getSource() == miMakeLowerCase || e.getSource() == bMakeLowerCase) {
			getCommandGateway().performCommand(CommandType.MAKE_LOWER_CASE);
		} else if (e.getSource() == miMakeTitleCase) {
            getCommandGateway().performCommand(CommandType.MAKE_TITLE_CASE);
        } else if (e.getSource() == miInvertCaseLetters) {
            getCommandGateway().performCommand(CommandType.INVERT_CASE_LETTERS);
        } else if (e.getSource() == miCapitalizeWords) {
            getCommandGateway().performCommand(CommandType.CAPITALIZE_WORDS);
        } else if (e.getSource() == miInvertCapitalization) {
            getCommandGateway().performCommand(CommandType.INVERT_CAPITALIZATION);
        } else if (e.getSource() == miTabifySelectedLines) {
			getCommandGateway().performCommand(CommandType.TABIFY_SELECTED_LINES);
		} else if (e.getSource() == miUntabifySelectedLines) {
			getCommandGateway().performCommand(CommandType.UNTABIFY_SELECTED_LINES);
		} else if (e.getSource() == miTrimSelectedLines) {
            getCommandGateway().performCommand(CommandType.TRIM_SELECTED_LINES);
        } else if (e.getSource() == miJoinSelectedLines) {
            getCommandGateway().performCommand(CommandType.JOIN_SELECTED_LINES);
        } else if (e.getSource() == miSplitIntoLines) {
            getCommandGateway().performCommand(CommandType.SPLIT_INTO_LINES);
        } else if (e.getSource() == miDuplicateSelectedLines) {
            getCommandGateway().performCommand(CommandType.DUPLICATE_SELECTED_LINES);
        } else if (e.getSource() == miRemoveEmptyLines) {
            getCommandGateway().performCommand(CommandType.REMOVE_EMPTY_LIENS);
        } else if (e.getSource() == miSortLinesAscendant) {
            getCommandGateway().performCommand(CommandType.SORT_LINES_ASCENDANT);
        } else if (e.getSource() == miSortLinesDescendant) {
            getCommandGateway().performCommand(CommandType.SORT_LINES_DESCENDANT);
        } else if (e.getSource() == miDeleteHorizontalWhiteSpace || e.getSource() == bDeleteHorizontalWhiteSpace) {
			getCommandGateway().performCommand(CommandType.DELETE_HORIZONTAL_WHITE_SPACE);
		} else if (e.getSource() == miRemoveTrailingWhitespaces) {
			getCommandGateway().performCommand(CommandType.REMOVE_TRAILING_WHITESPACES);
		} else if (e.getSource() == miShiftInLeft || e.getSource() == bDecreaseLineIndent) {
			getCommandGateway().performCommand(CommandType.DECREASE_LINE_INDENT);
		} else if (e.getSource() == miShiftInRight || e.getSource() == bIncreaseLineIndent) {
			getCommandGateway().performCommand(CommandType.INCREASE_LINE_INDENT);
		} else if (e.getSource() == miMoveLinesUp) {
            getCommandGateway().performCommand(CommandType.MOVE_LINES_UP);
        } else if (e.getSource() == miMoveLinesDown) {
            getCommandGateway().performCommand(CommandType.MOVE_LINES_DOWN);
        } else if (e.getSource() == miAlignTextLeft) {
            getCommandGateway().performCommand(CommandType.ALIGN_TEXT_LEFT);
        } else if (e.getSource() == miAlignTextRight) {
            getCommandGateway().performCommand(CommandType.ALIGN_TEXT_RIGHT);
        } else if (e.getSource() == miCenterText) {
            getCommandGateway().performCommand(CommandType.CENTER_TEXT);
        } else if (e.getSource() == miJustifyText) {
            getCommandGateway().performCommand(CommandType.JUSTIFY_TEXT);
        } else if (e.getSource() == miMakeLatinParagraph) {
            getCommandGateway().performCommand(CommandType.MAKE_LATIN_PARAGRAPH);
        } else if (e.getSource() == miMakeCyrillicParagraph) {
            getCommandGateway().performCommand(CommandType.MAKE_CYRILLIC_PARAGRAPH);
        } else if (e.getSource() == miPerformComplexOperation || e.getSource() == bPerformComplexOperation) {
			getCommandGateway().performCommand(CommandType.PERFORM_COMPLEX_OPERATION);
		} else if (e.getSource() == miForeground) {
			getCommandGateway().performCommand(CommandType.FOREGROUND);
		} else if (e.getSource() == miBackground) {
			getCommandGateway().performCommand(CommandType.BACKGROUND);
		} else if (e.getSource() == miFont) {
			getCommandGateway().performCommand(CommandType.FONT);
		} else if (e.getSource() == miEncoding) {
			getCommandGateway().performCommand(CommandType.ENCODING);
		} else if (e.getSource() == miSpelling) {
            getCommandGateway().performCommand(CommandType.SPELLING);
        } else if (e.getSource() == miText) {
            getCommandGateway().performCommand(CommandType.TEXT_OPTIONS);
        } else if (e.getSource() == miWindow) {
            getCommandGateway().performCommand(CommandType.WINDOW_OPTIONS);
        } else if (e.getSource() == miAdvanced) {
			getCommandGateway().performCommand(CommandType.ADVANCED);
		} else if (e.getSource() == miGame) {
            getCommandGateway().performCommand(CommandType.GAME);
        } else if (e.getSource() == miLicense) {
            getCommandGateway().performCommand(CommandType.LICENSE);
        } else if (e.getSource() == miAbout) {
			getCommandGateway().performCommand(CommandType.ABOUT);
		}
		getTextEditor().getTextComponent().grabFocus();
	}

	private WindowListener windowListener = new WindowAdapter() {
		
		public void windowClosing(WindowEvent e) {
			getCommandGateway().performCommand(CommandType.EXIT);
		}
		
	};
	
}
