package gui;

import java.awt.event.*;
import javax.swing.*;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import com.inet.jortho.SpellChecker;
import commands.CommandType;
import neutrino.text.components.plain.PlainTextArea;

/**
 * Builds popup menu for text component
 * @author Oleh Radvanskyj
 * @version 1.0
 */
abstract class PopupMenuBuilder extends MenuBarBuilder {
 
	private JPopupMenu textComponentPopupMenu = new JPopupMenu();
	
	protected JMenuItem pmiUndo = new JMenuItem("Undo", iconUndo);
	protected JMenuItem pmiRedo = new JMenuItem("Redo", iconRedo);
	protected JMenuItem pmiCut = new JMenuItem("Cut", iconCut);
	protected JMenuItem pmiCopy = new JMenuItem("Copy", iconCopy);
	protected JMenuItem pmiPaste = new JMenuItem("Paste", iconPaste);
    protected JMenuItem pmiClear = new JMenuItem("Clear", iconClear);
    protected JMenu pmCheckSpelling;
    protected JMenu pmLanguages;
	protected JMenuItem pmiSelectAll = new JMenuItem("Select all", iconSelectAll);
    protected JMenuItem pmiDeselect = new JMenuItem("Deselect", iconDeselect);

	public PopupMenuBuilder() {
		super();
		((PlainTextArea) getTextEditor().getTextComponent()).setPopupMenu(textComponentPopupMenu);
		textComponentPopupMenu.addPopupMenuListener(new PopupMenuListener() {
			@Override
			public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
				updateTextComponentPopupMenuState();
			}
			@Override
			public void popupMenuWillBecomeInvisible(PopupMenuEvent e) { }
			@Override
			public void popupMenuCanceled(PopupMenuEvent e) { }
		});
        // initialize Check Spelling menu item
        pmCheckSpelling = SpellChecker.createCheckerMenu();
        pmCheckSpelling.setIcon(iconSpelling);
        // initialize Languages menu
        pmLanguages = SpellChecker.createLanguagesMenu();
        pmLanguages.setIcon(iconLanguages);
    }
	
	private void updateTextComponentPopupMenuState() {
		pmiUndo.setEnabled(getCommandGateway().canPerformCommand(CommandType.UNDO));
		pmiRedo.setEnabled(getCommandGateway().canPerformCommand(CommandType.REDO));
		pmiCut.setEnabled(getCommandGateway().canPerformCommand(CommandType.CUT));
		pmiCopy.setEnabled(getCommandGateway().canPerformCommand(CommandType.COPY));
		pmiPaste.setEnabled(getCommandGateway().canPerformCommand(CommandType.PASTE));
        pmiClear.setEnabled(getCommandGateway().canPerformCommand(CommandType.CLEAR));
		pmiSelectAll.setEnabled(getCommandGateway().canPerformCommand(CommandType.SELECT_ALL));
        pmiDeselect.setEnabled(getCommandGateway().canPerformCommand(CommandType.DESELECT));
	}
	
	private void buildPopupMenuForTextComponent() {
		textComponentPopupMenu.add(pmiUndo);
		textComponentPopupMenu.add(pmiRedo);
		textComponentPopupMenu.addSeparator();		
		textComponentPopupMenu.add(pmiCut);
		textComponentPopupMenu.add(pmiCopy);
		textComponentPopupMenu.add(pmiPaste);
        textComponentPopupMenu.add(pmiClear);
		textComponentPopupMenu.addSeparator();
        textComponentPopupMenu.add(pmCheckSpelling);
        textComponentPopupMenu.add(pmLanguages);
        textComponentPopupMenu.addSeparator();
		textComponentPopupMenu.add(pmiSelectAll);
        textComponentPopupMenu.add(pmiDeselect);
	}
	
	private void buildMnemonics() {
		pmiUndo.setMnemonic(KeyEvent.VK_U);
		pmiRedo.setMnemonic(KeyEvent.VK_R);
		pmiCut.setMnemonic(KeyEvent.VK_C);
		pmiCopy.setMnemonic(KeyEvent.VK_O);
		pmiPaste.setMnemonic(KeyEvent.VK_P);
        pmiClear.setMnemonic(KeyEvent.VK_L);
        pmCheckSpelling.setMnemonic(KeyEvent.VK_H);
        pmLanguages.setMnemonic(KeyEvent.VK_N);
		pmiSelectAll.setMnemonic(KeyEvent.VK_S);
        pmiDeselect.setMnemonic(KeyEvent.VK_D);
	}
	
	private void buildAccelerators() {
		pmiUndo.setAccelerator(KeyStroke.getKeyStroke(KeyEvent.VK_Z, InputEvent.CTRL_DOWN_MASK));
		pmiRedo.setAccelerator(KeyStroke.getKeyStroke(KeyEvent.VK_Y, InputEvent.CTRL_DOWN_MASK));
		pmiCut.setAccelerator(KeyStroke.getKeyStroke(KeyEvent.VK_X, InputEvent.CTRL_DOWN_MASK));
		pmiCopy.setAccelerator(KeyStroke.getKeyStroke(KeyEvent.VK_C, InputEvent.CTRL_DOWN_MASK));
		pmiPaste.setAccelerator(KeyStroke.getKeyStroke(KeyEvent.VK_V, InputEvent.CTRL_DOWN_MASK));
        pmiClear.setAccelerator(KeyStroke.getKeyStroke(KeyEvent.VK_DELETE, 0));
		pmiSelectAll.setAccelerator(KeyStroke.getKeyStroke(KeyEvent.VK_A, InputEvent.CTRL_DOWN_MASK));
        pmiDeselect.setAccelerator(KeyStroke.getKeyStroke(KeyEvent.VK_ESCAPE, 0));
	}
	
	protected void buildPopupMenu() {
		buildPopupMenuForTextComponent();
		buildMnemonics();
		buildAccelerators();
	}

}
