package gui.dialog;

import gui.Application;
import neutrino.text.components.plain.PlainTextArea;

import java.awt.*;
import java.awt.event.*;
import java.util.Hashtable;
import javax.swing.*;
import javax.swing.UIManager.LookAndFeelInfo;
import javax.swing.border.*;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import static javax.swing.JOptionPane.*;

/**
 * Dialog for advanced options.
 * @author Oleh Radvanskyj
 * @version 1.0
 */
public class AdvancedDialog extends JDialog {

	private JCheckBox cbSaveCaretPosition = new JCheckBox("Save caret position");
	private JCheckBox cbConfirmReloading = new JCheckBox("Confirm reloading");
    private JCheckBox cbConfirmRemoving = new JCheckBox("Confirm removing");
    private JCheckBox cbConfirmOverwriting = new JCheckBox("Confirm overwriting");
	private JCheckBox cbPersistCurrentFile = new JCheckBox("Persist current file");
	private JCheckBox cbPersistBackup = new JCheckBox("Persist backup");
	private JButton bOk = new JButton("Ok");
	private JButton bCancel = new JButton("Cancel");
	private JButton bDefaults = new JButton("Defaults");

	private Application application = null;
	
	private Application getApplication() {
		return this.application;
	}
	
	/**
	 * Initialize dialog.
	 */
	private void initialize() {
		PlainTextArea textComponent = (PlainTextArea) getApplication().getTextEditor().getTextComponent();
		cbConfirmReloading.setSelected(getApplication().getTextEditor().isConfirmReloading());
        cbConfirmRemoving.setSelected(getApplication().getTextEditor().isConfirmRemoving());
        cbConfirmOverwriting.setSelected(getApplication().getTextEditor().isConfirmOverwriting());
		cbPersistCurrentFile.setSelected(getApplication().getSettings().isPersistCurrentFile());
		cbSaveCaretPosition.setSelected(getApplication().getSettings().isSaveCaretPosition());
		cbSaveCaretPosition.setEnabled(cbPersistCurrentFile.isSelected());
		cbPersistBackup.setSelected(getApplication().getTextEditor().getBackupManager().isEnabled());
		cbPersistCurrentFile.addChangeListener(new ChangeListener() {
			public void stateChanged(ChangeEvent e) {
				cbSaveCaretPosition.setEnabled(cbPersistCurrentFile.isSelected());
			}
		});		
	}
	
	/**
	 * Set default values.
	 */
	private void defaults() {
		cbConfirmReloading.setSelected(true);
        cbConfirmRemoving.setSelected(true);
        cbConfirmOverwriting.setSelected(true);
		cbPersistCurrentFile.setSelected(true);
		cbPersistBackup.setSelected(true);
		cbSaveCaretPosition.setSelected(false);
	}

	
	/**
	 * Establish propgarm variables
	 */
	private void establishValues() {
		getApplication().getTextEditor().setConfirmationReloading(cbConfirmReloading.isSelected());
        getApplication().getTextEditor().setConfirmationRemoving(cbConfirmRemoving.isSelected());
        getApplication().getTextEditor().setConfirmationOverwriting(cbConfirmOverwriting.isSelected());
		getApplication().getSettings().setPersistingCurrentFile(cbPersistCurrentFile.isSelected());
		getApplication().getSettings().setSavingCaretPosition(cbSaveCaretPosition.isSelected());
		getApplication().getTextEditor().getBackupManager().setEnabled(cbPersistBackup.isSelected());
	}

	private AdvancedDialog(Application application) {
		super();
		this.application = application;
		setTitle("Advanced options");
		
		JPanel panel = new JPanel();
		panel.setBorder(new EmptyBorder(5, 5, 5, 5));
		panel.setLayout(new FlowLayout());
        panel.add(getMainPanel());
        
        getContentPane().add(panel);
        getRootPane().setDefaultButton(bOk);
		pack();

        initialize();
        
		setResizable(false);
		setModal(true);
		setDefaultCloseOperation(DISPOSE_ON_CLOSE);
	}
	
	public static void showAdvancedDialog(Application application) {
		AdvancedDialog dialog = new AdvancedDialog(application);
        Dimension d1 = dialog.getSize(); 
        Dimension d2 = application.getSize();
        int x = Math.max((d2.width-d1.width)/2, 0);
        int y = Math.max((d2.height-d1.height)/2, 0);
        dialog.setBounds(x + application.getX(), y + application.getY(), d1.width, d1.height);
		dialog.setVisible(true);
	}

	
	private JPanel getMainPanel() {
		JPanel mainPanel = new JPanel();
		GridBagLayout mainLayout = new GridBagLayout();
		GridBagConstraints constraints = new GridBagConstraints();
		mainPanel.setLayout(mainLayout);

		constraints.gridx = 0;
		constraints.gridy = 0;
		constraints.fill = GridBagConstraints.HORIZONTAL;
		constraints.anchor = GridBagConstraints.NORTH;
		constraints.insets = new Insets(0, 5, 0, 0);
		mainPanel.add(getCurrentFilePanel(), constraints);
		
		constraints.gridx = 1;
		constraints.gridy = 0;
		constraints.fill = GridBagConstraints.HORIZONTAL;
		constraints.anchor = GridBagConstraints.NORTH;
		constraints.insets = new Insets(5, 5, 0, 0);
		mainPanel.add(getButtonsPanel(), constraints);
		return mainPanel;
	}

	private JPanel getCurrentFilePanel() {
		cbConfirmReloading.setMnemonic(KeyEvent.VK_I);
        cbConfirmRemoving.setMnemonic(KeyEvent.VK_E);
        cbConfirmOverwriting.setMnemonic(KeyEvent.VK_W);
		cbPersistCurrentFile.setMnemonic(KeyEvent.VK_P);
		cbSaveCaretPosition.setMnemonic(KeyEvent.VK_R);
		cbPersistBackup.setMnemonic(KeyEvent.VK_K);
		JPanel panel = new JPanel();
		BoxLayout layout = new BoxLayout(panel, BoxLayout.Y_AXIS);
		Border border = new CompoundBorder(new TitledBorder("Current file"), new EmptyBorder(0, 0, 0, 5));
		panel.setLayout(layout);
		panel.setBorder(border);
		panel.add(cbConfirmReloading);
		panel.add(Box.createVerticalStrut(5));
        panel.add(cbConfirmRemoving);
        panel.add(Box.createVerticalStrut(5));
        panel.add(cbConfirmOverwriting);
        panel.add(Box.createVerticalStrut(5));
		panel.add(cbPersistCurrentFile);
		panel.add(Box.createVerticalStrut(5));
		panel.add(cbSaveCaretPosition);
		panel.add(Box.createVerticalStrut(5));
		panel.add(cbPersistBackup);
		return panel;
	}

	private JPanel getButtonsPanel() {
		bOk.setMnemonic(KeyEvent.VK_O);
		bCancel.setMnemonic(KeyEvent.VK_C);
		bDefaults.setMnemonic(KeyEvent.VK_D);
		bOk.addActionListener(alOk);
		bCancel.addActionListener(alCancel);
		bDefaults.addActionListener(alDefaults);
        bOk.setToolTipText("Set options");
        bDefaults.setToolTipText("Select defaults");
        bCancel.setToolTipText("Abort spelling options dialog");
		JPanel buttonsPanel = new JPanel();
		GridLayout buttonsLayout = new GridLayout(3, 1, 0, 5);
		buttonsPanel.setLayout(buttonsLayout);
		buttonsPanel.add(bOk);
		buttonsPanel.add(bCancel);
		buttonsPanel.add(bDefaults);
		return buttonsPanel;
	}
	
	private ActionListener alOk = new ActionListener() {
		public void actionPerformed(ActionEvent e) {
			establishValues();
			setVisible(false);
			dispose();
		}
	};

	private ActionListener alCancel = new ActionListener() {
		public void actionPerformed(ActionEvent e) {
			setVisible(false);
			dispose();
		}
	};

	private ActionListener alDefaults = new ActionListener() {
		public void actionPerformed(ActionEvent e) {
			defaults();
		}
	};
	
}
