<?xml version="1.0" encoding="UTF-8"?>
<!-- Copyright (C) 2012 Oleh Radvanskyj -->
<xsl:stylesheet version="2.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xs="http://www.w3.org/2001/XMLSchema" xmlns:fn="http://www.w3.org/2005/xpath-functions">
    <xsl:output method="html" encoding="UTF-8" indent="yes"/>

    <!-- use case model overview -->

    <xsl:template match="use-case-model" mode="overview">
        <xsl:if test="pd-package or use-case-package">
            <h3 id="use_case_model_overview" onclick="toggleTag('{generate-id(.)}-pd')">Overview</h3>
            <div id="{generate-id(.)}-pd" class="indent" style="display:none">
                <table class="overview">
                    <caption>Package - Description</caption>
                    <thead>
                        <tr>
                            <th>Name</th>
                            <th>Description</th>
                        </tr>
                    </thead>
                    <tbody>
                        <xsl:apply-templates select="use-case-package" mode="pd" />
                        <xsl:apply-templates select="pd-package/pd" />
                    </tbody>
                </table>
            </div>
        </xsl:if>
    </xsl:template>

    <xsl:template match="use-case-package" mode="overview">
        <xsl:if test="pd-package or use-case-package">
            <h4 id="{generate-id(.)}-overview" onclick="toggleTag('{generate-id(.)}-pd')">Overview</h4>
            <div id="{generate-id(.)}-pd" class="indent" style="display:none">
                <table class="overview">
                    <caption>Package - Description</caption>
                    <thead>
                        <tr>
                            <th>Name</th>
                            <th>Description</th>
                        </tr>
                    </thead>
                    <tbody>
                        <xsl:apply-templates select="use-case-package" mode="pd" />
                        <xsl:apply-templates select="pd-package/pd" />
                    </tbody>
                </table>
            </div>
        </xsl:if>
    </xsl:template>

    <xsl:template match="use-case-package" mode="pd">
        <tr>
            <td>
                <xsl:choose>
                    <xsl:when test="@id"><a href="#{@id}" onclick="expandAncestors('{@id}')"><xsl:value-of select="@name" /></a></xsl:when>
                    <xsl:otherwise><a href="#{generate-id(.)}-header" onclick="expandAncestors('{generate-id(.)}-header')"><xsl:value-of select="@name" /></a></xsl:otherwise>
                </xsl:choose>
            </td>
            <td><xsl:apply-templates select="description" mode="overview" /></td>
        </tr>
    </xsl:template>

    <xsl:template match="use-case-package/description" mode="overview">
        <xsl:apply-templates />
    </xsl:template>

</xsl:stylesheet>