<?xml version="1.0" encoding="UTF-8"?>
<!-- Copyright (C) 2013 Oleh Radvanskyj -->
<xsl:stylesheet version="2.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xs="http://www.w3.org/2001/XMLSchema" xmlns:fn="http://www.w3.org/2005/xpath-functions">
	<xsl:output method="html" encoding="UTF-8" indent="yes"/>
	
	<!-- use case model -->

	<xsl:template match="analysis" mode="table_of_contents_use-case-model">
		<xsl:if test="use-case-model/pd-package or use-case-model/use-case-package or use-case-model/use-case-diagram">
			<li><a href="#use_case_model" onclick="expandAncestors('use_case_model')">Use case model</a>
				<ul>
					<xsl:if test="use-case-model/pd-package or use-case-model/use-case-package">
						<li><a href="#use_case_model_overview" onclick="expandAncestors('use_case_model_overview')">Overview</a></li>
					</xsl:if>
					<xsl:if test="use-case-model/specification">
						<li><a href="#{generate-id(use-case-model/specification)}-header"  onclick="expandAncestors('{generate-id(use-case-model/specification)}-header')">Specification</a></li>
					</xsl:if>
					<xsl:if test="use-case-model/use-case-package">
						<li>Packages 
							<ul>
								<xsl:for-each select="use-case-model/use-case-package">
									<li>
										<xsl:choose>
											<xsl:when test="@id"><a href="#{@id}" onclick="expandAncestors('{@id}')"><xsl:value-of select="@name" /></a></xsl:when>
											<xsl:otherwise><a href="#{generate-id(.)}-header" onclick="expandAncestors('{generate-id(.)}-header')"><xsl:value-of select="@name" /></a></xsl:otherwise>
										</xsl:choose>
									</li>
								</xsl:for-each>
							</ul>
						</li>
					</xsl:if>
					<xsl:if test="use-case-model/use-case-diagram">
						<li>Diagrams
							<ul>
								<xsl:for-each select="use-case-model/use-case-diagram">
									<li>
										<xsl:choose>
											<xsl:when test="@id"><a href="#{@id}" onclick="expandAncestors('{@id}')"><xsl:value-of select="@name" /></a></xsl:when>
											<xsl:otherwise><a href="#{generate-id(.)}-header" onclick="expandAncestors('{generate-id(.)}-header')"><xsl:value-of select="@name" /></a></xsl:otherwise>
										</xsl:choose>
									</li>
								</xsl:for-each>
							</ul>
						</li>
					</xsl:if>
				</ul>
			</li>
		</xsl:if>
	</xsl:template>

	<xsl:template match="use-case-model">
		<h2 id="use_case_model">Use case model</h2>
		<xsl:apply-templates select="description" />
		<xsl:apply-templates select="." mode="overview" />
		<xsl:apply-templates select="specification" />
		<xsl:apply-templates select="use-case-package" />
		<xsl:apply-templates select="use-case-diagram" />
	</xsl:template>
	
	<xsl:template match="use-case-model/description">
		<h3>Description</h3>
		<div class="indent">
			<xsl:apply-templates />
		</div>
	</xsl:template>

	<xsl:template match="use-case-model/specification">
		<h3 id="{generate-id(.)}-header" onclick="toggleSpecification('{generate-id(.)}')">Specification</h3>
		<ol id="{generate-id(.)}" state="hidden" class="specification" style="display:none">
			<xsl:apply-templates />
		</ol>
	</xsl:template>	

	<xsl:template match="use-case-model/use-case-diagram">
		<xsl:choose>
			<xsl:when test="$out = 'file'">
				<xsl:choose>
					<xsl:when test="@page">
						<xsl:choose>
							<xsl:when test="@id">
								<h3 id="{@id}"><a href="{@page}"><xsl:value-of select="@name" /></a></h3>
								<img alt="{@name}" src="{@image}" />
							</xsl:when>
							<xsl:otherwise>
								<h3 id="{generate-id(.)}-header"><a href="{@page}"><xsl:value-of select="@name" /></a></h3>
								<img alt="{@name}" src="{@image}" />
							</xsl:otherwise>
						</xsl:choose>
					</xsl:when>
					<xsl:otherwise>
						<xsl:choose>
							<xsl:when test="@id">
								<h3 id="{@id}" onclick="toggleTag('{generate-id(.)}')"><xsl:value-of select="@name" /></h3>
								<img id="{generate-id(.)}" alt="{@name}" src="{@image}" />
							</xsl:when>
							<xsl:otherwise>
								<h3 id="{generate-id(.)}-header" onclick="toggleTag('{generate-id(.)}')"><xsl:value-of select="@name" /></h3>
								<img id="{generate-id(.)}" alt="{@name}" src="{@image}" />
							</xsl:otherwise>
						</xsl:choose>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:when>
			<xsl:otherwise>
				<xsl:choose>
					<xsl:when test="@document">
						<xsl:choose>
							<xsl:when test="@id">
								<h3 id="{@id}"><a href="{@document}"><xsl:value-of select="@name" /></a></h3>
								<img alt="{@name}" src="{@image}" />
							</xsl:when>
							<xsl:otherwise>
								<h3 id="{generate-id(.)}-header"><a href="{@document}"><xsl:value-of select="@name" /></a></h3>
								<img alt="{@name}" src="{@image}" />
							</xsl:otherwise>
						</xsl:choose>
					</xsl:when>
					<xsl:otherwise>
						<xsl:choose>
							<xsl:when test="@id">
								<h3 id="{@id}" onclick="toggleTag('{generate-id(.)}')"><xsl:value-of select="@name" /></h3>
								<img id="{generate-id(.)}" alt="{@name}" src="{@image}" />
							</xsl:when>
							<xsl:otherwise>
								<h3 id="{generate-id(.)}-header" onclick="toggleTag('{generate-id(.)}')"><xsl:value-of select="@name" /></h3>
								<img id="{generate-id(.)}" alt="{@name}" src="{@image}" />
							</xsl:otherwise>
						</xsl:choose>					
					</xsl:otherwise>
				</xsl:choose>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>

</xsl:stylesheet>
