<?xml version="1.0" encoding="UTF-8"?>
<!-- Copyright (C) 2012 Oleh Radvanskyj -->
<xsl:stylesheet version="2.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xs="http://www.w3.org/2001/XMLSchema" xmlns:fn="http://www.w3.org/2005/xpath-functions">
    <xsl:output method="html" encoding="UTF-8" indent="yes"/>

    <!-- overview -->

    <!-- solution -->

    <xsl:template match="catalog" mode="table_of_contents_overview">
        <xsl:if test="packages or patterns">
            <li><a href="#overview"  onclick="expandAncestors('overview')">Overview</a></li>
        </xsl:if>
    </xsl:template>

    <xsl:template match="catalog" mode="overview">
        <xsl:if test="packages or patterns">
            <h3 id="overview" onclick="toggleTag('{generate-id(.)}-overview')">Overview</h3>
            <div id="{generate-id(.)}-overview" class="indent" style="display:none">
                <xsl:apply-templates select="." mode="overview_content" />
            </div>
        </xsl:if>
    </xsl:template>

    <!-- package -->

    <xsl:template match="package" mode="table_of_contents_overview">
        <xsl:if test="packages or patterns">
            <li><a href="#{generate-id(.)}-overview-header"  onclick="expandAncestors('{generate-id(.)}-overview-header')">Overview</a></li>
        </xsl:if>
    </xsl:template>

    <xsl:template match="package" mode="overview">
        <xsl:if test="packages or patterns">
            <h4 id="{generate-id(.)}-overview-header" onclick="toggleTag('{generate-id(.)}-overview')">Overview</h4>
            <div id="{generate-id(.)}-overview" class="indent" style="display:none">
                <xsl:apply-templates select="." mode="overview_content" />
            </div>
        </xsl:if>
    </xsl:template>

    <!-- common -->

    <xsl:template match="catalog | package" mode="overview_content">
        <xsl:apply-templates select="." mode="overview_packages" />
        <xsl:apply-templates select="." mode="overview_patterns" />
    </xsl:template>

</xsl:stylesheet>