<?xml version="1.0" encoding="UTF-8"?>
<!-- Copyright (C) 2013 Oleh Radvanskyj -->
<xsl:stylesheet version="2.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xs="http://www.w3.org/2001/XMLSchema" xmlns:fn="http://www.w3.org/2005/xpath-functions">
	<xsl:output method="html" encoding="UTF-8" />
	
	<!-- class data -->
	
	<!-- element -->
	
	<xsl:template match="attributes/elements">
		<h4>Elements</h4>
		<ul class="attributes">
			<xsl:apply-templates select="element" />
		</ul>
	</xsl:template>
	
	<xsl:template match="element">
		<xsl:choose>
			<xsl:when test="@id">
				<li id="{@id}"><xsl:apply-templates select="." mode="content" /></li>			
			</xsl:when>
			<xsl:otherwise>
				<li id="{generate-id(.)}"><xsl:apply-templates select="." mode="content" /></li>			
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>	
	
	<xsl:template match="element" mode="content">
		<xsl:choose>
			<xsl:when test="@visibility = 'public'"> public </xsl:when>
			<xsl:when test="@visibility = 'protected'"> protected </xsl:when>
			<xsl:when test="@visibility = 'private'"> private </xsl:when>
			<xsl:when test="@visibility = 'pakage'"> pakage </xsl:when>
			<xsl:otherwise> public </xsl:otherwise>
		</xsl:choose>
		<xsl:if test="@final = 'yes'"> final </xsl:if>
		<xsl:if test="@modifiers">
			<xsl:value-of select="' '" />
			<xsl:value-of select="@modifiers" />
			<xsl:value-of select="' '" />
		</xsl:if>
		<xsl:value-of select="@name" />
		<xsl:choose>
			<xsl:when test="@type">
				as
				<xsl:choose>
					<xsl:when test="@reference-to-type"><a href="#{@reference-to-type}" onclick="expandAncestors('{@reference-to-type}')"><xsl:value-of select="@type" /></a></xsl:when>
					<xsl:otherwise><xsl:value-of select="@type" /></xsl:otherwise>
				</xsl:choose>
			</xsl:when>
			<xsl:when test="@primitive">
				as
				<xsl:choose>
					<xsl:when test="@primitive = 'integer'"> integer </xsl:when>
					<xsl:when test="@primitive = 'real'"> real </xsl:when>
					<xsl:when test="@primitive = 'object'"> object </xsl:when>
					<xsl:when test="@primitive = 'character'"> character </xsl:when>
					<xsl:when test="@primitive = 'string'"> string </xsl:when>
					<xsl:when test="@primitive = 'natural'"> natural </xsl:when>
					<xsl:when test="@primitive = 'boolean'"> boolean </xsl:when>
					<xsl:when test="@primitive = 'class'"> class </xsl:when>
				</xsl:choose>
			</xsl:when>
			<xsl:otherwise>
				<em class="comment"> { Warning : the type is not defined} </em>
			</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="variable">
				is ( 
				<xsl:apply-templates select="variable" />
				) 						
			</xsl:when>
			<xsl:when test="@value">
				is 
				<xsl:choose>
					<xsl:when test="@reference-to-value"><a href="#{@reference-to-value}" onclick="expandAncestors('{@reference-to-value}')"><xsl:value-of select="@value" /></a></xsl:when>
					<xsl:otherwise><xsl:value-of select="@value" /></xsl:otherwise>
				</xsl:choose>
			</xsl:when>
		</xsl:choose>
		<xsl:apply-templates select="annotations" mode="header" />
		<xsl:apply-templates select="." mode="association" />
		<xsl:if test="@purpose"><em class="comment"> { Purpose : <xsl:value-of select="@purpose" /> } </em></xsl:if>
		<xsl:if test="@description"><em class="comment"> { Description : <xsl:value-of select="@description" /> } </em></xsl:if>
	</xsl:template>
	
	<!-- enumeration-constant-element -->
	
	<xsl:template match="enumeration-constant-elements">
		<h4>Enumeration constant elements</h4>
		<div class="indent">
			<xsl:apply-templates select="enumeration-constant-element" />
		</div>
	</xsl:template>
	
	<xsl:template match="enumeration-constant-element">
		<xsl:choose>
			<xsl:when test="@id"><span id="{@id}"><xsl:value-of select="@name" /></span></xsl:when>
			<xsl:otherwise><span id="{generate-id(.)}"><xsl:value-of select="@name" /></span></xsl:otherwise>
		</xsl:choose>
		<xsl:if test="constant">
			is ( 
			<xsl:apply-templates select="constant" />
			) 
		</xsl:if>
		<xsl:if test="@description"><em class="comment"> { Description : <xsl:value-of select="@description" /> } </em></xsl:if>
		<xsl:if test="position() != last()"> , </xsl:if>
	</xsl:template>
	
	<!-- properties -->
	
	<xsl:template match="properties">
		<h4 onclick="toggleGroup('{generate-id(.)}')">Properties</h4>
		<div id="{generate-id(.)}" class="indent" state="collapsed">
			<xsl:apply-templates select="property" />
		</div>
	</xsl:template>
	
	<xsl:template match="property">
		<h4 onclick="toggleTag('{generate-id(.)}-content')"><xsl:apply-templates select="." mode="header" /></h4>
		<div id="{generate-id(.)}-content" class="indent" style="display:none">
			<xsl:apply-templates select="annotations" />
			<xsl:apply-templates select="set-property" />
			<xsl:apply-templates select="get-property" />
			<xsl:apply-templates select="test-procedures" />
		</div>
	</xsl:template>
	
	<xsl:template match="property" mode="header">
		<xsl:choose>
			<xsl:when test="@visibility = 'public'"> public </xsl:when>
			<xsl:when test="@visibility = 'protected'"> protected </xsl:when>
			<xsl:when test="@visibility = 'private'"> private </xsl:when>
			<xsl:when test="@visibility = 'pakage'"> pakage </xsl:when>
			<xsl:otherwise> public </xsl:otherwise>
		</xsl:choose>
		<xsl:if test="@modifiers">
			<xsl:value-of select="' '" />
			<xsl:value-of select="@modifiers" />
			<xsl:value-of select="' '" />
		</xsl:if>
		<xsl:choose>
			<xsl:when test="@id"><span id="{@id}"><xsl:value-of select="@name" /></span></xsl:when>
			<xsl:otherwise><span id="{generate-id(.)}"><xsl:value-of select="@name" /></span></xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="@type">
				as
				<xsl:choose>
					<xsl:when test="@reference-to-type"><a href="#{@reference-to-type}" onclick="expandAncestors('{@reference-to-type}')"><xsl:value-of select="@type" /></a></xsl:when>
					<xsl:otherwise><xsl:value-of select="@type" /></xsl:otherwise>
				</xsl:choose>
			</xsl:when>
			<xsl:when test="@primitive">
				as
				<xsl:choose>
					<xsl:when test="@primitive = 'integer'"> integer </xsl:when>
					<xsl:when test="@primitive = 'real'"> real </xsl:when>
					<xsl:when test="@primitive = 'object'"> object </xsl:when>
					<xsl:when test="@primitive = 'character'"> character </xsl:when>
					<xsl:when test="@primitive = 'string'"> string </xsl:when>
					<xsl:when test="@primitive = 'natural'"> natural </xsl:when>
					<xsl:when test="@primitive = 'boolean'"> boolean </xsl:when>
					<xsl:when test="@primitive = 'class'"> class </xsl:when>
				</xsl:choose>
			</xsl:when>
			<xsl:otherwise>
				<em class="comment"> { Warning : the type is not defined} </em>
			</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="variable">
				is ( 
				<xsl:apply-templates select="variable" />
				) 						
			</xsl:when>
			<xsl:when test="@value">
				is 
				<xsl:choose>
					<xsl:when test="@reference-to-value"><a href="#{@reference-to-value}" onclick="expandAncestors('{@reference-to-value}')"><xsl:value-of select="@value" /></a></xsl:when>
					<xsl:otherwise><xsl:value-of select="@value" /></xsl:otherwise>
				</xsl:choose>
			</xsl:when>
		</xsl:choose>
		<xsl:apply-templates select="annotations" mode="header" />
		<xsl:apply-templates select="." mode="association" />
		<xsl:if test="@purpose"><em class="comment"> { Purpose : <xsl:value-of select="@purpose" /> } </em></xsl:if>
		<xsl:if test="@description"><em class="comment"> { Description : <xsl:value-of select="@description" /> } </em></xsl:if>
	</xsl:template>	
	
	<!-- channel -->
	
	<xsl:template match="attributes/channels">
		<h4>Channels</h4>
		<ul class="attributes">
			<xsl:apply-templates select="channel" />
		</ul>
	</xsl:template>
	
	<xsl:template match="channel">
		<xsl:choose>
			<xsl:when test="@id">
				<li id="{@id}"><xsl:apply-templates select="." mode="content" /></li>			
			</xsl:when>
			<xsl:otherwise>
				<li id="{generate-id(.)}"><xsl:apply-templates select="." mode="content" /></li>			
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>	
	
	<xsl:template match="channel" mode="content">
		<xsl:value-of select="@name" />
		<xsl:choose>
			<xsl:when test="@type">
				as
				<xsl:choose>
					<xsl:when test="@reference-to-type"><a href="#{@reference-to-type}" onclick="expandAncestors('{@reference-to-type}')"><xsl:value-of select="@type" /></a></xsl:when>
					<xsl:otherwise><xsl:value-of select="@type" /></xsl:otherwise>
				</xsl:choose>
			</xsl:when>
			<xsl:when test="@primitive">
				as 
				<xsl:choose>
					<xsl:when test="@primitive = 'integer'"> integer</xsl:when>
					<xsl:when test="@primitive = 'real'"> real</xsl:when>
					<xsl:when test="@primitive = 'object'"> object</xsl:when>
					<xsl:when test="@primitive = 'character'"> character</xsl:when>
					<xsl:when test="@primitive = 'string'"> string</xsl:when>
					<xsl:when test="@primitive = 'natural'"> natural </xsl:when>
					<xsl:when test="@primitive = 'boolean'"> boolean</xsl:when>
					<xsl:when test="@primitive = 'class'"> class</xsl:when>
				</xsl:choose>
			</xsl:when>
			<xsl:otherwise>
				<em class="comment"> { Warning : the type is not defined} </em>
			</xsl:otherwise>
		</xsl:choose>		
		with 
		<xsl:choose>
			<xsl:when test="@reference-to-input"><a href="#{@reference-to-input}" onclick="expandAncestors('{@reference-to-input}')"><xsl:value-of select="@input" /></a></xsl:when>
			<xsl:otherwise><xsl:value-of select="@input" /></xsl:otherwise>
		</xsl:choose>
		as input thread and 
		<xsl:choose>
			<xsl:when test="@reference-to-output"><a href="#{@reference-to-output}" onclick="expandAncestors('{@reference-to-output}')"><xsl:value-of select="@output" /></a></xsl:when>
			<xsl:otherwise><xsl:value-of select="@output" /></xsl:otherwise>
		</xsl:choose>
		as output thread
		<xsl:if test="@description"><em class="comment"> { Description : <xsl:value-of select="@description" /> } </em></xsl:if>
	</xsl:template>
	
</xsl:stylesheet>