<?xml version="1.0" encoding="UTF-8"?>
<!-- Copyright (C) 2013 Oleh Radvanskyj -->
<xsl:stylesheet version="2.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xs="http://www.w3.org/2001/XMLSchema" xmlns:fn="http://www.w3.org/2005/xpath-functions">
	<xsl:output method="html" encoding="UTF-8" />

	<!-- parametrized types -->

	<xsl:template match="parameterized-types">
		<xsl:choose>
			<xsl:when test="count(parameterized-type) = 1"><h4>Parameterized type</h4></xsl:when>
			<xsl:otherwise><h4>Parameterized types</h4></xsl:otherwise>
		</xsl:choose>
		<ul class="attributes">
			<xsl:apply-templates select="parameterized-type" />
		</ul>
	</xsl:template>

	<xsl:template match="parameterized-type">
		<xsl:choose>
			<xsl:when test="@id">
				<li id="{@id}"><xsl:apply-templates select="." mode="content" /></li>
			</xsl:when>
			<xsl:otherwise>
				<li><xsl:apply-templates select="." mode="content" /></li>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	
	<xsl:template match="parameterized-type" mode="content">
		<xsl:value-of select="@name" /> 
		<xsl:if test="@type">
			<xsl:choose>
				<xsl:when test="@reference"> extends <a href="#{@reference}" onclick="expandAncestors('{@reference}')"><xsl:value-of select="@type" /></a></xsl:when>
				<xsl:otherwise> extends <xsl:value-of select="@type" /></xsl:otherwise>
			</xsl:choose>
		</xsl:if>
		<xsl:if test="@description">
			<em class="comment"> { Description : <xsl:value-of select="@description" /> } </em>
		</xsl:if>
	</xsl:template>

</xsl:stylesheet>