<?xml version="1.0" encoding="UTF-8"?>
<!-- Copyright (C) 2013 Oleh Radvanskyj -->
<xsl:stylesheet version="2.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xs="http://www.w3.org/2001/XMLSchema" xmlns:fn="http://www.w3.org/2005/xpath-functions">
	<xsl:output method="html" encoding="UTF-8" />
	
	<!-- associations and dependencies -->
	
	<xsl:template match="element | property" mode="association">
		<xsl:if test="@name-of-association and @type">
			<span class="association"> Association :
				<xsl:if test="@role-of-class">
					in role of <xsl:value-of select="@role-of-class" />
				</xsl:if>
				<xsl:value-of select="' '" />
				<xsl:value-of select="@name-of-association" />
				<xsl:value-of select="' '" />
				<xsl:value-of select="@cardinality" />
				<xsl:value-of select="' '" />
				<xsl:value-of select="@type" />
				<xsl:value-of select="' '" />
				<xsl:if test="@role-of-element">
					in role of <xsl:value-of select="@role-of-element" />
				</xsl:if>
			</span>
		</xsl:if>
	</xsl:template>
	
	<xsl:template match="attributes/associations">
		<h4 onclick="toggleTag('{generate-id(.)}')">Associations</h4>
		<ul id="{generate-id(.)}" class="attributes">
			<xsl:apply-templates select="association" />
		</ul>
	</xsl:template>
	
	<xsl:template match="attributes/dependencies">
		<h4 onclick="toggleTag('{generate-id(.)}')">Dependencies</h4>
		<ul id="{generate-id(.)}" class="attributes">
			<xsl:apply-templates select="dependency" />
		</ul>
	</xsl:template>
	
	<xsl:template match="association | dependency">
		<xsl:choose>
			<xsl:when test="@id">
				<li id="{@id}"><xsl:apply-templates select="." mode="content" /></li>
			</xsl:when>
			<xsl:otherwise>
				<li><xsl:apply-templates select="." mode="content" /></li>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	
	<xsl:template match="association" mode="content">
		<span class="association"><xsl:apply-templates select="." mode="innerContent" /></span>
	</xsl:template>
	
	<xsl:template match="dependency" mode="content">
		<span class="dependency"><xsl:apply-templates select="." mode="innerContent" /></span>
	</xsl:template>
	
	<xsl:template match="association | dependency" mode="innerContent">
		<!-- @qualifier in role of @role-of-class @name @cardinality @class in role of @role-of-element with assistance of intermediary @class-of-association -->
        <xsl:if test="@stereotype">
            ( <xsl:value-of select="@stereotype" /> )
        </xsl:if>
		<xsl:if test="@qualifier">
			<xsl:choose>
				<xsl:when test="@reference-to-qualifier"><a href="#{@reference-to-qualifier}"  onclick="expandAncestors('{@reference-to-qualifier}')"><xsl:value-of select="@qualifier" /></a></xsl:when>
				<xsl:otherwise><xsl:value-of select="@qualifier" /></xsl:otherwise>
			</xsl:choose>
		</xsl:if>
		<xsl:value-of select="' '" />
		<xsl:if test="@role-of-class">
			in role of <xsl:value-of select="@role-of-class" />
		</xsl:if>
		<xsl:value-of select="' '" />
		<xsl:value-of select="@name" />
		<xsl:value-of select="' '" />
		<xsl:value-of select="@cardinality" />
		<xsl:value-of select="' '" />
		<xsl:if test="@class">
			<xsl:choose>
				<xsl:when test="@reference-to-class"><a href="#{@reference-to-class}"  onclick="expandAncestors('{@reference-to-class}')"><xsl:value-of select="@class" /></a></xsl:when>
				<xsl:otherwise><xsl:value-of select="@class" /></xsl:otherwise>
			</xsl:choose>
		</xsl:if>
		<xsl:value-of select="' '" />
		<xsl:if test="@role-of-element">
			in role of 
			<xsl:choose>
				<xsl:when test="@reference-to-element"><a href="#{@reference-to-element}"  onclick="expandAncestors('{@reference-to-element}')"><xsl:value-of select="@role-of-element" /></a></xsl:when>
				<xsl:otherwise><xsl:value-of select="@role-of-element" /></xsl:otherwise>
			</xsl:choose>
		</xsl:if>
		<xsl:value-of select="' '" />
		<xsl:choose>
			<xsl:when test="local-name() = 'association'">
				<xsl:if test="@class-of-association">
					with assistance of intermediary 
					<xsl:choose>
						<xsl:when test="@reference-to-class-of-association"><a href="#{@reference-to-class-of-association}"  onclick="expandAncestors('{@reference-to-class-of-association}')"><xsl:value-of select="@class-of-association" /></a></xsl:when>
						<xsl:otherwise><xsl:value-of select="@class-of-association" /></xsl:otherwise>
					</xsl:choose>
				</xsl:if>
			</xsl:when>
			<xsl:otherwise>
				<xsl:if test="@class-of-dependency">
					with assistance of intermediary 
					<xsl:choose>
						<xsl:when test="@reference-to-class-of-dependency"><a href="#{@reference-to-class-of-dependency}"  onclick="expandAncestors('{@reference-to-class-of-dependency}')"><xsl:value-of select="@class-of-dependency" /></a></xsl:when>
						<xsl:otherwise><xsl:value-of select="@class-of-dependency" /></xsl:otherwise>
					</xsl:choose>
				</xsl:if>
			</xsl:otherwise>
		</xsl:choose>
		<xsl:if test="@description"><em class="comment"> { Description : <xsl:value-of select="@description" /> } </em></xsl:if>
	</xsl:template>

</xsl:stylesheet>