<?xml version="1.0" encoding="UTF-8"?>
<!-- Copyright (C) 2013 Oleh Radvanskyj -->
<xsl:stylesheet version="2.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xs="http://www.w3.org/2001/XMLSchema" xmlns:fn="http://www.w3.org/2005/xpath-functions">
	<xsl:output method="html" encoding="UTF-8" />
	
	<!-- shared constants -->

	<xsl:template match="constant" mode="shared_pools">
		<xsl:param name="id" required="yes" />
		<xsl:param name="reference" required="yes" />	
		<xsl:choose>
			<xsl:when test="$id">
				<li id="{$id}"><a href="#{$reference}"  onclick="expandAncestors('{$reference}')"> constant <xsl:apply-templates select="." mode="content" /></a></li>
			</xsl:when>
			<xsl:otherwise>
				<li><a href="#{$reference}"  onclick="expandAncestors('{$reference}')"> constant <xsl:apply-templates select="." mode="content" /></a></li>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>	

	<xsl:template match="enumeration-constant-element" mode="shared_pools">
		<xsl:param name="id" required="yes" />
		<xsl:param name="reference" required="yes" />	
		<xsl:choose>
			<xsl:when test="$id">
				<li id="{$id}"><a href="#{$reference}"  onclick="expandAncestors('{$reference}')"><xsl:apply-templates select="." mode="signature" /></a></li>
			</xsl:when>
			<xsl:otherwise>
				<li><a href="#{$reference}"  onclick="expandAncestors('{$reference}')"><xsl:apply-templates select="." mode="signature" /></a></li>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
			
	<xsl:template match="enumeration-constant-element" mode="signature">
		enumeration constant element
		<xsl:choose>
			<xsl:when test="@id"><span id="{@id}"><xsl:value-of select="@name" /></span></xsl:when>
			<xsl:otherwise><span id="{generate-id(.)}"><xsl:value-of select="@name" /></span></xsl:otherwise>
		</xsl:choose>
		<xsl:if test="constant">
			is ( 
			<xsl:apply-templates select="constant" />
			) 
		</xsl:if>
		<xsl:if test="@description"><em class="comment"> { Description : <xsl:value-of select="@description" /> } </em></xsl:if>
	</xsl:template>

	<!-- shared data -->
	
	<xsl:template match="variable" mode="shared_pools">
		<xsl:param name="id" required="yes" />
		<xsl:param name="reference" required="yes" />	
		<xsl:choose>
			<xsl:when test="$id">
				<li id="{$id}"><a href="#{$reference}"  onclick="expandAncestors('{$reference}')"> variable <xsl:apply-templates select="." mode="content" /></a></li>
			</xsl:when>
			<xsl:otherwise>
				<li><a href="#{$reference}"  onclick="expandAncestors('{$reference}')"> variable <xsl:apply-templates select="." mode="content" /></a></li>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>	

	<xsl:template match="element | property" mode="shared_pools">
		<xsl:param name="id" required="yes" />
		<xsl:param name="reference" required="yes" />	
		<xsl:choose>
			<xsl:when test="$id">
				<li id="{$id}"><a href="#{$reference}"  onclick="expandAncestors('{$reference}')"><xsl:apply-templates select="." mode="signature" /></a></li>
			</xsl:when>
			<xsl:otherwise>
				<li><a href="#{$reference}"  onclick="expandAncestors('{$reference}')"><xsl:apply-templates select="." mode="signature" /></a></li>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>	
	
	<xsl:template match="element | property" mode="signature">
		<xsl:choose>
			<xsl:when test="local-name() = 'element'"> element </xsl:when>
			<xsl:otherwise> property </xsl:otherwise>
		</xsl:choose>
		<xsl:value-of select="@name" />
		<xsl:choose>
			<xsl:when test="@type">
				as
				<xsl:choose>
					<xsl:when test="@reference-to-type"><a href="#{@reference-to-type}" onclick="expandAncestors('{@reference-to-type}')"><xsl:value-of select="@type" /></a></xsl:when>
					<xsl:otherwise><xsl:value-of select="@type" /></xsl:otherwise>
				</xsl:choose>
			</xsl:when>
			<xsl:when test="@primitive">
				as
				<xsl:choose>
					<xsl:when test="@primitive = 'integer'"> integer </xsl:when>
					<xsl:when test="@primitive = 'real'"> real </xsl:when>
					<xsl:when test="@primitive = 'object'"> object </xsl:when>
					<xsl:when test="@primitive = 'character'"> character </xsl:when>
					<xsl:when test="@primitive = 'string'"> string </xsl:when>
					<xsl:when test="@primitive = 'natural'"> natural </xsl:when>
					<xsl:when test="@primitive = 'boolean'"> boolean </xsl:when>
					<xsl:when test="@primitive = 'class'"> class </xsl:when>
				</xsl:choose>
			</xsl:when>
			<xsl:otherwise>
				<em class="comment"> { Warning : the type is not defined} </em>
			</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="variable">
				by default is ( 
				<xsl:apply-templates select="variable" />
				) 						
			</xsl:when>
			<xsl:when test="@value">
				by default is 
				<xsl:choose>
					<xsl:when test="@reference-to-value"><a href="#{@reference-to-value}" onclick="expandAncestors('{@reference-to-value}')"><xsl:value-of select="@value" /></a></xsl:when>
					<xsl:otherwise><xsl:value-of select="@value" /></xsl:otherwise>
				</xsl:choose>
			</xsl:when>
		</xsl:choose>
		<xsl:if test="@name-of-association and @type">
			<span class="association"> Assosiation : 
				<xsl:if test="@role-of-class">
					In role of <xsl:value-of select="@role-of-class" />
				</xsl:if>
				<xsl:value-of select="' '" />
				<xsl:value-of select="@name-of-association" />
				<xsl:value-of select="' '" />
				<xsl:value-of select="@cardinality" />
				<xsl:value-of select="' '" />
				<xsl:value-of select="@type" />
				<xsl:value-of select="' '" />
				<xsl:if test="@role-of-element">
					in role of <xsl:value-of select="@role-of-element" />
				</xsl:if>
			</span>
		</xsl:if>
		<xsl:if test="@purpose"><em class="comment"> { Purpose : <xsl:value-of select="@purpose" /> } </em></xsl:if>
		<xsl:if test="@description"><em class="comment"> { Description : <xsl:value-of select="@description" /> } </em></xsl:if>
	</xsl:template>
	
</xsl:stylesheet>