<?xml version="1.0" encoding="UTF-8"?>
<!-- Copyright (C) 2012 Oleh Radvanskyj -->
<xsl:stylesheet version="2.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xs="http://www.w3.org/2001/XMLSchema" xmlns:fn="http://www.w3.org/2005/xpath-functions">
    <xsl:output method="html" encoding="UTF-8" />

    <!-- realizes -->

    <xsl:template match="realizes">
        <li>
            <xsl:choose>
                <xsl:when test="@reference and @page and $out = 'file'">
                    <a href="{@page}#{@reference}"><xsl:value-of select="@pattern" /></a>
                </xsl:when>
                <xsl:when test="@reference and @document and $out = 'memory'">
                    <a href="{@document}#{@reference}"><xsl:value-of select="@pattern" /></a>
                </xsl:when>
                <xsl:when test="@reference">
                    <a href="#{@reference}" onclick="expandAncestors('{@reference}')"><xsl:value-of select="@pattern" /></a>
                </xsl:when>
                <xsl:otherwise>
                    <xsl:value-of select="@pattern" />
                </xsl:otherwise>
            </xsl:choose>
            <xsl:if test="@description"><em class="comment"> { Description : <xsl:value-of select="@description" /> } </em></xsl:if>
            <xsl:apply-templates select="." mode="parameters" />
        </li>
    </xsl:template>

    <xsl:template match="realizes" mode="parameters">
        <xsl:if test="pattern-parameter">
            <xsl:choose>
                <xsl:when test="count(pattern-parameter) = 1"> with parameter </xsl:when>
                <xsl:otherwise> with parameters </xsl:otherwise>
            </xsl:choose>
            <ul class="attributes">
                <xsl:apply-templates select="pattern-parameter" />
            </ul>
        </xsl:if>
    </xsl:template>

    <xsl:template match="pattern-parameter">
        <xsl:choose>
            <xsl:when test="@id"><li id="{@id}"><xsl:apply-templates select="." mode="content" /></li></xsl:when>
            <xsl:otherwise><li><xsl:apply-templates select="." mode="content" /></li></xsl:otherwise>
        </xsl:choose>
    </xsl:template>

    <xsl:template match="pattern-parameter" mode="content">
        <xsl:value-of select="@name" />
        <xsl:if test="@value">
            is
            <xsl:choose>
                <xsl:when test="@reference-to-value"><a href="#{@reference-to-value}" onclick="expandAncestors('{@reference-to-value}')"><xsl:value-of select="@value" /></a></xsl:when>
                <xsl:otherwise><xsl:value-of select="@value" /></xsl:otherwise>
            </xsl:choose>
        </xsl:if>
        <xsl:if test="@description"><em class="comment"> { Description : <xsl:value-of select="@description" /> } </em></xsl:if>
    </xsl:template>

</xsl:stylesheet>