<?xml version="1.0" encoding="UTF-8"?>
<!-- Copyright (C) 2013 Oleh Radvanskyj -->
<xsl:stylesheet version="2.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xs="http://www.w3.org/2001/XMLSchema" xmlns:fn="http://www.w3.org/2005/xpath-functions">
	<xsl:output method="html" encoding="UTF-8" />
	
	<!-- header of classes -->
	
	<xsl:template match="interface" mode="interface_header">
		<!-- <nobr> -->
			Interface : 
			<xsl:choose>
				<xsl:when test="@visibility = 'private'"> private </xsl:when>
				<xsl:when test="@visibility = 'public'"> public </xsl:when>
				<xsl:when test="@visibility = 'protected'"> protected </xsl:when>
				<xsl:when test="@visibility = 'package'"> package </xsl:when>		
			</xsl:choose>
			<xsl:if test="@modifiers"> 
				<xsl:value-of select="' '" />
				<xsl:value-of select="@modifiers" /> 
				<xsl:value-of select="' '" />
			</xsl:if>
			<xsl:if test="@package"> <xsl:value-of select="@package" /> :: </xsl:if>
			<xsl:value-of select="@name" />
			<wbr />
			<xsl:apply-templates select="." mode="header_implements" />
			<wbr />
			<xsl:apply-templates select="parameterized-types" mode="header" />
			<wbr />
			<xsl:apply-templates select="annotations" mode="header" />
		<!-- </nobr> -->
	</xsl:template>
	
	<xsl:template match="class" mode="class_header">
		<!-- <nobr> -->
			Class : 
			<xsl:choose>
				<xsl:when test="@visibility = 'private'"> private </xsl:when>
				<xsl:when test="@visibility = 'public'"> public </xsl:when>
				<xsl:when test="@visibility = 'protected'"> protected </xsl:when>
				<xsl:when test="@visibility = 'package'"> package </xsl:when>		
			</xsl:choose>
			<xsl:choose>
				<xsl:when test="@abstract = 'yes'"> abstract </xsl:when>
				<xsl:when test="@final = 'yes'"> final </xsl:when>
			</xsl:choose>
			<xsl:if test="@modifiers"> 
				<xsl:value-of select="' '" />
				<xsl:value-of select="@modifiers" /> 
				<xsl:value-of select="' '" />
			</xsl:if>
			<xsl:if test="@package"> <xsl:value-of select="@package" /> :: </xsl:if>
			<xsl:value-of select="@name" />
			<wbr />
			<xsl:apply-templates select="." mode="header_extends" />
			<wbr />
			<xsl:apply-templates select="." mode="header_implements" />
			<wbr />
			<xsl:apply-templates select="parameterized-types" mode="header" />
			<wbr />
			<xsl:apply-templates select="annotations" mode="header" />
		<!-- </nobr> -->
	</xsl:template>
	
	<xsl:template match="interface | class" mode="header_implements">
		<xsl:if test="implements">
			implements
			<xsl:for-each select="implements">
				<xsl:choose>
					<xsl:when test="@reference"><a href="#{@reference}" onclick="expandAncestors('{@reference}')"><xsl:value-of select="@interface" /></a></xsl:when>
					<xsl:otherwise><xsl:value-of select="@interface" /></xsl:otherwise>
				</xsl:choose>
				<xsl:if test="not(position() = last())"> , </xsl:if>
				<wbr />
			</xsl:for-each>
		</xsl:if>		
	</xsl:template>
	
	<xsl:template match="class" mode="header_extends">
		<xsl:if test="extends">
			extends 
			<xsl:for-each select="extends">
				<xsl:choose>
					<xsl:when test="@reference"><a href="#{@reference}" onclick="expandAncestors('{@reference}')"><xsl:value-of select="@superclass" /></a></xsl:when>
					<xsl:otherwise><xsl:value-of select="@superclass" /></xsl:otherwise>
				</xsl:choose>
				<xsl:if test="not(position() = last())"> , </xsl:if>
			</xsl:for-each>
		</xsl:if>	
	</xsl:template>
	
</xsl:stylesheet>