<?xml version="1.0" encoding="UTF-8"?>
<!-- Copyright (C) 2013 Oleh Radvanskyj -->
<xsl:stylesheet version="2.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xs="http://www.w3.org/2001/XMLSchema" xmlns:fn="http://www.w3.org/2005/xpath-functions">
	<xsl:output method="html" encoding="UTF-8" />
	
	<!-- common elements of header for classes and functions -->
	
	<xsl:template match="parameters" mode="header">
		(
		<xsl:for-each select="parameter">
			<xsl:choose>
				<xsl:when test="@modifier = 'input'"> input </xsl:when>
				<xsl:when test="@modifier = 'output'"> output </xsl:when>
				<xsl:when test="@modifier = 'mutable'"> mutable </xsl:when>
			</xsl:choose>
			<xsl:value-of select="@name" />
			<xsl:choose>
				<xsl:when test="@type">
					as
					<xsl:choose>
						<xsl:when test="@reference-to-type"><a href="#{@reference-to-type}" onclick="expandAncestors('{@reference-to-type}')"><xsl:value-of select="@type" /></a></xsl:when>
						<xsl:otherwise><xsl:value-of select="@type" /></xsl:otherwise>
					</xsl:choose>
				</xsl:when>
				<xsl:when test="@primitive"> 
					as 
					<xsl:choose>
						<xsl:when test="@primitive = 'integer'"> integer </xsl:when>
						<xsl:when test="@primitive = 'real'"> real </xsl:when>
						<xsl:when test="@primitive = 'object'"> object </xsl:when>
						<xsl:when test="@primitive = 'character'"> character </xsl:when>
						<xsl:when test="@primitive = 'string'"> string </xsl:when>
						<xsl:when test="@primitive = 'natural'"> natural </xsl:when>
						<xsl:when test="@primitive = 'boolean'"> boolean </xsl:when>
						<xsl:when test="@primitive = 'class'"> class </xsl:when>
					</xsl:choose>
				</xsl:when>
				<xsl:otherwise>	{ Warning : the type is not defined }	</xsl:otherwise>
			</xsl:choose>
			<xsl:if test="@value">
				by default is 
				<xsl:choose>
					<xsl:when test="@reference-to-value"><a href="#{@reference-to-value}" onclick="expandAncestors('{@reference-to-value}')"><xsl:value-of select="@value" /></a></xsl:when>
					<xsl:otherwise><xsl:value-of select="@value" /></xsl:otherwise>
				</xsl:choose>
			</xsl:if>
			<xsl:if test="not(position() = last())"> ; </xsl:if>
		</xsl:for-each>
		)		
	</xsl:template>
	
	<xsl:template match="returns" mode="header">
		as
		<xsl:choose>
			<xsl:when test="@type">
				<xsl:choose>
					<xsl:when test="@reference"><a href="#{@reference}" onclick="expandAncestors('{@reference}')"><xsl:value-of select="@type" /></a></xsl:when>
					<xsl:otherwise><xsl:value-of select="@type" /></xsl:otherwise>
				</xsl:choose> 
			</xsl:when>
			<xsl:when test="@primitive">
				<xsl:choose>
					<xsl:when test="@primitive = 'integer'"> integer </xsl:when>
					<xsl:when test="@primitive = 'real'"> real </xsl:when>
					<xsl:when test="@primitive = 'object'"> object </xsl:when>
					<xsl:when test="@primitive = 'character'"> character </xsl:when>
					<xsl:when test="@primitive = 'string'"> string </xsl:when>
					<xsl:when test="@primitive = 'natural'"> natural </xsl:when>
					<xsl:when test="@primitive = 'boolean'"> boolean </xsl:when>
					<xsl:when test="@primitive = 'class'"> class </xsl:when>
				</xsl:choose>
			</xsl:when>
			<xsl:otherwise>
				<em class="comment"> { Warning : the type is not defined } </em>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	
	<xsl:template match="parameterized-types" mode="header">
		parameterized by
		<xsl:for-each select="parameterized-type">
			<xsl:value-of select="@name" /> 
			<xsl:if test="@type">
				<xsl:choose>
					<xsl:when test="@reference"> extends <a href="#{@reference}" onclick="expandAncestors('{@reference}')"><xsl:value-of select="@type" /></a></xsl:when>
					<xsl:otherwise> extends <xsl:value-of select="@type" /></xsl:otherwise>
				</xsl:choose>
			</xsl:if>
			<xsl:if test="not(position() = last())"> , </xsl:if>
			<wbr />
		</xsl:for-each>		
	</xsl:template>
	
	<xsl:template match="throws" mode="header">
		throws 
		<xsl:for-each select="exception">
			<xsl:choose>
				<xsl:when test="@reference"><a href="#{@reference}" onclick="expandAncestors('{@reference}')"><xsl:value-of select="@type" /></a></xsl:when>
				<xsl:otherwise><xsl:value-of select="@type" /></xsl:otherwise>
			</xsl:choose>
			<xsl:if test="position() != last()"> , </xsl:if>
		</xsl:for-each>
	</xsl:template>
	
	<xsl:template match="annotations" mode="header">
		annotated as
		<xsl:for-each select="annotation">
			<xsl:choose>
				<xsl:when test="@reference"><a href="#{@reference}" onclick="expandAncestors('{@reference}')"><xsl:value-of select="@name" /></a></xsl:when>
				<xsl:otherwise><xsl:value-of select="@name" /></xsl:otherwise>
			</xsl:choose>
			<xsl:choose>
				<xsl:when test="annotation">
					is (
					<xsl:apply-templates select="annotation" />
					)
				</xsl:when>
				<xsl:when test="@value">
					is <xsl:value-of select="@value" />
				</xsl:when>
			</xsl:choose>
			<xsl:if test="position() != last()"> , </xsl:if>
		</xsl:for-each>
	</xsl:template>
	
</xsl:stylesheet>