<?xml version="1.0" encoding="UTF-8"?>
<!-- Copyright (C) 2012 Oleh Radvanskyj -->
<xsl:stylesheet version="2.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xs="http://www.w3.org/2001/XMLSchema" xmlns:fn="http://www.w3.org/2005/xpath-functions">
	<xsl:output method="html" encoding="UTF-8" />
	
	<!-- functions -->
	
	<xsl:template match="constructor">
		<xsl:choose>
			<xsl:when test="@id">	
				<h4 id="{@id}" onclick="toggleTag('{generate-id(.)}')"><xsl:apply-templates select="." mode="constructor_header" /></h4>
			</xsl:when>
			<xsl:otherwise> 
				<h4 id="{generate-id(.)}-header" onclick="toggleTag('{generate-id(.)}')"><xsl:apply-templates select="." mode="constructor_header" /></h4>
			</xsl:otherwise>
		</xsl:choose>
		<div id="{generate-id(.)}" style="display:none" class="indent">
			<xsl:apply-templates select="description" />
            <xsl:apply-templates select="."  mode="overview" />
			<xsl:apply-templates select="specification" />
			<xsl:apply-templates select="annotations" />
			<xsl:apply-templates select="parameterized-types" />
			<xsl:apply-templates select="parameters" />
			<xsl:apply-templates select="throws" />
			<xsl:apply-templates select="shared-pools" />
            <xsl:apply-templates select="contract" />
            <xsl:apply-templates select="capsules" />
			<xsl:apply-templates select="classes" />
			<xsl:apply-templates select="types" />
			<xsl:apply-templates select="constants" />
			<xsl:apply-templates select="data" />
			<xsl:apply-templates select="functions" />
            <xsl:apply-templates select="threads" />
			<xsl:apply-templates select="aspects" />
			<xsl:apply-templates select="sequences" />
			<xsl:apply-templates select="."  mode="algorithm" />
			<xsl:apply-templates select="diagrams" />
			<xsl:apply-templates select="test-procedures" />
		</div>			
	</xsl:template>

	<xsl:template match="destructor">
		<xsl:choose>
			<xsl:when test="@id">	
				<h4 id="{@id}" onclick="toggleTag('{generate-id(.)}')"><xsl:apply-templates select="." mode="destructor_header" /></h4>
			</xsl:when>
			<xsl:otherwise> 
				<h4 id="{generate-id(.)}-header" onclick="toggleTag('{generate-id(.)}')"><xsl:apply-templates select="." mode="destructor_header" /></h4>
			</xsl:otherwise>
		</xsl:choose>
		<div id="{generate-id(.)}" style="display:none" class="indent">
			<xsl:apply-templates select="description" />
            <xsl:apply-templates select="."  mode="overview" />
			<xsl:apply-templates select="specification" />
			<xsl:apply-templates select="annotations" />
			<xsl:apply-templates select="parameterized-types" />
			<xsl:apply-templates select="parameters" />
			<xsl:apply-templates select="throws" />
			<xsl:apply-templates select="shared-pools" />
            <xsl:apply-templates select="contract" />
            <xsl:apply-templates select="capsules" />
			<xsl:apply-templates select="classes" />
			<xsl:apply-templates select="types" />
			<xsl:apply-templates select="constants" />
			<xsl:apply-templates select="data" />
			<xsl:apply-templates select="functions" />
            <xsl:apply-templates select="threads" />
			<xsl:apply-templates select="aspects" />
			<xsl:apply-templates select="sequences" />
			<xsl:apply-templates select="."  mode="algorithm" />
			<xsl:apply-templates select="diagrams" />
			<xsl:apply-templates select="test-procedures" />
		</div>			
	</xsl:template>
	
	<xsl:template match="interface/method">
		<xsl:choose>
			<xsl:when test="@id">
				<li id="{@id}"><xsl:apply-templates select="." mode="method_header" /></li>
			</xsl:when>
			<xsl:otherwise>
				<li id="{generate-id(.)}-header"><xsl:apply-templates select="." mode="method_header" /></li>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>

	<xsl:template match="method">
		<xsl:choose>
			<xsl:when test="@id">	
				<h4 id="{@id}" onclick="toggleTag('{generate-id(.)}')"><xsl:apply-templates select="." mode="method_header" /></h4>
			</xsl:when>
			<xsl:otherwise> 
				<h4 id="{generate-id(.)}-header" onclick="toggleTag('{generate-id(.)}')"><xsl:apply-templates select="." mode="method_header" /></h4>
			</xsl:otherwise>
		</xsl:choose>
		<div id="{generate-id(.)}" style="display:none" class="indent">
			<xsl:apply-templates select="description" />
            <xsl:apply-templates select="."  mode="overview" />
			<xsl:apply-templates select="specification" />
			<xsl:apply-templates select="annotations" />
			<xsl:apply-templates select="parameterized-types" />
			<xsl:apply-templates select="parameters" />
			<xsl:apply-templates select="returns" />
			<xsl:apply-templates select="throws" />
			<xsl:apply-templates select="shared-pools" />
            <xsl:apply-templates select="contract" />
            <xsl:apply-templates select="capsules" />
			<xsl:apply-templates select="classes" />
			<xsl:apply-templates select="types" />
			<xsl:apply-templates select="constants" />
			<xsl:apply-templates select="data" />
			<xsl:apply-templates select="functions" />
            <xsl:apply-templates select="threads" />
			<xsl:apply-templates select="aspects" />
			<xsl:apply-templates select="sequences" />
			<xsl:apply-templates select="." mode="algorithm" />
			<xsl:apply-templates select="diagrams" />
			<xsl:apply-templates select="test-procedures" />
		</div>			
	</xsl:template>
	
	<xsl:template match="operator">
		<xsl:choose>
			<xsl:when test="@id">	
				<h4 id="{@id}" onclick="toggleTag('{generate-id(.)}')"><xsl:apply-templates select="." mode="operator_header" /></h4>
			</xsl:when>
			<xsl:otherwise> 
				<h4 id="{generate-id(.)}-header" onclick="toggleTag('{generate-id(.)}')"><xsl:apply-templates select="." mode="operator_header" /></h4>
			</xsl:otherwise>
		</xsl:choose>
		<div id="{generate-id(.)}" style="display:none" class="indent">
			<xsl:apply-templates select="description" />
            <xsl:apply-templates select="."  mode="overview" />
			<xsl:apply-templates select="specification" />
			<xsl:apply-templates select="annotations" />
			<xsl:apply-templates select="parameterized-types" />
			<xsl:apply-templates select="parameters" />
			<xsl:apply-templates select="returns" />
			<xsl:apply-templates select="throws" />
			<xsl:apply-templates select="shared-pools" />
            <xsl:apply-templates select="contract" />
            <xsl:apply-templates select="capsules" />
			<xsl:apply-templates select="classes" />
			<xsl:apply-templates select="types" />
			<xsl:apply-templates select="constants" />
			<xsl:apply-templates select="data" />
			<xsl:apply-templates select="functions" />
            <xsl:apply-templates select="threads" />
			<xsl:apply-templates select="aspects" />
			<xsl:apply-templates select="sequences" />
			<xsl:apply-templates select="."  mode="algorithm" />
			<xsl:apply-templates select="diagrams" />
			<xsl:apply-templates select="test-procedures" />
		</div>			
	</xsl:template>
	
	<xsl:template match="interface/thread">
		<xsl:choose>
			<xsl:when test="@id">
				<li id="{@id}"><xsl:apply-templates select="." mode="thread_header" /></li>
			</xsl:when>
			<xsl:otherwise>
				<li id="{generate-id(.)}-header"><xsl:apply-templates select="." mode="thread_header" /></li>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	
	<xsl:template match="thread" mode="inner_thread">
		<xsl:choose>
			<xsl:when test="@id">
				<h4 id="{@id}" onclick="toggleTag('{generate-id(.)}')"><xsl:apply-templates select="." mode="thread_header" /></h4>
			</xsl:when>
			<xsl:otherwise>
				<h4 id="{generate-id(.)}-header" onclick="toggleTag('{generate-id(.)}')"><xsl:apply-templates select="." mode="thread_header" /></h4>
			</xsl:otherwise>
		</xsl:choose>
		<xsl:apply-templates select="." mode="content" />
	</xsl:template>	
	
	<xsl:template match="thread" mode="content">
		<div id="{generate-id(.)}" style="display:none" class="indent">
			<xsl:apply-templates select="description" />
            <xsl:apply-templates select="."  mode="overview" />
			<xsl:apply-templates select="specification" />
			<xsl:apply-templates select="annotations" />
			<xsl:apply-templates select="shared-pools" />
            <xsl:apply-templates select="contract" />
            <xsl:apply-templates select="capsules" />
			<xsl:apply-templates select="classes" />
			<xsl:apply-templates select="types" />
			<xsl:apply-templates select="constants" />
			<xsl:apply-templates select="data" />
			<xsl:apply-templates select="functions" />
            <xsl:apply-templates select="threads" />
			<xsl:apply-templates select="aspects" />
			<xsl:apply-templates select="sequences" />
			<xsl:apply-templates select="."  mode="algorithm" />
			<xsl:apply-templates select="diagrams" />
		</div>	
	</xsl:template>
	
	<!-- inner functions -->

	<xsl:template match="function" mode="inner_function">
		<xsl:choose>
			<xsl:when test="@id">
				<h4 id="{@id}" onclick="toggleTag('{generate-id(.)}')"><xsl:apply-templates select="." mode="function_header" /></h4>
			</xsl:when>
			<xsl:otherwise>
				<h4 id="{generate-id(.)}-header" onclick="toggleTag('{generate-id(.)}')"><xsl:apply-templates select="." mode="function_header" /></h4>
			</xsl:otherwise>
		</xsl:choose>
		<xsl:apply-templates select="." mode="content" />
	</xsl:template>
	
	<xsl:template match="function" mode="content">
		<div id="{generate-id(.)}" style="display:none" class="indent">
			<xsl:apply-templates select="description" />
            <xsl:apply-templates select="."  mode="overview" />
			<xsl:apply-templates select="specification" />
			<xsl:apply-templates select="annotations" />
			<xsl:apply-templates select="parameterized-types" />
			<xsl:apply-templates select="parameters" />
			<xsl:apply-templates select="returns" />
			<xsl:apply-templates select="throws" />
			<xsl:apply-templates select="shared-pools" />
            <xsl:apply-templates select="contract" />
            <xsl:apply-templates select="capsules" />
			<xsl:apply-templates select="classes" />
			<xsl:apply-templates select="types" />
			<xsl:apply-templates select="constants" />
			<xsl:apply-templates select="data" />
			<xsl:apply-templates select="functions" />
            <xsl:apply-templates select="threads" />
			<xsl:apply-templates select="aspects" />
			<xsl:apply-templates select="sequences" />
			<xsl:apply-templates select="."  mode="algorithm" />
			<xsl:apply-templates select="diagrams" />		
			<xsl:apply-templates select="test-procedures" />
		</div>
	</xsl:template>
	
	<xsl:template match="test-procedure" mode="inner_test_procedure">
		<xsl:choose>
			<xsl:when test="@id">
				<h4 id="{@id}" onclick="toggleTag('{generate-id(.)}')"><xsl:apply-templates select="." mode="test_procedure_header" /></h4>
			</xsl:when>
			<xsl:otherwise>
				<h4 id="{generate-id(.)}-header" onclick="toggleTag('{generate-id(.)}')"><xsl:apply-templates select="." mode="test_procedure_header" /></h4>
			</xsl:otherwise>
		</xsl:choose>
		<xsl:apply-templates select="." mode="content" />
	</xsl:template>
	
	<xsl:template match="test-procedure" mode="content">
		<div id="{generate-id(.)}" style="display:none" class="indent">
			<xsl:apply-templates select="description" />
            <xsl:apply-templates select="."  mode="overview" />
			<xsl:apply-templates select="specification" />
			<xsl:apply-templates select="annotations" />
			<xsl:apply-templates select="parameterized-types" />
			<xsl:apply-templates select="parameters" />
			<xsl:apply-templates select="throws" />
			<xsl:apply-templates select="shared-pools" />
            <xsl:apply-templates select="contract" />
            <xsl:apply-templates select="capsules" />
			<xsl:apply-templates select="classes" />
			<xsl:apply-templates select="types" />
			<xsl:apply-templates select="constants" />
			<xsl:apply-templates select="data" />
			<xsl:apply-templates select="functions" />
            <xsl:apply-templates select="threads" />
			<xsl:apply-templates select="aspects" />
			<xsl:apply-templates select="sequences" />
			<xsl:apply-templates select="."  mode="algorithm" />
			<xsl:apply-templates select="diagrams" />
			<xsl:apply-templates select="test-procedures" />					
		</div>
	</xsl:template>

	<xsl:template match="functions">
		<h4 onclick="toggleGroup('{generate-id(.)}')">Functions</h4>
		<div id="{generate-id(.)}" class="indent" state="collapsed">
			<xsl:apply-templates select="function" />
		</div>
	</xsl:template>

    <xsl:template match="threads">
        <h4 onclick="toggleGroup('{generate-id(.)}')">Threads</h4>
        <div id="{generate-id(.)}" class="indent" state="collapsed">
            <xsl:apply-templates select="thread" />
        </div>
    </xsl:template>

    <xsl:template match="test-procedures">
		<h4 onclick="toggleGroup('{generate-id(.)}')">Test procedures</h4>
		<div id="{generate-id(.)}" class="indent" state="collapsed">
			<xsl:apply-templates select="test-procedure" />
		</div>
	</xsl:template>

	<xsl:template match="function">
		<xsl:apply-templates select="." mode="inner_function" />
	</xsl:template>

    <xsl:template match="thread">
        <xsl:apply-templates select="." mode="inner_thread" />
    </xsl:template>

    <xsl:template match="test-procedure">
		<xsl:apply-templates select="." mode="inner_test_procedure" />
	</xsl:template>	
	
	<!-- content of functions -->
	
	<xsl:template match="function/description | test-procedure/description | constructor/description | destructor/description | method/description | operator/description | thread/description">
		<h4>Description</h4>
		<div class="indent"><xsl:apply-templates /></div>
	</xsl:template>

	<xsl:template match="parameters">
		<h4>Parameters</h4>
		<ul class="attributes"><xsl:apply-templates select="parameter" /></ul>
	</xsl:template>

	<xsl:template match="parameter">
		<xsl:choose>
			<xsl:when test="@id">
				<li id="{@id}"><xsl:apply-templates select="." mode="content" /></li>
			</xsl:when>
			<xsl:otherwise>
				<li><xsl:apply-templates select="." mode="content" /></li>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	
	<xsl:template match="parameter" mode="content">
		<xsl:choose>
			<xsl:when test="@modifier = 'input'"> input </xsl:when>
			<xsl:when test="@modifier = 'output'"> output </xsl:when>
			<xsl:when test="@modifier = 'mutable'"> mutable </xsl:when>
		</xsl:choose>
		<xsl:value-of select="@name" />
		<xsl:choose>
			<xsl:when test="@type">
				as
				<xsl:choose>
					<xsl:when test="@reference-to-type"><a href="#{@reference-to-type}" onclick="expandAncestors('{@reference-to-type}')"><xsl:value-of select="@type" /></a></xsl:when>
					<xsl:otherwise><xsl:value-of select="@type" /></xsl:otherwise>
				</xsl:choose>
			</xsl:when>
			<xsl:when test="@primitive"> 
				as 
				<xsl:choose>
					<xsl:when test="@primitive = 'integer'"> integer </xsl:when>
					<xsl:when test="@primitive = 'real'"> real </xsl:when>
					<xsl:when test="@primitive = 'object'"> object </xsl:when>
					<xsl:when test="@primitive = 'character'"> character </xsl:when>
					<xsl:when test="@primitive = 'string'"> string </xsl:when>
					<xsl:when test="@primitive = 'natural'"> natural </xsl:when>
					<xsl:when test="@primitive = 'boolean'"> boolean </xsl:when>
					<xsl:when test="@primitive = 'class'"> class </xsl:when>
				</xsl:choose>
			</xsl:when>
			<xsl:otherwise>
				<em class="comment"> { Warning : the type is not defined} </em>
			</xsl:otherwise>
		</xsl:choose>
		<xsl:if test="@value">
			by default is 
			<xsl:choose>
				<xsl:when test="@reference-to-value"><a href="#{@reference-to-value}" onclick="expandAncestors('{@reference-to-value}')"><xsl:value-of select="@value" /></a></xsl:when>
				<xsl:otherwise><xsl:value-of select="@value" /></xsl:otherwise>
			</xsl:choose>
		</xsl:if>
		<xsl:if test="@description"><em class="comment"> { Description : <xsl:value-of select="@description" /> } </em></xsl:if>
	</xsl:template>

	<xsl:template match="returns">
		<h4>Returns</h4>
		<div class="indent">
			<xsl:choose>
				<xsl:when test="@type">
					<xsl:choose>
						<xsl:when test="@reference"><a href="#{@reference}" onclick="expandAncestors('{@reference}')"><xsl:value-of select="@type" /></a></xsl:when>
						<xsl:otherwise><xsl:value-of select="@type" /></xsl:otherwise>
					</xsl:choose> 
				</xsl:when>
				<xsl:when test="@primitive">
					<xsl:choose>
						<xsl:when test="@primitive = 'integer'"> integer </xsl:when>
						<xsl:when test="@primitive = 'real'"> real </xsl:when>
						<xsl:when test="@primitive = 'object'"> object </xsl:when>
						<xsl:when test="@primitive = 'character'"> character </xsl:when>
						<xsl:when test="@primitive = 'string'"> string </xsl:when>
						<xsl:when test="@primitive = 'natural'"> natural </xsl:when>
						<xsl:when test="@primitive = 'boolean'"> boolean </xsl:when>
						<xsl:when test="@primitive = 'class'"> class </xsl:when>
					</xsl:choose>
				</xsl:when>
				<xsl:otherwise>
					<em class="comment"> { Warning : the type is not defined } </em>
				</xsl:otherwise>
			</xsl:choose>
			<xsl:if test="@description"><em class="comment"> { Description : <xsl:value-of select="@description" /> } </em></xsl:if>
		</div>
	</xsl:template>
	
	<xsl:template match="throws">
		<h4>Throws</h4>
		<ul class="attributes">
			<xsl:apply-templates select="exception" />
		</ul>
	</xsl:template>
	
	<xsl:template match="exception">
		<xsl:choose>
			<xsl:when test="@id">
				<li id="{@id}">
					<xsl:choose>
						<xsl:when test="@reference"><a href="#{@reference}" onclick="expandAncestors('{@reference}')"><xsl:value-of select="@type" /></a></xsl:when>
						<xsl:otherwise><xsl:value-of select="@type" /></xsl:otherwise>
					</xsl:choose>
					<xsl:if test="@cases-of-throw"><span class="comment"> Cases of throw : <xsl:value-of select="@cases-of-throw" /></span></xsl:if>
					<xsl:if test="@description"><em class="comment"> { Description : <xsl:value-of select="@description" /> } </em></xsl:if>
				</li>
			</xsl:when>
			<xsl:otherwise>
				<li>
					<xsl:choose>
						<xsl:when test="@reference"><a href="#{@reference}" onclick="expandAncestors('{@reference}')"><xsl:value-of select="@type" /></a></xsl:when>
						<xsl:otherwise><xsl:value-of select="@type" /></xsl:otherwise>
					</xsl:choose>
					<xsl:if test="@cases-of-throw"><span class="cases-of-throw"> Throws when : <xsl:value-of select="@cases-of-throw" /></span></xsl:if>
					<xsl:if test="@description"><em class="comment"> { Description : <xsl:value-of select="@description" /> } </em></xsl:if>
				</li>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>

</xsl:stylesheet>
