<?xml version="1.0" encoding="UTF-8"?>
<!-- Copyright (C) 2013 Oleh Radvanskyj -->
<xsl:stylesheet version="2.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xs="http://www.w3.org/2001/XMLSchema" xmlns:fn="http://www.w3.org/2005/xpath-functions">
	<xsl:output method="html" encoding="UTF-8" />
	
	<!-- specification -->
	
	<xsl:template match="specification">
		<h4 id="{generate-id(.)}-header" onclick="toggleSpecification('{generate-id(.)}')">Specification</h4>
		<ol id="{generate-id(.)}" state="hidden" class="specification" style="display:none">
			<xsl:apply-templates />
		</ol>
	</xsl:template>
	
	<xsl:template match="specification/specification">
		<li>
			<xsl:choose>
				<xsl:when test="@name">
					<span id="{generate-id(.)}-header"><a href="javascript:expandSpecificationPackage('{generate-id(.)}')"> 
						Specification : <xsl:value-of select="@name" />
					</a></span> 
					<ol id="{generate-id(.)}-body" style="display:none">
						<xsl:apply-templates />
					</ol>
				</xsl:when>
				<xsl:otherwise>
					<ol><xsl:apply-templates /></ol>
				</xsl:otherwise>
			</xsl:choose>
		</li>	
	</xsl:template>
	
	<xsl:template match="assumption">
		<li><xsl:apply-templates /></li>
	</xsl:template>
	
</xsl:stylesheet>