<?xml version="1.0" encoding="UTF-8"?>
<!-- Copyright (C) 2012 Oleh Radvanskyj -->
<xsl:stylesheet version="2.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xs="http://www.w3.org/2001/XMLSchema" xmlns:fn="http://www.w3.org/2005/xpath-functions">
	<xsl:output method="html" encoding="UTF-8" />
	
	<!-- gui -->

	<!-- top level -->
	
	<xsl:template match="solution | implementation | model | common-view | view" mode="table_of_contents_gui">
		<xsl:if test="gui">
			<li><a href="#{generate-id(gui)}" onclick="expandAncestors('{generate-id(gui)}')">GUI</a>
				<ul>
					<xsl:for-each select="gui/screen">
						<li>
							<xsl:choose>
								<xsl:when test="@id"><a href="#{@id}" onclick="expandAncestors('{@id}')"><xsl:value-of select="@name" /></a></xsl:when>
								<xsl:otherwise><a href="#{generate-id(.)}-header" onclick="expandAncestors('{generate-id(.)}-header')"><xsl:value-of select="@name" /></a></xsl:otherwise>
							</xsl:choose>
						</li>
					</xsl:for-each>
				</ul>
			</li>
		</xsl:if>
	</xsl:template>
	  
  <xsl:template match="solution/gui | implementation/gui | model/gui">
	<h2 id="{generate-id(.)}">GUI</h2>
	<xsl:apply-templates select="screen" />
  </xsl:template>
  
  <xsl:template match="solution/gui/screen | implementation/gui/screen | model/gui/screen | model/use-case/declaration/gui/screen">
	  <xsl:choose>
		<xsl:when test="@id"><h3 id="{@id}" onclick="toggleTag('{generate-id(.)}')"><xsl:value-of  select="@name" /></h3></xsl:when>
		<xsl:otherwise><h3 id="{generate-id(.)}-header" onclick="toggleTag('{generate-id(.)}')"><xsl:value-of  select="@name" /></h3></xsl:otherwise>
	  </xsl:choose>
	  <div id="{generate-id(.)}">
		  <img alt="{@name}" src="{@image}" style="float:left; padding-right:10px" />
		  <div style="display:inline">
			  <xsl:apply-templates />
		  </div>
		  <br style="clear:left" />
	  </div>
  </xsl:template>
	
	<!-- level of package -->
	
	<xsl:template match="package | declaration" mode="table_of_contents_gui">
		<xsl:if test="gui">
			<li>GUI
				<ul>
					<xsl:for-each select="gui/screen">
						<li>
							<xsl:choose>
								<xsl:when test="@id"><a href="#{@id}" onclick="expandAncestors('{@id}')"><xsl:value-of select="@name" /></a></xsl:when>
								<xsl:otherwise><a href="#{generate-id(.)}-header" onclick="expandAncestors('{generate-id(.)}-header')"><xsl:value-of select="@name" /></a></xsl:otherwise>
							</xsl:choose>
						</li>
					</xsl:for-each>
				</ul>
			</li>
		</xsl:if>
	</xsl:template>

	<xsl:template match="gui">
		<xsl:apply-templates select="screen" />
	</xsl:template>
	
	<xsl:template match="screen">
		<xsl:choose>
			<xsl:when test="@id"><h4 id="{@id}" onclick="toggleTag('{generate-id(.)}')">Screen : <xsl:value-of select="@name" /></h4></xsl:when>
			<xsl:otherwise><h4 id="{generate-id(.)}-header" onclick="toggleTag('{generate-id(.)}')">Screen : <xsl:value-of select="@name" /></h4></xsl:otherwise>
		</xsl:choose>
		<div id="{generate-id(.)}">
		  <img alt="{@name}" src="{@image}" style="float:left; padding-right:10px" />
		  <div style="display:inline">
			  <xsl:apply-templates />
		  </div>
		  <br style="clear:left" />
		</div>	
	</xsl:template>

</xsl:stylesheet>
