<?xml version="1.0" encoding="UTF-8"?>
<!-- Copyright (C) 2012 Oleh Radvanskyj -->
<xsl:stylesheet version="2.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xs="http://www.w3.org/2001/XMLSchema" xmlns:fn="http://www.w3.org/2005/xpath-functions">
	<xsl:output method="html" encoding="UTF-8" />
 
	<!-- html tags -->
	
	<!-- pre -->
	<xsl:template match="pre"><pre style="{@style}" class="{@class}" lang="{@lang}" dir="{@dir}" title="{@title}" id="{@id}"><xsl:apply-templates /></pre></xsl:template>
	<!-- br -->
	<xsl:template match="br"><br style="{@style}" class="{@class}" clear="{@clear}" id="{@id}"  /></xsl:template>
	<!-- p -->
	<xsl:template match="p"><p style="{@style}" class="{@class}" lang="{@lang}" dir="{@dir}" title="{@title}" id="{@id}"><xsl:apply-templates /></p></xsl:template>
	<!-- em -->
	<xsl:template match="em"><em style="{@style}" class="{@class}" lang="{@lang}" dir="{@dir}" title="{@title}" id="{@id}"><xsl:apply-templates /></em></xsl:template>
	<!-- ol -->
	<xsl:template match="ol"><ol style="{@style}" class="{@class}" lang="{@lang}" dir="{@dir}" title="{@title}" id="{@id}"><xsl:apply-templates /></ol></xsl:template>
	<!-- ul -->
	<xsl:template match="ul"><ul style="{@style}" class="{@class}" lang="{@lang}" dir="{@dir}" title="{@title}" id="{@id}"><xsl:apply-templates /></ul></xsl:template>
	<!-- li -->
	<xsl:template match="li"><li style="{@style}" class="{@class}" lang="{@lang}" dir="{@dir}" title="{@title}" id="{@id}"><xsl:apply-templates /></li></xsl:template>
	<!-- dl -->
	<xsl:template match="dl"><dl style="{@style}" class="{@class}" lang="{@lang}" dir="{@dir}" title="{@title}" id="{@id}"><xsl:apply-templates /></dl></xsl:template>
	<!-- dt -->
	<xsl:template match="dt"><dt style="{@style}" class="{@class}" lang="{@lang}" dir="{@dir}" title="{@title}" id="{@id}"><xsl:apply-templates /></dt></xsl:template>
	<!-- dd -->
	<xsl:template match="dd"><dd style="{@style}" class="{@class}" lang="{@lang}" dir="{@dir}" title="{@title}" id="{@id}"><xsl:apply-templates /></dd></xsl:template>
	<!-- img -->
	<xsl:template match="img"><img style="{@style}" class="{@class}" src="{@src}" width="{@width}" height="{@height}" alt="{@alt}" align="{@align}" title="{@title}" /></xsl:template>
	<!-- table -->
	<xsl:template match="table"><table style="{@style}" class="{@class}" lang="{@lang}" dir="{@dir}" title="{@title}" id="{@id}" cellpadding="{@cellpadding}" cellspacing="{@cellspacing}" summary="{@summary}" border="{@border}"><xsl:apply-templates /></table></xsl:template>
	<!-- thead -->
	<xsl:template match="thead"><thead style="{@style}" class="{@class}" lang="{@lang}" dir="{@dir}" title="{@title}" id="{@id}" align="{@align}" valign="{@valign}"><xsl:apply-templates /></thead></xsl:template>
	<!-- tbody -->
	<xsl:template match="tbody"><tbody style="{@style}" class="{@class}" lang="{@lang}" dir="{@dir}" title="{@title}" id="{@id}" align="{@align}" valign="{@valign}"><xsl:apply-templates /></tbody></xsl:template>
	<!-- tfoot -->
	<xsl:template match="tfoot"><tfoot style="{@style}" class="{@class}" lang="{@lang}" dir="{@dir}" title="{@title}" id="{@id}" align="{@align}" valign="{@valign}"><xsl:apply-templates /></tfoot></xsl:template>
	<!-- tr -->
	<xsl:template match="tr"><tr style="{@style}" class="{@class}" lang="{@lang}" dir="{@dir}" title="{@title}" id="{@id}"><xsl:apply-templates /></tr></xsl:template>
	<!-- th -->
	<xsl:template match="th"><th style="{@style}" class="{@class}" lang="{@lang}" dir="{@dir}" title="{@title}" id="{@id}" align="{@align}" valign="{@valign}" colspan="{@colspan}" rowspan="{@rowspan}"><xsl:apply-templates /></th></xsl:template>
	<!-- td -->
	<xsl:template match="td"><td style="{@style}" class="{@class}" lang="{@lang}" dir="{@dir}" title="{@title}" id="{@id}" align="{@align}" valign="{@valign}" colspan="{@colspan}" rowspan="{@rowspan}"><xsl:apply-templates /></td></xsl:template>
	<!-- div -->
	<xsl:template match="div"><div style="{@style}" class="{@class}" lang="{@lang}" dir="{@dir}" title="{@title}" id="{@id}"><xsl:apply-templates /></div></xsl:template>
	<!-- span -->
	<xsl:template match="span"><span style="{@style}" class="{@class}" lang="{@lang}" dir="{@dir}" title="{@title}" id="{@id}"><xsl:apply-templates /></span></xsl:template>
	<!-- a -->
	<xsl:template match="a"><a href="{@href}" style="{@style}" class="{@class}" lang="{@lang}" dir="{@dir}" title="{@title}" id="{@id}"><xsl:apply-templates /></a></xsl:template>
	<!-- acronym -->
	<xsl:template match="acronym"><acronym style="{@style}" class="{@class}" lang="{@lang}" dir="{@dir}" title="{@title}" id="{@id}"><xsl:apply-templates /></acronym></xsl:template>
	<!-- address -->
	<xsl:template match="address"><address style="{@style}" class="{@class}" lang="{@lang}" dir="{@dir}" title="{@title}" id="{@id}"><xsl:apply-templates /></address></xsl:template>
	<!-- blockquote -->
	<xsl:template match="span"><blockquote style="{@style}" class="{@class}" lang="{@lang}" dir="{@dir}" title="{@title}" id="{@id}" cite="{@cite}"><xsl:apply-templates /></blockquote></xsl:template>
	<!-- caption -->
	<xsl:template match="caption"><caption style="{@style}" class="{@class}" lang="{@lang}" dir="{@dir}" title="{@title}" id="{@id}" align="{@align}"><xsl:apply-templates /></caption></xsl:template>	
	<!-- cite -->
	<xsl:template match="cite"><cite style="{@style}" class="{@class}" lang="{@lang}" dir="{@dir}" title="{@title}" id="{@id}"><xsl:apply-templates /></cite></xsl:template>
	<!-- code -->
	<xsl:template match="code"><code style="{@style}" class="{@class}" lang="{@lang}" dir="{@dir}" title="{@title}" id="{@id}"><xsl:apply-templates /></code></xsl:template>	
	<!-- del -->
	<xsl:template match="del"><del style="{@style}" class="{@class}" lang="{@lang}" dir="{@dir}" title="{@title}" id="{@id}" cite="{@cite}" datetime="{@datetime}"><xsl:apply-templates /></del></xsl:template>		
	<!-- dfn -->
	<xsl:template match="dfn"><dfn style="{@style}" class="{@class}" lang="{@lang}" dir="{@dir}" title="{@title}" id="{@id}"><xsl:apply-templates /></dfn></xsl:template>		
	<!-- h5 -->
	<xsl:template match="h5"><h5 style="{@style}" class="{@class}" lang="{@lang}" dir="{@dir}" title="{@title}" id="{@id}"><xsl:apply-templates /></h5></xsl:template>		
	<!-- h6 -->
	<xsl:template match="h6"><h6 style="{@style}" class="{@class}" lang="{@lang}" dir="{@dir}" title="{@title}" id="{@id}"><xsl:apply-templates /></h6></xsl:template>		
	<!-- hr -->
	<xsl:template match="hr"><hr style="{@style}" class="{@class}" id="{@id}"  /></xsl:template>
	<!-- ins -->
	<xsl:template match="ins"><ins style="{@style}" class="{@class}" lang="{@lang}" dir="{@dir}" title="{@title}" id="{@id}" cite="{@cite}" datetime="{@datetime}"><xsl:apply-templates /></ins></xsl:template>		
	<!-- h5 -->
	<xsl:template match="kdb"><kdb style="{@style}" class="{@class}" lang="{@lang}" dir="{@dir}" title="{@title}" id="{@id}"><xsl:apply-templates /></kdb></xsl:template>			
	<!-- nobr -->
	<xsl:template match="nobr"><nobr style="{@style}" class="{@class}" id="{@id}"><xsl:apply-templates /></nobr></xsl:template>	
	<!-- q -->
	<xsl:template match="q"><q style="{@style}" class="{@class}" lang="{@lang}" dir="{@dir}" title="{@title}" id="{@id}" cite="{@cite}"><xsl:apply-templates /></q></xsl:template>	
	<!-- samp -->
	<xsl:template match="samp"><samp style="{@style}" class="{@class}" lang="{@lang}" dir="{@dir}" title="{@title}" id="{@id}"><xsl:apply-templates /></samp></xsl:template>	
	<!-- strong -->
	<xsl:template match="strong"><strong style="{@style}" class="{@class}" lang="{@lang}" dir="{@dir}" title="{@title}" id="{@id}"><xsl:apply-templates /></strong></xsl:template>		
	<!-- sub -->
	<xsl:template match="sub"><sub style="{@style}" class="{@class}" lang="{@lang}" dir="{@dir}" title="{@title}" id="{@id}"><xsl:apply-templates /></sub></xsl:template>		
	<!-- sup -->
	<xsl:template match="sup"><sup style="{@style}" class="{@class}" lang="{@lang}" dir="{@dir}" title="{@title}" id="{@id}"><xsl:apply-templates /></sup></xsl:template>			
	<!-- var -->
	<xsl:template match="var"><var style="{@style}" class="{@class}" lang="{@lang}" dir="{@dir}" title="{@title}" id="{@id}"><xsl:apply-templates /></var></xsl:template>		
	<!-- wbr -->
	<xsl:template match="wbr"><wbr style="{@style}" class="{@class}" id="{@id}"  /></xsl:template>


    <!-- anchor -->

    <xsl:template match="anchor">
        <xsl:choose>
            <xsl:when test="$out = 'file'"><a href="{@page}#{@reference}"><xsl:apply-templates /></a></xsl:when>
            <xsl:otherwise><a href="{@document}#{@reference}"><xsl:apply-templates /></a></xsl:otherwise>
        </xsl:choose>
    </xsl:template>
	
</xsl:stylesheet>
