<?xml version="1.0" encoding="UTF-8"?>
<!-- Copyright (C) 2014 Oleh Radvanskyj -->
<xsl:stylesheet version="2.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xs="http://www.w3.org/2001/XMLSchema" xmlns:fn="http://www.w3.org/2005/xpath-functions">
    <xsl:output method="html" encoding="UTF-8" />

    <!-- attributes overview -->

    <xsl:template match="class" mode="overview_attributes">
        <!-- ASDA -->
        <xsl:variable name="canPerformASDA1" select="class-protocol/attributes/elements" />
        <xsl:variable name="canPerformASDA2" select="instance-protocol/attributes/elements" />
        <xsl:variable name="canPerformASDA3" select=".//feature/class-protocol/attributes/elements" />
        <xsl:variable name="canPerformASDA4" select=".//feature/instance-protocol/attributes/elements" />
        <xsl:variable name="canPerformASDA5" select="class-protocol/attributes/properties" />
        <xsl:variable name="canPerformASDA6" select="instance-protocol/attributes/properties" />
        <xsl:variable name="canPerformASDA7" select=".//feature/class-protocol/attributes/properties" />
        <xsl:variable name="canPerformASDA8" select=".//feature/instance-protocol/attributes/properties" />
        <xsl:variable name="canPerformASDA" select="$canPerformASDA1 or $canPerformASDA2 or $canPerformASDA3 or $canPerformASDA4 or $canPerformASDA5 or $canPerformASDA6 or $canPerformASDA7 or $canPerformASDA8" />
        <!-- ASD -->
        <xsl:variable name="canPerformASD1" select="class-protocol/attributes/elements/element/@description" />
        <xsl:variable name="canPerformASD2" select="instance-protocol/attributes/elements/element/@description" />
        <xsl:variable name="canPerformASD3" select=".//feature/class-protocol/attributes/elements/element/@description" />
        <xsl:variable name="canPerformASD4" select=".//feature/instance-protocol/attributes/elements/element/@description" />
        <xsl:variable name="canPerformASD5" select="class-protocol/attributes/properties/property/@description" />
        <xsl:variable name="canPerformASD6" select="instance-protocol/attributes/properties/property/@description" />
        <xsl:variable name="canPerformASD7" select=".//feature/class-protocol/attributes/properties/property/@description" />
        <xsl:variable name="canPerformASD8" select=".//feature/instance-protocol/attributes/properties/property/@description" />
        <xsl:variable name="canPerformASD" select="$canPerformASD1 or $canPerformASD2 or $canPerformASD3 or $canPerformASD4 or $canPerformASD5 or $canPerformASD6 or $canPerformASD7 or $canPerformASD8" />
        <!-- ASA -->
        <xsl:variable name="canPerformASA1" select="class-protocol/attributes/elements/element/@type and class-protocol/attributes/elements/element/@name-of-association" />
        <xsl:variable name="canPerformASA2" select="instance-protocol/attributes/elements/element/@type and instance-protocol/attributes/elements/element/@name-of-association" />
        <xsl:variable name="canPerformASA3" select=".//feature/class-protocol/attributes/elements/element/@type and .//feature/class-protocol/attributes/elements/element/@name-of-association" />
        <xsl:variable name="canPerformASA4" select=".//feature/instance-protocol/attributes/elements/element/@type and .//feature/instance-protocol/attributes/elements/element/@name-of-association" />
        <xsl:variable name="canPerformASA5" select="class-protocol/attributes/properties/property/@type and class-protocol/attributes/properties/property/@name-of-association" />
        <xsl:variable name="canPerformASA6" select="instance-protocol/attributes/properties/property/@type and instance-protocol/attributes/properties/property/@name-of-association" />
        <xsl:variable name="canPerformASA7" select=".//feature/class-protocol/attributes/properties/property/@type and .//feature/class-protocol/attributes/properties/property/@name-of-association" />
        <xsl:variable name="canPerformASA8" select=".//feature/instance-protocol/attributes/properties/property/@type and .//feature/instance-protocol/attributes/properties/property/@name-of-association" />
        <xsl:variable name="canPerformASA" select="$canPerformASA1 or $canPerformASA2 or $canPerformASA3 or $canPerformASA4 or $canPerformASA5 or $canPerformASA6 or $canPerformASA7 or $canPerformASA8" />
        <xsl:if test="$canPerformASDA">
            <table class="overview">
                <caption>Attribute - Signature
                    <xsl:if test="$canPerformASA">	/ Association </xsl:if>
                    <xsl:if test="$canPerformASD"> / Description </xsl:if>
                </caption>
                <thead>
                    <tr>
                        <th>Name</th>
                        <th>Signature
                            <xsl:if test="$canPerformASA">	/ Association </xsl:if>
                            <xsl:if test="$canPerformASD"> / Description </xsl:if>
                        </th>
                    </tr>
                </thead>
                <tbody>
                    <xsl:apply-templates select="feature" mode="asda" />
                    <xsl:apply-templates select="class-protocol/attributes/elements/." mode="asda"/>
                    <xsl:apply-templates select="class-protocol/attributes/properties/." mode="asda"/>
                    <xsl:apply-templates select="instance-protocol/attributes/elements/." mode="asda" />
                    <xsl:apply-templates select="instance-protocol/attributes/properties/." mode="asda" />
                </tbody>
            </table>
        </xsl:if>
    </xsl:template>

    <!-- Attribute - Signature / Association / Description -->

    <xsl:template match="feature" mode="asda">
        <xsl:apply-templates select="feature" mode="asda" />
        <xsl:apply-templates select="class-protocol/attributes/elements/." mode="asda"/>
        <xsl:apply-templates select="class-protocol/attributes/properties/." mode="asda"/>
        <xsl:apply-templates select="instance-protocol/attributes/elements/." mode="asda" />
        <xsl:apply-templates select="instance-protocol/attributes/properties/." mode="asda" />
    </xsl:template>

    <xsl:template match="element | property" mode="asda">
        <tr>
            <td>
                <xsl:choose>
                    <xsl:when test="@id">
                        <a href="#{@id}" onclick="expandAncestors('{@id}')"><xsl:apply-templates select="." mode="asda_name" /></a>
                    </xsl:when>
                    <xsl:otherwise>
                        <a href="#{generate-id(.)}" onclick="expandAncestors('{generate-id(.)}')"><xsl:apply-templates select="." mode="asda_name" /></a>
                    </xsl:otherwise>
                </xsl:choose>
            </td>
            <td>
                <dl>
                    <dt class="asda_signature">
                        <xsl:apply-templates select="." mode="short_signature" />
                    </dt>
                    <xsl:if test="@type and @name-of-association">
                        <dd class="asda_association">
                            <xsl:if test="@role-of-class">
                                In role of <xsl:value-of select="@role-of-class" />
                            </xsl:if>
                            <xsl:value-of select="' '" />
                            <xsl:value-of select="@name-of-association" />
                            <xsl:value-of select="' '" />
                            <xsl:value-of select="@cardinality" />
                            <xsl:value-of select="' '" />
                            <xsl:value-of select="@type" />
                            <xsl:value-of select="' '" />
                            <xsl:if test="@role-of-element">
                                in role of <xsl:value-of select="@role-of-element" />
                            </xsl:if>
                        </dd>
                    </xsl:if>
                    <xsl:if test="@description">
                        <dd class="asda_description">
                            <xsl:value-of select="@description" />
                        </dd>
                    </xsl:if>
                </dl>
            </td>
        </tr>
    </xsl:template>

    <xsl:template match="element | property" mode="asda_name">
        <xsl:choose>
            <xsl:when test="@visibility = 'public'"> public </xsl:when>
            <xsl:when test="@visibility = 'protected'"> protected </xsl:when>
            <xsl:when test="@visibility = 'private'"> private </xsl:when>
            <xsl:when test="@visibility = 'package'"> package </xsl:when>
            <xsl:otherwise> public </xsl:otherwise>
        </xsl:choose>
        <xsl:choose>
            <xsl:when test="local-name() = 'element'"> element </xsl:when>
            <xsl:otherwise> property </xsl:otherwise>
        </xsl:choose>
        <xsl:value-of select="@name" />
    </xsl:template>

    <xsl:template match="element | property" mode="short_signature">
        <xsl:value-of select="@name" />
        <xsl:choose>
            <xsl:when test="@type">
                as
                <xsl:choose>
                    <xsl:when test="@reference-to-type"><a href="#{@reference-to-type}" onclick="expandAncestors('{@reference-to-type}')"><xsl:value-of select="@type" /></a></xsl:when>
                    <xsl:otherwise><xsl:value-of select="@type" /></xsl:otherwise>
                </xsl:choose>
            </xsl:when>
            <xsl:when test="@primitive">
                as
                <xsl:choose>
                    <xsl:when test="@primitive = 'integer'"> integer </xsl:when>
                    <xsl:when test="@primitive = 'real'"> real </xsl:when>
                    <xsl:when test="@primitive = 'object'"> object </xsl:when>
                    <xsl:when test="@primitive = 'character'"> character </xsl:when>
                    <xsl:when test="@primitive = 'string'"> string </xsl:when>
                    <xsl:when test="@primitive = 'natural'"> natural </xsl:when>
                    <xsl:when test="@primitive = 'boolean'"> boolean </xsl:when>
                    <xsl:when test="@primitive = 'class'"> class </xsl:when>
                </xsl:choose>
            </xsl:when>
            <xsl:otherwise>
                <em class="comment"> { Warning : the type is not defined} </em>
            </xsl:otherwise>
        </xsl:choose>
        <xsl:choose>
            <xsl:when test="variable">
                by default is (
                <xsl:apply-templates select="variable" />
                )
            </xsl:when>
            <xsl:when test="@value">
                by default is
                <xsl:choose>
                    <xsl:when test="@reference-to-value"><a href="#{@reference-to-value}" onclick="expandAncestors('{@reference-to-value}')"><xsl:value-of select="@value" /></a></xsl:when>
                    <xsl:otherwise><xsl:value-of select="@value" /></xsl:otherwise>
                </xsl:choose>
            </xsl:when>
        </xsl:choose>
    </xsl:template>

</xsl:stylesheet>