<?xml version="1.0" encoding="UTF-8"?>
<!-- Copyright (C) 2014 Oleh Radvanskyj -->
<xsl:stylesheet version="2.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xs="http://www.w3.org/2001/XMLSchema" xmlns:fn="http://www.w3.org/2005/xpath-functions">
    <xsl:output method="html" encoding="UTF-8" />

    <!-- enumerations overview -->

    <xsl:template match="class" mode="overview_enumerations">
        <!-- ECE -->
        <xsl:variable name="canPerformECE1" select="class-protocol/attributes/enumeration-constant-elements or instance-protocol/attributes/enumeration-constant-elements" />
        <xsl:variable name="canPerformECE2" select=".//feature/class-protocol/attributes/enumeration-constant-elements" />
        <xsl:variable name="canPerformECE3" select=".//feature/instance-protocol/attributes/enumeration-constant-elements" />
        <xsl:variable name="canPerformECE" select="$canPerformECE1 or $canPerformECE2 or $canPerformECE3" />
        <!-- ECED -->
        <xsl:variable name="canPerformECED1" select="class-protocol/attributes/enumeration-constant-elements/enumeration-constant-element/@description or instance-protocol/attributes/enumeration-constant-elements/enumeration-constant-element/@description" />
        <xsl:variable name="canPerformECED2" select=".//feature/class-protocol/attributes/enumeration-constant-elements/enumeration-constant-element/@description" />
        <xsl:variable name="canPerformECED3" select=".//feature/instance-protocol/attributes/enumeration-constant-elements/enumeration-constant-element/@description" />
        <xsl:variable name="canPerformECED" select="$canPerformECED1 or $canPerformECED2 or $canPerformECED3" />
        <xsl:if test="$canPerformECE">
            <xsl:choose>
                <xsl:when test="$canPerformECED">
                    <table class="overview">
                        <caption>Enumeration constant element - Description</caption>
                        <thead>
                            <tr>
                                <th>Name</th>
                                <th>Description</th>
                            </tr>
                        </thead>
                        <tbody>
                            <xsl:apply-templates select="feature" mode="eced" />
                            <xsl:apply-templates select="class-protocol/attributes/enumeration-constant-elements/." mode="eced" />
                            <xsl:apply-templates select="instance-protocol/attributes/enumeration-constant-elements/." mode="eced" />
                        </tbody>
                    </table>
                </xsl:when>
                <xsl:otherwise>
                    <table class="overview">
                        <caption>Enumeration constant elements</caption>
                        <thead>
                            <tr>
                                <th>Names</th>
                            </tr>
                        </thead>
                        <tbody>
                            <tr>
                                <td>
                                    <xsl:apply-templates select="feature" mode="ece" />
                                    <xsl:apply-templates select="class-protocol/attributes/enumeration-constant-elements/." mode="ece" />
                                    <xsl:apply-templates select="instance-protocol/attributes/enumeration-constant-elements/." mode="ece" />
                                </td>
                            </tr>
                        </tbody>
                    </table>
                </xsl:otherwise>
            </xsl:choose>
        </xsl:if>
    </xsl:template>

    <!-- Enumeration constant element - Description -->

    <xsl:template match="enumeration-constant-element" mode="eced">
        <tr>
            <td>
                <xsl:choose>
                    <xsl:when test="@id">
                        <a href="#{@id}" onclick="expandAncestors('{@id}')"><xsl:value-of select="@name" /></a>
                    </xsl:when>
                    <xsl:otherwise>
                        <a href="#{generate-id(.)}" onclick="expandAncestors('{generate-id(.)}')"><xsl:value-of select="@name" /></a>
                    </xsl:otherwise>
                </xsl:choose>
            </td>
            <td>
                <xsl:value-of select="@description" />
            </td>
        </tr>
    </xsl:template>

    <xsl:template match="feature" mode="eced">
        <xsl:apply-templates select="feature" mode="eced" />
        <xsl:apply-templates select="class-protocol/attributes/enumeration-constant-elements/." mode="eced" />
        <xsl:apply-templates select="instance-protocol/attributes/enumeration-constant-elements/." mode="eced" />
    </xsl:template>

    <!-- Enumeration constant element -->

    <xsl:template match="enumeration-constant-element" mode="ece">
        <xsl:choose>
            <xsl:when test="@id">
                <a href="#{@id}" onclick="expandAncestors('{@id}')"><xsl:value-of select="@name" /></a>
            </xsl:when>
            <xsl:otherwise>
                <a href="#{generate-id(.)}" onclick="expandAncestors('{generate-id(.)}')"><xsl:value-of select="@name" /></a>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>

    <xsl:template match="feature" mode="ece">
        <xsl:apply-templates select="feature" mode="ece" />
        <xsl:apply-templates select="class-protocol/attributes/enumeration-constant-elements/." mode="ece" />
        <xsl:apply-templates select="instance-protocol/attributes/enumeration-constant-elements/." mode="ece" />
    </xsl:template>

</xsl:stylesheet>