<?xml version="1.0" encoding="UTF-8"?>
<!-- Copyright (C) 2013 Oleh Radvanskyj -->
<xsl:stylesheet version="2.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xs="http://www.w3.org/2001/XMLSchema" xmlns:fn="http://www.w3.org/2005/xpath-functions">
    <xsl:output method="html" encoding="UTF-8" />

    <!-- interface overview -->

    <xsl:template match="interface" mode="overview">
        <xsl:if test="method">
            <h4 onclick="toggleTag('{generate-id(.)}-overview')">Overview</h4>
            <div id="{generate-id(.)}-overview" class="indent" style="display:none">
                <xsl:apply-templates select="." mode="overview_content" />
            </div>
        </xsl:if>
    </xsl:template>

    <xsl:template match="interface" mode="overview_content">
        <table class="overview">
            <caption>Method - Signature / Description</caption>
            <thead>
                <tr>
                    <th>Name</th>
                    <th>Signature / Description</th>
                </tr>
            </thead>
            <tbody>
                <xsl:apply-templates select="method" mode="msd" />
                <xsl:apply-templates select="thread" mode="msd" />
            </tbody>
        </table>
    </xsl:template>

</xsl:stylesheet>