<?xml version="1.0" encoding="UTF-8"?>
<!-- Copyright (C) 2014 Oleh Radvanskyj -->
<xsl:stylesheet version="2.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xs="http://www.w3.org/2001/XMLSchema" xmlns:fn="http://www.w3.org/2005/xpath-functions">
    <xsl:output method="html" encoding="UTF-8" />

    <!-- test procedures overview -->

    <xsl:template match="class" mode="overview_test_procedures">
        <!-- TPSD -->
        <xsl:variable name="canPerformTPSD1" select="test-procedures" />
        <xsl:variable name="canPerformTPSD2" select=".//feature/test-procedures" />
        <xsl:variable name="canPerformTPSD" select="$canPerformTPSD1 or $canPerformTPSD2" />
        <xsl:if test="$canPerformTPSD">
            <table class="overview">
                <caption>Test procedure - Signature / Description</caption>
                <thead>
                    <tr>
                        <th>Name</th>
                        <th>Signature / Description</th>
                    </tr>
                </thead>
                <tbody>
                    <xsl:apply-templates select="test-procedures/test-procedure" mode="tpsd" />
                    <xsl:apply-templates select="feature" mode="tpsd" />
                </tbody>
            </table>
        </xsl:if>
    </xsl:template>

    <xsl:template match="feature" mode="tpsd">
        <xsl:apply-templates select="test-procedures/test-procedure" mode="tpsd" />
        <xsl:apply-templates select="feature" mode="tpsd" />
    </xsl:template>

</xsl:stylesheet>