<?xml version="1.0" encoding="UTF-8"?>
<!-- Copyright (C) 2012 Oleh Radvanskyj -->
<xsl:stylesheet version="2.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xs="http://www.w3.org/2001/XMLSchema" xmlns:fn="http://www.w3.org/2005/xpath-functions">
    <xsl:output method="html" encoding="UTF-8" indent="yes"/>

    <!-- classes overview -->

    <xsl:template match="solution | implementation | package | model | realization | capsule | function | test-procedure | constructor | destructor | method | operator | thread | set-property | get-property | static | common-view | view" mode="overview_classes">
        <xsl:if test="classes">
            <table class="overview">
                <caption>Class - Description</caption>
                <thead>
                    <tr>
                        <th>Name</th>
                        <th>Description</th>
                    </tr>
                </thead>
                <tbody>
                    <xsl:apply-templates select="classes/interface" mode="cd" />
                    <xsl:apply-templates select="classes/class" mode="cd" />
                </tbody>
            </table>
            <table class="overview">
                <caption>Class - Responsibilities - Collaboration</caption>
                <thead>
                    <tr>
                        <th>Name</th>
                        <th>Responsibilities</th>
                        <th>Collaboration</th>
                    </tr>
                </thead>
                <tbody>
                    <xsl:apply-templates select="classes/interface" mode="crc" />
                    <xsl:apply-templates select="classes/class" mode="crc" />
                </tbody>
            </table>
        </xsl:if>
    </xsl:template>

</xsl:stylesheet>