<?xml version="1.0" encoding="UTF-8"?>
<!-- Copyright (C) 2014 Oleh Radvanskyj -->
<xsl:stylesheet version="2.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xs="http://www.w3.org/2001/XMLSchema" xmlns:fn="http://www.w3.org/2005/xpath-functions">
    <xsl:output method="html" encoding="UTF-8" />

    <!-- interface - description -->

    <xsl:template match="interface" mode="overview_name">
        <xsl:choose>
            <xsl:when test="@package">interface <xsl:value-of select="@package" /> :: <xsl:value-of select="@name" /></xsl:when>
            <xsl:otherwise>interface <xsl:value-of select="@name" /></xsl:otherwise>
        </xsl:choose>
    </xsl:template>

    <xsl:template match="interface" mode="cd">
        <tr>
            <td>
                <xsl:choose>
                    <xsl:when test="@id"><a href="#{@id}" onclick="expandAncestors('{@id}')"><xsl:apply-templates select="." mode="overview_name" /></a></xsl:when>
                    <xsl:otherwise><a href="#{generate-id(.)}-header" onclick="expandAncestors('{generate-id(.)}-header')"><xsl:apply-templates select="." mode="overview_name" /></a></xsl:otherwise>
                </xsl:choose>
            </td>
            <td><xsl:apply-templates select="description" mode="overview" /></td>
        </tr>
    </xsl:template>

    <xsl:template match="interface/description" mode="overview">
        <xsl:apply-templates />
    </xsl:template>

</xsl:stylesheet>