<?xml version="1.0" encoding="UTF-8"?>
<!-- Copyright (C) 2013 Oleh Radvanskyj -->
<xsl:stylesheet version="2.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xs="http://www.w3.org/2001/XMLSchema" xmlns:fn="http://www.w3.org/2005/xpath-functions">
	<xsl:output method="html" encoding="UTF-8" />

	<!-- condition -->

	<xsl:template match="signals">
		<h4>Signals</h4>
		<ul class="attributes">
			<xsl:for-each select="signal">
				<xsl:choose>
					<xsl:when test="@id"><li id="{@id}"><xsl:value-of select="@name" /> means <xsl:apply-templates select="." mode="content" /></li></xsl:when>
					<xsl:otherwise><li id="{generate-id(.)}"><xsl:value-of select="@name" /> means <xsl:apply-templates select="." mode="content" /></li></xsl:otherwise>
				</xsl:choose>
			</xsl:for-each>
		</ul>
	</xsl:template>	

	<xsl:template match="invariant/screen | precondition/screen | postcondition/screen"></xsl:template>

    <xsl:template match="invariant/diagram | precondition/diagram | postcondition/diagram"></xsl:template>

    <xsl:template match="precondition">
        <h4>
            Precondition
            <xsl:if test="@name">
                named as <xsl:value-of select="@name" />
            </xsl:if>
        </h4>
        <div class="indent">
            <xsl:apply-templates select="." mode="content" />
        </div>
    </xsl:template>

    <xsl:template match="postcondition">
        <h4>
            Postcondition
            <xsl:if test="@name">
                named as <xsl:value-of select="@name" />
            </xsl:if>
        </h4>
        <div class="indent">
            <xsl:apply-templates select="." mode="content" />
        </div>
    </xsl:template>

	<xsl:template match="state">
		<h4>
			State
			<xsl:if test="@name">
				named as <xsl:value-of select="@name" />
			</xsl:if>
		</h4>
		<div class="indent">
			<xsl:apply-templates select="." mode="content" />
		</div>
	</xsl:template>

	<xsl:template match="requirement">
		<h4>
			Requirement
			<xsl:if test="@name">
				named as <xsl:value-of select="@name" />
			</xsl:if>
		</h4>
		<div class="indent">
			assert that <xsl:apply-templates select="." mode="content" />
		</div>
	</xsl:template>
	
	<xsl:template match="condition">
		<xsl:apply-templates select="." mode="content" />
	</xsl:template>
	
	<xsl:template match="invariant | condition | precondition | postcondition | state | requirement | signal" mode="content">
		<xsl:variable name="isInner1" select="local-name(parent::node()) = 'condition'" />
		<xsl:variable name="isInner2" select="local-name(parent::node()) = 'precondition'" />
		<xsl:variable name="isInner3" select="local-name(parent::node()) = 'postcondition'" />
		<xsl:variable name="isInner4" select="local-name(parent::node()) = 'state'" />
		<xsl:variable name="isInner5" select="local-name(parent::node()) = 'requirement'" />
		<xsl:variable name="isInner6" select="local-name(parent::node()) = 'signal'" />
		<xsl:variable name="isInner7" select="@compute = 'yes'" />
		<xsl:variable name="isInner8" select="@deprecate = 'yes'" />
		<xsl:variable name="isInner9" select="@deprecate = 'no'" />
        <xsl:variable name="isInner10" select="local-name(parent::node()) = 'for-all'" />
        <xsl:variable name="isInner11" select="local-name(parent::node()) = 'exists'" />
        <xsl:variable name="isInner12" select="local-name(parent::node()) = 'invariant'" />
		<xsl:variable name="isInnerForDescendants" select="$isInner1 or $isInner2 or $isInner3 or $isInner4 or $isInner5 or $isInner6 or $isInner7 or $isInner8 or $isInner9 or $isInner10 or $isInner11 or $isInner12" />
		<xsl:variable name="isInnerForObject" select="$isInner7" />	
		<xsl:variable name="isInnerForObjectInState" select="$isInner7" />	
		<xsl:variable name="isInnerForAssertion" select="$isInner7 or $isInner8 or $isInner9" />	
		<xsl:choose>
			<xsl:when test="condition or in or instance-of or for-all or exists">
				<xsl:if test="@compute = 'yes'"> compute </xsl:if>
				<xsl:choose>
					<xsl:when test="$isInnerForDescendants">
						( <xsl:apply-templates /> )
					</xsl:when>
					<xsl:otherwise>
						<xsl:apply-templates />
					</xsl:otherwise>
				</xsl:choose>
				<xsl:choose>
					<xsl:when test="@deprecate = 'yes'"> is false </xsl:when>
					<xsl:when test="@deprecate = 'no'"> is true </xsl:when>
				</xsl:choose>					
			</xsl:when>
			<xsl:when test="@object">
				<xsl:if test="@compute = 'yes'"> compute </xsl:if>
				<xsl:choose>
					<xsl:when test="@state">
						<xsl:choose>
							<xsl:when test="$isInnerForObjectInState">
								( <xsl:apply-templates select="." mode="object_is_in_state" /> )
							</xsl:when>
							<xsl:otherwise>
								<xsl:apply-templates select="." mode="object_is_in_state" />
							</xsl:otherwise>
						</xsl:choose>						
					</xsl:when>
					<xsl:otherwise>
						<xsl:choose>
							<xsl:when test="$isInnerForObject">
								( <xsl:apply-templates select="." mode="object" /> )
							</xsl:when>
							<xsl:otherwise>
								<xsl:apply-templates select="." mode="object" />
							</xsl:otherwise>
						</xsl:choose>		
					</xsl:otherwise>
				</xsl:choose>
			</xsl:when>
			<xsl:when test="@assertion">
				<xsl:if test="@compute = 'yes'"> compute </xsl:if>
				<xsl:choose>
					<xsl:when test="$isInnerForAssertion">
						( <xsl:apply-templates select="." mode="assertion" /> )
					</xsl:when>
					<xsl:otherwise>
						<xsl:apply-templates select="." mode="assertion" />
					</xsl:otherwise>
				</xsl:choose>				
				<xsl:choose>
					<xsl:when test="@deprecate = 'yes'"> is false </xsl:when>
					<xsl:when test="@deprecate = 'no'"> is true </xsl:when>
				</xsl:choose>
			</xsl:when>
			<xsl:otherwise>
				<em class="comment"> { Warning : the condition is not defined } </em>
			</xsl:otherwise>
		</xsl:choose>
		<xsl:if test="@description"> <em class="comment"> { Description : <xsl:value-of select="@description" /> } </em> </xsl:if>
	</xsl:template>
	
	<xsl:template match="invariant | condition | precondition | postcondition | state | requirement | signal" mode="object">
		<xsl:if test="@deprecate = 'yes'"> not </xsl:if>
		<xsl:choose>
			<xsl:when test="@reference-to-object"><a href="#{@reference-to-object}" onclick="expandAncestors('{@reference-to-object}')"><xsl:value-of select="@object" /></a></xsl:when>
			<xsl:otherwise><xsl:value-of select="@object" /></xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	
	<xsl:template match="invariant | condition | precondition | postcondition | state | requirement | signal" mode="object_is_in_state">
		<xsl:choose>
			<xsl:when test="@reference-to-object"><a href="#{@reference-to-object}" onclick="expandAncestors('{@reference-to-object}')"><xsl:value-of select="@object" /></a></xsl:when>
			<xsl:otherwise><xsl:value-of select="@object" /></xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="@deprecate = 'yes'"> is not </xsl:when>
			<xsl:otherwise> is </xsl:otherwise>
		</xsl:choose>							
		<xsl:choose>
			<xsl:when test="@reference-to-state"><a href="#{@reference-to-state}" onclick="expandAncestors('{@reference-to-state}')"><xsl:value-of select="@state" /></a></xsl:when>
			<xsl:otherwise><xsl:value-of select="@state" /></xsl:otherwise>
		</xsl:choose>
	</xsl:template>	
	
	<xsl:template match="invariant | condition | precondition | postcondition | state | requirement | signal" mode="assertion">
		<xsl:choose>
			<xsl:when test="@reference-to-assertion"><a href="#{@reference-to-assertion}" onclick="expandAncestors('{@reference-to-assertion}')"><xsl:value-of select="@assertion" /></a></xsl:when>
			<xsl:otherwise><xsl:value-of select="@assertion" /></xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	
	<xsl:template match="or">
		<xsl:choose>
			<xsl:when test="@indication = 'exclusive'"> xor </xsl:when>
			<xsl:otherwise> or </xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	
	<xsl:template match="and">
		 and 
	</xsl:template>
	
	<xsl:template match="in">
		<xsl:choose>
			<xsl:when test="@reference-to-element">
				<a href="#{@reference-to-element}" onclick="expandAncestors('{@reference-to-element}')"><xsl:value-of select="@element" /></a></xsl:when>
			<xsl:otherwise><xsl:value-of select="@element" /></xsl:otherwise>
		</xsl:choose>
		in 
		<xsl:choose>
			<xsl:when test="@reference-to-set"><a href="#{@reference-to-set}" onclick="expandAncestors('{@reference-to-set}')"><xsl:value-of select="@set" /></a></xsl:when>
			<xsl:otherwise><xsl:value-of select="@set" /></xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	
	<xsl:template match="instance-of">
		<xsl:choose>
			<xsl:when test="@reference-to-variable">
				<a href="#{@reference-to-variable}" onclick="expandAncestors('{@reference-to-variable}')"><xsl:value-of select="@variable" /></a></xsl:when>
			<xsl:otherwise><xsl:value-of select="@variable" /></xsl:otherwise>
		</xsl:choose>
		instance of
		<xsl:choose>
			<xsl:when test="@reference-to-type">
				<a href="#{@reference-to-type}" onclick="expandAncestors('{@reference-to-type}')"><xsl:value-of select="@type" /></a></xsl:when>
			<xsl:otherwise><xsl:value-of select="@type" /></xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	
	<xsl:template match="greater-than">
		<xsl:choose>
			<xsl:when test="@indication = 'inclusive'"> is greater than or equal to </xsl:when>
			<xsl:otherwise> is greater than </xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	
	<xsl:template match="less-than">
		<xsl:choose>
			<xsl:when test="@indication = 'inclusive'"> is less than or equal to </xsl:when>
			<xsl:otherwise> is less than </xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	
	<xsl:template match="equal-to">
		<xsl:choose>
			<xsl:when test="@deprecate = 'yes'"> is not equal to </xsl:when>
			<xsl:otherwise> is equal to </xsl:otherwise>
		</xsl:choose>
	</xsl:template>

    <xsl:template match="implies">
        implies
    </xsl:template>

    <xsl:template match="for-all">
        for all
        <xsl:choose>
            <xsl:when test="@reference-to-element">
                <a href="#{@reference-to-element}" onclick="expandAncestors('{@reference-to-element}')"><xsl:value-of select="@element" /></a></xsl:when>
            <xsl:otherwise><xsl:value-of select="@element" /></xsl:otherwise>
        </xsl:choose>
        in
        <xsl:choose>
            <xsl:when test="@reference-to-array"><a href="#{@reference-to-array}" onclick="expandAncestors('{@reference-to-array}')"><xsl:value-of select="@array" /></a></xsl:when>
            <xsl:otherwise><xsl:value-of select="@array" /></xsl:otherwise>
        </xsl:choose>
        ensure
        <xsl:apply-templates />
    </xsl:template>

    <xsl:template match="exists">
        exists
        <xsl:choose>
            <xsl:when test="@reference-to-element">
                <a href="#{@reference-to-element}" onclick="expandAncestors('{@reference-to-element}')"><xsl:value-of select="@element" /></a></xsl:when>
            <xsl:otherwise><xsl:value-of select="@element" /></xsl:otherwise>
        </xsl:choose>
        in
        <xsl:choose>
            <xsl:when test="@reference-to-array"><a href="#{@reference-to-array}" onclick="expandAncestors('{@reference-to-array}')"><xsl:value-of select="@array" /></a></xsl:when>
            <xsl:otherwise><xsl:value-of select="@array" /></xsl:otherwise>
        </xsl:choose>
        ensure
        <xsl:apply-templates />
    </xsl:template>

</xsl:stylesheet>