<?xml version="1.0" encoding="UTF-8"?>
<!-- Copyright (C) 2013 Oleh Radvanskyj -->
<xsl:stylesheet version="2.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xs="http://www.w3.org/2001/XMLSchema" xmlns:fn="http://www.w3.org/2005/xpath-functions">
	<xsl:output method="html" encoding="UTF-8" />
	
	<!-- cycles -->
	
	<!-- while -->
	
	<xsl:template match="while">
		<xsl:choose>
			<xsl:when test="@label">
				<li id="{@label}"> <xsl:value-of select="@label" /> : while <xsl:apply-templates select="condition" /> do
					<xsl:apply-templates select="do" />
				</li>
			</xsl:when>
			<xsl:otherwise>
				<li> while <xsl:apply-templates select="condition" /> do
					<xsl:apply-templates select="do" />
				</li>
			</xsl:otherwise>
		</xsl:choose>
		<li> end while </li>	
	</xsl:template>
	
	<!-- until -->
	
	<xsl:template match="until">
		<xsl:choose>
			<xsl:when test="@label">
				<li id="{@label}"> <xsl:value-of select="@label" /> :  repeat <xsl:apply-templates select="do" /></li>
			</xsl:when>
			<xsl:otherwise>
				<li> repeat <xsl:apply-templates select="do" /></li>
			</xsl:otherwise>
		</xsl:choose>
		<li> until <xsl:apply-templates select="condition" /></li>
	</xsl:template>
	
	<!-- for -->
	
	<xsl:template match="for">
		<xsl:choose>
			<xsl:when test="@label"><li id="{@label}"><xsl:value-of select="@label" /> : <xsl:apply-templates select="." mode="content" /></li></xsl:when>
			<xsl:otherwise><li><xsl:apply-templates select="." mode="content" /></li></xsl:otherwise>
		</xsl:choose>
		<li> end for </li>
	</xsl:template>
	
	<xsl:template match="for" mode="content">
		for counter
		<xsl:choose>
			<xsl:when test="@reference-to-counter"><a href="#{@reference-to-counter}" onclick="expandAncestors('{@reference-to-counter}')"><xsl:value-of select="@counter" /></a></xsl:when>
			<xsl:otherwise><xsl:value-of select="@counter" /></xsl:otherwise>
		</xsl:choose>
		from 
		<xsl:choose>
			<xsl:when test="@reference-to-from"><a href="#{@reference-to-from}" onclick="expandAncestors('{@reference-to-from}')"><xsl:value-of select="@from" /></a></xsl:when>
			<xsl:otherwise><xsl:value-of select="@from" /></xsl:otherwise>
		</xsl:choose>
		to  
		<xsl:choose>
			<xsl:when test="@reference-to-to"><a href="#{@reference-to-to}" onclick="expandAncestors('{@reference-to-to}')"><xsl:value-of select="@to" /></a></xsl:when>
			<xsl:otherwise><xsl:value-of select="@to" /></xsl:otherwise>
		</xsl:choose>
		<xsl:if test="@by">
			by
			<xsl:choose>
				<xsl:when test="@reference-to-by"><a href="#{@reference-to-by}" onclick="expandAncestors('{@reference-to-by}')"><xsl:value-of select="@by" /></a></xsl:when>
				<xsl:otherwise><xsl:value-of select="@by" /></xsl:otherwise>
			</xsl:choose>
		</xsl:if>
		do 
		<ol><xsl:apply-templates /></ol>		
	</xsl:template>
	
	<!-- for-each -->
	
	<xsl:template match="for-each">
		<xsl:choose>
			<xsl:when test="@label"><li id="{@label}"><xsl:value-of select="@label" /> : <xsl:apply-templates select="." mode="content" /></li></xsl:when>
			<xsl:otherwise><li><xsl:apply-templates select="." mode="content" /></li></xsl:otherwise>
		</xsl:choose>
		<li> end for each </li>
	</xsl:template>
	
	<xsl:template match="for-each" mode="content">
		for each 
		<xsl:choose>
			<xsl:when test="@reference-to-element"><a href="#{@reference-to-element}" onclick="expandAncestors('{@reference-to-element}')"><xsl:value-of select="@element" /></a></xsl:when>
			<xsl:otherwise><xsl:value-of select="@element" /></xsl:otherwise>
		</xsl:choose>
		in 
		<xsl:choose>
			<xsl:when test="@reference-to-array"><a href="#{@reference-to-array}" onclick="expandAncestors('{@reference-to-array}')"><xsl:value-of select="@array" /></a></xsl:when>
			<xsl:otherwise><xsl:value-of select="@array" /></xsl:otherwise>
		</xsl:choose>
		do 
		<ol><xsl:apply-templates /></ol>
	</xsl:template>

	<!-- for-in-parallel -->
	
	<xsl:template match="for-in-parallel">
		<xsl:choose>
			<xsl:when test="@label"><li id="{@label}"><xsl:value-of select="@label" /> : <xsl:apply-templates select="." mode="content" /></li></xsl:when>
			<xsl:otherwise><li><xsl:apply-templates select="." mode="content" /></li></xsl:otherwise>
		</xsl:choose>
		<li> end for in parallel </li>
	</xsl:template>
	
	<xsl:template match="for-in-parallel" mode="content">
		for counter
		<xsl:choose>
			<xsl:when test="@reference-to-counter"><a href="#{@reference-to-counter}" onclick="expandAncestors('{@reference-to-counter}')"><xsl:value-of select="@counter" /></a></xsl:when>
			<xsl:otherwise><xsl:value-of select="@counter" /></xsl:otherwise>
		</xsl:choose>
		from 
		<xsl:choose>
			<xsl:when test="@reference-to-from"><a href="#{@reference-to-from}" onclick="expandAncestors('{@reference-to-from}')"><xsl:value-of select="@from" /></a></xsl:when>
			<xsl:otherwise><xsl:value-of select="@from" /></xsl:otherwise>
		</xsl:choose>
		to  
		<xsl:choose>
			<xsl:when test="@reference-to-to"><a href="#{@reference-to-to}" onclick="expandAncestors('{@reference-to-to}')"><xsl:value-of select="@to" /></a></xsl:when>
			<xsl:otherwise><xsl:value-of select="@to" /></xsl:otherwise>
		</xsl:choose>
		<xsl:if test="@by">
			by
			<xsl:choose>
				<xsl:when test="@reference-to-by"><a href="#{@reference-to-by}" onclick="expandAncestors('{@reference-to-by}')"><xsl:value-of select="@by" /></a></xsl:when>
				<xsl:otherwise><xsl:value-of select="@by" /></xsl:otherwise>
			</xsl:choose>
		</xsl:if>
		do in parallel
		<ol><xsl:apply-templates /></ol>		
	</xsl:template>
	
	<!-- for-each-in-parallel -->
	
	<xsl:template match="for-each-in-parallel">
		<xsl:choose>
			<xsl:when test="@label"><li id="{@label}"><xsl:value-of select="@label" /> : <xsl:apply-templates select="." mode="content" /></li></xsl:when>
			<xsl:otherwise><li><xsl:apply-templates select="." mode="content" /></li></xsl:otherwise>
		</xsl:choose>
		<li> end for each in parallel </li>
	</xsl:template>
	
	<xsl:template match="for-each-in-parallel" mode="content">
		for each 
		<xsl:choose>
			<xsl:when test="@reference-to-element"><a href="#{@reference-to-element}" onclick="expandAncestors('{@reference-to-element}')"><xsl:value-of select="@element" /></a></xsl:when>
			<xsl:otherwise><xsl:value-of select="@element" /></xsl:otherwise>
		</xsl:choose>
		in 
		<xsl:choose>
			<xsl:when test="@reference-to-array"><a href="#{@reference-to-array}" onclick="expandAncestors('{@reference-to-array}')"><xsl:value-of select="@array" /></a></xsl:when>
			<xsl:otherwise><xsl:value-of select="@array" /></xsl:otherwise>
		</xsl:choose>
		do in perallel
		<ol><xsl:apply-templates /></ol>
	</xsl:template>	
	
	<!-- cycle -->
	
	<xsl:template match="cycle">
		<xsl:choose>
			<xsl:when test="@label"><li id="{@label}"><xsl:value-of select="@label" /> : <xsl:apply-templates select="." mode="content" /></li></xsl:when> 
			<xsl:otherwise><li><xsl:apply-templates select="." mode="content" /></li></xsl:otherwise>
		</xsl:choose>
		<li> end cycle </li>
	</xsl:template>
	
	<xsl:template match="cycle" mode="content">
		cycle (
		<xsl:if test="@preparatory"> 
			preparatory step : 
			<xsl:choose>
				<xsl:when test="@reference-to-preparatory"><a href="#{@reference-to-preparatory}" onclick="expandAncestors('{@reference-to-preparatory}')"><xsl:value-of select="@preparatory" /></a></xsl:when>
				<xsl:otherwise><xsl:value-of select="@preparatory" /></xsl:otherwise>
			</xsl:choose>
			;
		</xsl:if>
		condition : <xsl:apply-templates select="condition" />
		<xsl:if test="@concluding">
			;
			concluding step : 
			<xsl:choose>
				<xsl:when test="@reference-to-concluding"><a href="#{@reference-to-concluding}" onclick="expandAncestors('{@reference-to-concluding}')"><xsl:value-of select="@concluding" /></a></xsl:when>
				<xsl:otherwise><xsl:value-of select="@concluding" /></xsl:otherwise>
			</xsl:choose>
		</xsl:if>
		) do
		<xsl:apply-templates select="do" />
	</xsl:template>
	
	<!-- loop-forever -->
	
	<xsl:template match="loop-forever">
		<xsl:choose>
			<xsl:when test="@label">
				<li id="{@label}"><xsl:value-of select="@label" /> :  loop forever
					<ol><xsl:apply-templates /></ol>
				</li>
			</xsl:when>
			<xsl:otherwise>
				<li> loop forever
					<ol><xsl:apply-templates /></ol>
				</li>
			</xsl:otherwise>
		</xsl:choose>
		<li> end loop forever </li>
	</xsl:template>
	
</xsl:stylesheet>